/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Objects;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class URI
extends AbstractXJdfType<String, URI> {
    private final InputStream sourceInputStream;
    private final java.net.URI sourceUri;
    private String destinationPath;
    private final String stashedDestinationPath;

    public URI() {
        this.sourceInputStream = null;
        this.sourceUri = null;
        this.stashedDestinationPath = null;
    }

    public URI(String sourceUri) throws URISyntaxException {
        this(new java.net.URI(sourceUri));
    }

    public URI(java.net.URI sourceUri) {
        this.sourceInputStream = null;
        this.sourceUri = sourceUri.normalize();
        this.stashedDestinationPath = null;
    }

    public URI(java.net.URI sourceUri, String destPath) throws URISyntaxException {
        this(sourceUri, null, destPath);
    }

    public URI(byte[] source, String destPath) throws URISyntaxException {
        this(new ByteArrayInputStream(source), destPath);
    }

    public URI(InputStream source, String destPath) throws URISyntaxException {
        this(new java.net.URI(destPath), source, destPath);
    }

    private URI(java.net.URI sourceUri, InputStream sourceInputStream, String destPath) throws URISyntaxException {
        Objects.requireNonNull(destPath, "destPath must not be null");
        this.sourceInputStream = sourceInputStream;
        this.sourceUri = sourceUri.normalize();
        this.stashedDestinationPath = new java.net.URI(null, null, destPath, null).normalize().getPath();
    }

    public final java.net.URI getSourceUri() {
        return this.sourceUri;
    }

    public final InputStream getSourceInputStream() {
        return this.sourceInputStream;
    }

    public final String getDestinationPath() {
        return this.destinationPath;
    }

    public final URI complete() {
        this.destinationPath = this.stashedDestinationPath;
        return this;
    }

    public final String marshal(URI v) {
        if (v == null) {
            return null;
        }
        return v.destinationPath == null ? v.sourceUri.toString() : v.destinationPath;
    }

    public final URI unmarshal(String v) throws Exception {
        java.net.URI source = new java.net.URI(v);
        if (source.isAbsolute()) {
            return new URI(source);
        }
        return new URI(source, source.getPath());
    }

    @Override
    public final String toString() {
        return "URI{sourceUri=" + this.sourceUri + ", destinationPath=" + this.destinationPath + "}";
    }
}

