/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import java.util.List;
import org.cip4.lib.xjdf.schema.DeviceInfo;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.SimpleValidator;

public class DeviceInfoValidator
extends SimpleValidator<DeviceInfo> {
    @Override
    public final void validate(DeviceInfo deviceInfo, Ancestors ancestors, ValidationResultBuilder validationResult) {
        this.validateFileSpec(deviceInfo, validationResult);
        this.validateIdleStartTime(deviceInfo, validationResult);
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof DeviceInfo;
    }

    private void validateIdleStartTime(DeviceInfo deviceInfo, ValidationResultBuilder resultBuilder) {
        if (null != deviceInfo.getIdleStartTime() && null != deviceInfo.getJobPhase() && !deviceInfo.getJobPhase().isEmpty()) {
            resultBuilder.append("//DeviceInfo/@IdleStartTime SHALL NOT be specified if JobPhase Elements are present in the DeviceInfo");
        }
    }

    private void validateFileSpec(DeviceInfo deviceInfo, ValidationResultBuilder validationResult) {
        List<FileSpec> fileSpecs = deviceInfo.getFileSpec();
        for (FileSpec fileSpec : fileSpecs) {
            if ("Schema".equals(fileSpec.getResourceUsage()) || "CurrentSchema".equals(fileSpec.getResourceUsage())) continue;
            validationResult.append(String.format("Element DeviceInfo may only contain FileSpec with @ResourceUsage='Schema', but @ResourceUsage='%s' was given", fileSpec.getResourceUsage()));
        }
    }
}

