/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.merger;

import java.util.Collection;
import org.cip4.lib.xjdf.merger.MergeConflictException;

abstract class BaseMerger<T> {
    BaseMerger() {
    }

    abstract void merge(T var1, T var2) throws MergeConflictException;

    boolean isMergeable(Object baseObject, Object mergeObject) {
        return baseObject.getClass().isAssignableFrom(mergeObject.getClass()) && mergeObject.getClass().isAssignableFrom(baseObject.getClass());
    }

    void merge(Collection<T> baseObjects, Collection<T> mergeObjects) throws MergeConflictException {
        for (T mergeObject : mergeObjects) {
            this.merge(baseObjects, mergeObject);
        }
    }

    void merge(Collection<T> baseObjects, T mergeObject) throws MergeConflictException {
        for (T baseObject : baseObjects) {
            if (!this.isMergeable(baseObject, mergeObject)) continue;
            this.merge(baseObject, mergeObject);
            return;
        }
        baseObjects.add(mergeObject);
    }
}

