/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.merger;

import java.util.List;
import org.cip4.lib.xjdf.merger.BaseMerger;
import org.cip4.lib.xjdf.merger.MergeConflictException;

class CombinedMerger<T>
extends BaseMerger<T> {
    private final List<BaseMerger<? extends T>> mergers;

    CombinedMerger(List<BaseMerger<? extends T>> mergers) {
        this.mergers = mergers;
    }

    @Override
    void merge(T baseObject, T mergeObject) throws MergeConflictException {
        BaseMerger<T> merger = this.getMatchingMerger(baseObject, mergeObject);
        merger.merge(baseObject, mergeObject);
    }

    @Override
    boolean isMergeable(Object baseObject, Object mergeObject) {
        return null != this.getMatchingMerger(baseObject, mergeObject);
    }

    BaseMerger<? extends T> getMatchingMerger(Object baseObject, Object mergeObject) {
        for (BaseMerger<T> merger : this.mergers) {
            if (!merger.isMergeable(baseObject, mergeObject)) continue;
            return merger;
        }
        return null;
    }
}

