/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.merger;

import java.util.Collection;
import org.cip4.lib.xjdf.merger.BaseMerger;
import org.cip4.lib.xjdf.merger.MergeConflictException;
import org.cip4.lib.xjdf.merger.ProductListMerger;
import org.cip4.lib.xjdf.merger.ProductMerger;
import org.cip4.lib.xjdf.merger.ResourceSetMerger;
import org.cip4.lib.xjdf.schema.ProductList;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.XJDF;

public class XjdfMerger
extends BaseMerger<XJDF> {
    private final BaseMerger<ProductList> productListMerger;
    private final BaseMerger<ResourceSet> resourceSetMerger;

    XjdfMerger(BaseMerger<ProductList> productListMerger, BaseMerger<ResourceSet> resourceSetMerger) {
        this.productListMerger = productListMerger;
        this.resourceSetMerger = resourceSetMerger;
    }

    public XjdfMerger() {
        this.productListMerger = new ProductListMerger(new ProductMerger());
        this.resourceSetMerger = new ResourceSetMerger();
    }

    public final XJDF merge(XJDF ... xjdfs) throws MergeConflictException {
        XJDF resultingXjdf = new XJDF();
        for (XJDF xjdf : xjdfs) {
            this.merge(resultingXjdf, xjdf);
        }
        return resultingXjdf;
    }

    @Override
    final void merge(XJDF baseObject, XJDF mergeObject) throws MergeConflictException {
        if (null != mergeObject.getProductList()) {
            if (null == baseObject.getProductList()) {
                baseObject.setProductList(mergeObject.getProductList());
            } else {
                this.productListMerger.merge(baseObject.getProductList(), mergeObject.getProductList());
            }
        }
        baseObject.getGeneralID().addAll(mergeObject.getGeneralID());
        this.resourceSetMerger.merge((Collection<ResourceSet>)baseObject.getResourceSet(), (ResourceSet)((Object)mergeObject.getResourceSet()));
    }
}

