/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.Locale;
import org.cip4.lib.xjdf.type.AbstractXJdfType;
import org.cip4.lib.xjdf.type.XYPair;

public class Rectangle
extends AbstractXJdfType<String, Rectangle> {
    private final float llx;
    private final float lly;
    private final float urx;
    private final float ury;

    public Rectangle() {
        this.llx = 0.0f;
        this.lly = 0.0f;
        this.urx = 0.0f;
        this.ury = 0.0f;
    }

    public Rectangle(float llx, float lly, float urx, float ury) {
        this.llx = llx;
        this.lly = lly;
        this.urx = urx;
        this.ury = ury;
    }

    public Rectangle(XYPair lowerLeft, XYPair upperRight) {
        this.llx = lowerLeft.getX();
        this.lly = lowerLeft.getY();
        this.urx = upperRight.getX();
        this.ury = upperRight.getY();
    }

    public Rectangle(String expression) {
        String[] s = expression.split(" ");
        this.llx = Float.parseFloat(s[0]);
        this.lly = Float.parseFloat(s[1]);
        this.urx = Float.parseFloat(s[2]);
        this.ury = Float.parseFloat(s[3]);
    }

    public float getLlx() {
        return this.llx;
    }

    public float getLly() {
        return this.lly;
    }

    public float getUrx() {
        return this.urx;
    }

    public float getUry() {
        return this.ury;
    }

    public float getWidth() {
        return this.urx - this.llx;
    }

    public float getHeight() {
        return this.ury - this.lly;
    }

    public XYPair getSize() {
        return new XYPair(this.getWidth(), this.getHeight());
    }

    public XYPair getLowerLeft() {
        return new XYPair(this.llx, this.lly);
    }

    public XYPair getUpperRight() {
        return new XYPair(this.urx, this.ury);
    }

    public String marshal(Rectangle v) {
        if (v == null) {
            return null;
        }
        float llx = v.getLlx();
        float lly = v.getLly();
        float urx = v.getUrx();
        float ury = v.getUry();
        return String.format(Locale.US, "%.3f %.3f %.3f %.3f", Float.valueOf(llx), Float.valueOf(lly), Float.valueOf(urx), Float.valueOf(ury));
    }

    public Rectangle unmarshal(String v) {
        return new Rectangle(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Rectangle rectangle = (Rectangle)((Object)o);
        if (Float.compare(rectangle.llx, this.llx) != 0) {
            return false;
        }
        if (Float.compare(rectangle.lly, this.lly) != 0) {
            return false;
        }
        if (Float.compare(rectangle.urx, this.urx) != 0) {
            return false;
        }
        return Float.compare(rectangle.ury, this.ury) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Float.floatToIntBits(this.llx);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.lly);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.urx);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Float.floatToIntBits(this.ury);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

