/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.validator.element;

import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.validator.Ancestors;
import org.cip4.lib.xjdf.validator.ValidationResultBuilder;
import org.cip4.lib.xjdf.validator.element.SimpleValidator;

public class ResourceSetValidator
extends SimpleValidator<ResourceSet> {
    @Override
    public void validate(ResourceSet resourceSet, Ancestors ancestors, ValidationResultBuilder validationResult) {
        if (null == resourceSet.getName()) {
            validationResult.append("Attribute //ResourceSet/@Name may not be null.");
        } else if ("".equals(resourceSet.getName())) {
            validationResult.append("Attribute //ResourceSet/@Name may not be empty.");
        } else {
            String resourceSetName = resourceSet.getName();
            for (Resource resource : resourceSet.getResource()) {
                String resourceName;
                if (resource.getSpecificResource() == null || (resourceName = resource.getSpecificResource().getName().getLocalPart()).equals(resourceSetName)) continue;
                validationResult.append(String.format("ResourceSet with @Name='%s' may only contain Resources of type '%s', but '%s' was found.", resourceSetName, resourceSetName, resourceName));
            }
        }
    }

    @Override
    public boolean canValidate(Object o) {
        return o instanceof ResourceSet;
    }
}

