/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.ValidationException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang3.StringUtils;
import org.apache.xerces.dom.DOMInputImpl;
import org.w3c.dom.Document;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class AbstractXmlValidator {
    private final Map<String, byte[]> xsdDependencies;

    public AbstractXmlValidator(Map<String, byte[]> xsdDependencies) {
        this.xsdDependencies = xsdDependencies;
    }

    public final void validate(InputStream documentStream) throws ValidationException {
        XJdfErrorHandler errorHandler = new XJdfErrorHandler();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setErrorHandler(errorHandler);
            Document doc = db.parse(documentStream);
            if (!errorHandler.getMessages().isEmpty()) {
                List<String> messages = errorHandler.getMessages();
                throw new ValidationException("Validation of the document failed due to following error messages: " + System.lineSeparator() + StringUtils.join(messages, (String)System.lineSeparator()));
            }
            this.validate(new DOMSource(doc));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected final void validate(Source source) throws ValidationException {
        try {
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new ResourceResolver());
            Schema schema = schemaFactory.newSchema(this.getSchema());
            XJdfErrorHandler errorHandler = new XJdfErrorHandler();
            Validator validator = schema.newValidator();
            validator.setErrorHandler(errorHandler);
            validator.validate(source);
            List<String> messages = errorHandler.getMessages();
            if (messages.size() > 0) {
                throw new ValidationException("Validation of the document failed due to following error messages: " + System.lineSeparator() + StringUtils.join(messages, (String)System.lineSeparator()));
            }
        }
        catch (IOException | SAXException e) {
            throw new ValidationException(e.getMessage(), (Throwable)e);
        }
    }

    protected abstract URL getSchema();

    private class XJdfErrorHandler
    implements ErrorHandler {
        private final List<String> messages = new ArrayList<String>();

        private XJdfErrorHandler() {
        }

        public List<String> getMessages() {
            return this.messages;
        }

        @Override
        public void warning(SAXParseException exception) {
            String msg = "WARNING in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void error(SAXParseException exception) {
            String msg = "ERROR in XJDF Doc at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }

        @Override
        public void fatalError(SAXParseException exception) {
            String msg = "FATAL in XJDF Doc ERROR at line " + exception.getLineNumber() + ", column " + exception.getColumnNumber() + ": " + exception.getMessage();
            this.messages.add(msg);
        }
    }

    private class ResourceResolver
    implements LSResourceResolver {
        private ResourceResolver() {
        }

        @Override
        public final LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
            DOMInputImpl lsInput = new DOMInputImpl(publicId, systemId, null);
            if (AbstractXmlValidator.this.xsdDependencies != null && AbstractXmlValidator.this.xsdDependencies.containsKey(systemId)) {
                lsInput.setByteStream(new ByteArrayInputStream(AbstractXmlValidator.this.xsdDependencies.get(systemId)));
                lsInput.setSystemId(systemId);
            }
            return lsInput;
        }
    }
}

