/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml.internal;

import java.lang.reflect.Field;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cip4.lib.xjdf.xml.internal.NamespaceManager;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXBNavigator<T> {
    private static final Pattern XPATH_WITH_ATTR_PATTERN = Pattern.compile("^(.+)(/@[a-zA-Z0-9_-]+)$");
    private final T jaxbObj;
    private final XPath xPath;
    private Document document;
    private final Binder<Node> binder;
    private final NamespaceManager namespaceManager = new NamespaceManager();

    public JAXBNavigator(T jaxbObj) throws JAXBException, ParserConfigurationException {
        this.jaxbObj = jaxbObj;
        this.xPath = this.createXPath();
        this.binder = this.createBinder(jaxbObj.getClass());
        this.sync();
    }

    private Object evaluate(String xPathExpression) throws XPathExpressionException {
        Matcher matcher = XPATH_WITH_ATTR_PATTERN.matcher(xPathExpression);
        if (matcher.matches()) {
            Object ownerObj;
            Node node = (Node)this.xPath.evaluate(matcher.group(1), this.document, XPathConstants.NODE);
            if (node != null && (ownerObj = this.binder.getJAXBNode((Object)node)) != null) {
                Field[] fields;
                String fieldName = matcher.group(2).substring(2);
                for (Field field : fields = FieldUtils.getFieldsWithAnnotation(ownerObj.getClass(), XmlAttribute.class)) {
                    XmlAttribute xmlAttribute = field.getAnnotation(XmlAttribute.class);
                    if (!fieldName.equals(xmlAttribute.name())) continue;
                    try {
                        return FieldUtils.readField((Field)field, (Object)ownerObj, (boolean)true);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(String.format("Could not get value from field '%s'.", field.getName()), e);
                    }
                }
            }
            return null;
        }
        Node node = (Node)this.xPath.evaluate(xPathExpression, this.document, XPathConstants.NODE);
        if (node == null) {
            return null;
        }
        return this.binder.getJAXBNode((Object)node);
    }

    public final Integer evaluateInt(String xPathExpression) throws XPathExpressionException {
        return (Integer)this.evaluate(xPathExpression);
    }

    public final Double evaluateDouble(String xPathExpression) throws XPathExpressionException {
        return (Double)this.evaluate(xPathExpression);
    }

    public final String evaluateString(String xPathExpression) throws XPathExpressionException {
        return (String)this.evaluate(xPathExpression);
    }

    public final Object evaluateNode(String xPathExpression) throws XPathExpressionException {
        return this.evaluate(xPathExpression);
    }

    public final Object[] evaluateNodeList(String xPathExpression) throws XPathExpressionException {
        NodeList nodeList = (NodeList)this.xPath.evaluate(xPathExpression, this.document, XPathConstants.NODESET);
        Object[] collection = new Object[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Object jaxbNode;
            collection[i] = jaxbNode = this.binder.getJAXBNode((Object)nodeList.item(i));
        }
        return collection;
    }

    public final JAXBNavigator<T> addNamespace(String prefix, String namespaceUri) {
        this.namespaceManager.addNamespace(prefix, namespaceUri);
        return this;
    }

    public final T getRoot() {
        return this.jaxbObj;
    }

    private Binder<Node> createBinder(Class<T> jaxbType) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{jaxbType});
            return jaxbContext.createBinder();
        }
        catch (JAXBException e) {
            throw new IllegalArgumentException("Could not create the binder.", e);
        }
    }

    private Document createDocument() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        return documentBuilderFactory.newDocumentBuilder().newDocument();
    }

    private XPath createXPath() {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath result = xPathFactory.newXPath();
        result.setNamespaceContext(this.namespaceManager);
        return result;
    }

    public final JAXBNavigator<T> sync() throws JAXBException, ParserConfigurationException {
        this.document = this.createDocument();
        this.binder.marshal(this.jaxbObj, (Object)this.document);
        return this;
    }
}

