/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.schema.Intent;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ProductIntent;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.w3c.dom.Node;

public class ProductBuilder
extends AbstractNodeBuilder<Product> {
    private static final String ID_PREFIX = "PRD";

    public ProductBuilder() {
        this(null, null, null, null);
    }

    public ProductBuilder(Node productNode) throws JAXBException {
        super(productNode, Product.class);
    }

    public ProductBuilder(Integer amount) {
        this(amount, null, null, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails) {
        this(amount, productType, productTypeDetails, null);
    }

    public ProductBuilder(Integer amount, String productType, String productTypeDetails, String descriptiveName) {
        super(new Product());
        this.getProduct().setAmount(amount);
        this.getProduct().setProductType(productType);
        this.getProduct().setProductTypeDetails(productTypeDetails);
        this.getProduct().setDescriptiveName(descriptiveName);
    }

    public ProductBuilder(Product product) {
        super(product);
    }

    protected Product getProduct() {
        return (Product)this.getNode();
    }

    public void addIntent(ProductIntent intent) {
        if (intent == null) {
            return;
        }
        String intentName = intent.getClass().getSimpleName();
        Intent it = new Intent().withName(intentName);
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, intentName);
        JAXBElement obj = new JAXBElement(qname, intent.getClass(), (Object)intent);
        it.setProductIntent((JAXBElement<? extends ProductIntent>)obj);
        this.getProduct().getIntent().add(it);
    }
}

