/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.builder;

import jakarta.xml.bind.JAXBElement;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.builder.AbstractNodeBuilder;
import org.cip4.lib.xjdf.comparator.ResourceSetComparator;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ProductList;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.Resources;
import org.cip4.lib.xjdf.xml.XJdfConstants;

public class XJdfBuilder
extends AbstractNodeBuilder<XJDF> {
    private final Resources resourceSets = new Resources(((XJDF)this.getNode()).getResourceSet());

    public XJdfBuilder() {
        this(null, null, null, null);
    }

    public XJdfBuilder(String jobID) {
        this(jobID, null, null, null);
    }

    public XJdfBuilder(String jobID, String category) {
        this(jobID, category, null, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName) {
        this(jobID, category, descriptiveName, null);
    }

    public XJdfBuilder(String jobID, String category, String descriptiveName, String relatedJobID) {
        super(new XJDF());
        this.getXJdf().setJobID(jobID);
        this.getXJdf().setCategory(category);
        this.getXJdf().setDescriptiveName(descriptiveName);
        this.getXJdf().setRelatedJobID(relatedJobID);
    }

    public XJdfBuilder(XJDF xjdf) {
        super(xjdf);
        Collections.sort(((XJDF)this.getNode()).getResourceSet(), new ResourceSetComparator());
    }

    public XJDF getXJdf() {
        return (XJDF)this.getNode();
    }

    public final void addComment(String comment) {
        ((XJDF)this.getNode()).getComment().add(new Comment().withValue(comment));
    }

    public final void addGeneralID(GeneralID generalId) {
        if (generalId == null) {
            return;
        }
        this.getXJdf().getGeneralID().add(generalId);
    }

    public final void addProduct(Product product) {
        if (product == null) {
            return;
        }
        if (this.getXJdf().getProductList() == null) {
            this.getXJdf().setProductList(new ProductList());
        }
        this.getXJdf().getProductList().getProduct().add(product);
    }

    public final void addAudit(Audit audit) {
        if (this.getXJdf().getAuditPool() == null) {
            this.getXJdf().setAuditPool(new AuditPool());
        }
        this.getXJdf().getAuditPool().getAudits().add(audit);
    }

    public final void addResource(SpecificResource specificResource) {
        this.addResource(specificResource, null, null);
    }

    public final void addResource(SpecificResource specificResource, String processUsage) {
        this.addResource(specificResource, null, processUsage);
    }

    public final void addResource(List<SpecificResource> specificResources) {
        this.addResource(specificResources, null);
    }

    public final void addResource(List<SpecificResource> specificResources, String processUsage) {
        for (SpecificResource specificResource : specificResources) {
            this.addResource(specificResource, null, processUsage);
        }
    }

    public final Resource addResource(SpecificResource specificResource, Part part) {
        return this.addResource(specificResource, part, null);
    }

    public final Resource addResource(SpecificResource specificResource, Part part, String processUsage) {
        if (specificResource == null) {
            throw new IllegalArgumentException("Resource may not be null.");
        }
        String paramName = specificResource.getClass().getSimpleName();
        QName qname = new QName(XJdfConstants.NAMESPACE_JDF20, paramName);
        JAXBElement obj = new JAXBElement(qname, SpecificResource.class, null, (Object)specificResource);
        Resource resource = new Resource();
        resource.setSpecificResource((JAXBElement<? extends SpecificResource>)obj);
        resource.getPart().add(part);
        this.addResource(resource, processUsage);
        return resource;
    }

    public void addResource(Resource resource, String processUsage) {
        this.resourceSets.addResource(resource, processUsage);
    }

    public final void addResourceSet(ResourceSet resourceSet) {
        this.resourceSets.addResourceSet(resourceSet);
    }
}

