/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.Address;
import org.cip4.lib.xjdf.schema.ComChannel;
import org.cip4.lib.xjdf.schema.Company;
import org.cip4.lib.xjdf.schema.Person;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Contact", propOrder={"address", "comChannel", "company", "person"})
public class Contact
extends SpecificResource
implements Serializable {
    @XmlElement(name="Address")
    protected Address address;
    @XmlElement(name="ComChannel")
    protected List<ComChannel> comChannel;
    @XmlElement(name="Company")
    protected Company company;
    @XmlElement(name="Person")
    protected Person person;
    @XmlAttribute(name="ContactTypeDetails")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> contactTypeDetails;
    @XmlAttribute(name="CostCenterID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String costCenterID;
    @XmlAttribute(name="UserID")
    protected String userID;

    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address value) {
        this.address = value;
    }

    public List<ComChannel> getComChannel() {
        if (this.comChannel == null) {
            this.comChannel = new ArrayList<ComChannel>();
        }
        return this.comChannel;
    }

    public Company getCompany() {
        return this.company;
    }

    public void setCompany(Company value) {
        this.company = value;
    }

    public Person getPerson() {
        return this.person;
    }

    public void setPerson(Person value) {
        this.person = value;
    }

    public List<String> getContactTypeDetails() {
        if (this.contactTypeDetails == null) {
            this.contactTypeDetails = new ArrayList<String>();
        }
        return this.contactTypeDetails;
    }

    public String getCostCenterID() {
        return this.costCenterID;
    }

    public void setCostCenterID(String value) {
        this.costCenterID = value;
    }

    public String getUserID() {
        return this.userID;
    }

    public void setUserID(String value) {
        this.userID = value;
    }

    public Contact withAddress(Address value) {
        this.setAddress(value);
        return this;
    }

    public Contact withComChannel(ComChannel ... values) {
        if (values != null) {
            for (ComChannel value : values) {
                this.getComChannel().add(value);
            }
        }
        return this;
    }

    public Contact withComChannel(Collection<ComChannel> values) {
        if (values != null) {
            this.getComChannel().addAll(values);
        }
        return this;
    }

    public Contact withCompany(Company value) {
        this.setCompany(value);
        return this;
    }

    public Contact withPerson(Person value) {
        this.setPerson(value);
        return this;
    }

    public Contact withContactTypeDetails(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getContactTypeDetails().add(value);
            }
        }
        return this;
    }

    public Contact withContactTypeDetails(Collection<String> values) {
        if (values != null) {
            this.getContactTypeDetails().addAll(values);
        }
        return this;
    }

    public Contact withCostCenterID(String value) {
        this.setCostCenterID(value);
        return this;
    }

    public Contact withUserID(String value) {
        this.setUserID(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightContactTypeDetails;
        List<ComChannel> rightComChannel;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Contact that = (Contact)object;
        Address leftAddress = this.getAddress();
        Address rightAddress = that.getAddress();
        if (this.address != null) {
            if (that.address == null) return false;
            if (!leftAddress.equals(rightAddress)) {
                return false;
            }
        } else if (that.address != null) {
            return false;
        }
        List<ComChannel> leftComChannel = this.comChannel != null && !this.comChannel.isEmpty() ? this.getComChannel() : null;
        List<ComChannel> list = rightComChannel = that.comChannel != null && !that.comChannel.isEmpty() ? that.getComChannel() : null;
        if (this.comChannel != null && !this.comChannel.isEmpty()) {
            if (that.comChannel == null || that.comChannel.isEmpty()) return false;
            if (!leftComChannel.equals(rightComChannel)) {
                return false;
            }
        } else if (that.comChannel != null && !that.comChannel.isEmpty()) {
            return false;
        }
        Company leftCompany = this.getCompany();
        Company rightCompany = that.getCompany();
        if (this.company != null) {
            if (that.company == null) return false;
            if (!leftCompany.equals(rightCompany)) {
                return false;
            }
        } else if (that.company != null) {
            return false;
        }
        Person leftPerson = this.getPerson();
        Person rightPerson = that.getPerson();
        if (this.person != null) {
            if (that.person == null) return false;
            if (!leftPerson.equals(rightPerson)) {
                return false;
            }
        } else if (that.person != null) {
            return false;
        }
        List<String> leftContactTypeDetails = this.contactTypeDetails != null && !this.contactTypeDetails.isEmpty() ? this.getContactTypeDetails() : null;
        List<String> list2 = rightContactTypeDetails = that.contactTypeDetails != null && !that.contactTypeDetails.isEmpty() ? that.getContactTypeDetails() : null;
        if (this.contactTypeDetails != null && !this.contactTypeDetails.isEmpty()) {
            if (that.contactTypeDetails == null || that.contactTypeDetails.isEmpty()) return false;
            if (!leftContactTypeDetails.equals(rightContactTypeDetails)) {
                return false;
            }
        } else if (that.contactTypeDetails != null && !that.contactTypeDetails.isEmpty()) {
            return false;
        }
        String leftCostCenterID = this.getCostCenterID();
        String rightCostCenterID = that.getCostCenterID();
        if (this.costCenterID != null) {
            if (that.costCenterID == null) return false;
            if (!leftCostCenterID.equals(rightCostCenterID)) {
                return false;
            }
        } else if (that.costCenterID != null) {
            return false;
        }
        String leftUserID = this.getUserID();
        String rightUserID = that.getUserID();
        if (this.userID != null) {
            if (that.userID == null) return false;
            if (leftUserID.equals(rightUserID)) return true;
            return false;
        }
        if (that.userID == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theContactTypeDetails;
        List<ComChannel> theComChannel;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        Address theAddress = this.getAddress();
        if (this.address != null) {
            currentHashCode += theAddress.hashCode();
        }
        currentHashCode *= 31;
        List<ComChannel> list = theComChannel = this.comChannel != null && !this.comChannel.isEmpty() ? this.getComChannel() : null;
        if (this.comChannel != null && !this.comChannel.isEmpty()) {
            currentHashCode += theComChannel.hashCode();
        }
        currentHashCode *= 31;
        Company theCompany = this.getCompany();
        if (this.company != null) {
            currentHashCode += theCompany.hashCode();
        }
        currentHashCode *= 31;
        Person thePerson = this.getPerson();
        if (this.person != null) {
            currentHashCode += thePerson.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theContactTypeDetails = this.contactTypeDetails != null && !this.contactTypeDetails.isEmpty() ? this.getContactTypeDetails() : null;
        if (this.contactTypeDetails != null && !this.contactTypeDetails.isEmpty()) {
            currentHashCode += theContactTypeDetails.hashCode();
        }
        currentHashCode *= 31;
        String theCostCenterID = this.getCostCenterID();
        if (this.costCenterID != null) {
            currentHashCode += theCostCenterID.hashCode();
        }
        currentHashCode *= 31;
        String theUserID = this.getUserID();
        if (this.userID != null) {
            currentHashCode += theUserID.hashCode();
        }
        return currentHashCode;
    }
}

