/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.Shape;
import org.cip4.lib.xjdf.schema.SheetLay;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ShapeCuttingParams", propOrder={"shape"})
public class ShapeCuttingParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="Shape")
    protected List<Shape> shape;
    @XmlAttribute(name="DeliveryMode")
    protected DeliveryMode deliveryMode;
    @XmlAttribute(name="DieLayoutRef")
    @XmlIDREF
    @XmlSchemaType(name="IDREF")
    protected Resource dieLayout;
    @XmlAttribute(name="ModuleID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String moduleID;
    @XmlAttribute(name="SheetLay")
    protected SheetLay sheetLay;

    public List<Shape> getShape() {
        if (this.shape == null) {
            this.shape = new ArrayList<Shape>();
        }
        return this.shape;
    }

    public DeliveryMode getDeliveryMode() {
        return this.deliveryMode;
    }

    public void setDeliveryMode(DeliveryMode value) {
        this.deliveryMode = value;
    }

    public Resource getDieLayout() {
        return this.dieLayout;
    }

    public void setDieLayout(Resource value) {
        this.dieLayout = value;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public void setModuleID(String value) {
        this.moduleID = value;
    }

    public SheetLay getSheetLay() {
        return this.sheetLay;
    }

    public void setSheetLay(SheetLay value) {
        this.sheetLay = value;
    }

    public ShapeCuttingParams withShape(Shape ... values) {
        if (values != null) {
            for (Shape value : values) {
                this.getShape().add(value);
            }
        }
        return this;
    }

    public ShapeCuttingParams withShape(Collection<Shape> values) {
        if (values != null) {
            this.getShape().addAll(values);
        }
        return this;
    }

    public ShapeCuttingParams withDeliveryMode(DeliveryMode value) {
        this.setDeliveryMode(value);
        return this;
    }

    public ShapeCuttingParams withDieLayout(Resource value) {
        this.setDieLayout(value);
        return this;
    }

    public ShapeCuttingParams withModuleID(String value) {
        this.setModuleID(value);
        return this;
    }

    public ShapeCuttingParams withSheetLay(SheetLay value) {
        this.setSheetLay(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Shape> rightShape;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ShapeCuttingParams that = (ShapeCuttingParams)object;
        List<Shape> leftShape = this.shape != null && !this.shape.isEmpty() ? this.getShape() : null;
        List<Shape> list = rightShape = that.shape != null && !that.shape.isEmpty() ? that.getShape() : null;
        if (this.shape != null && !this.shape.isEmpty()) {
            if (that.shape == null || that.shape.isEmpty()) return false;
            if (!leftShape.equals(rightShape)) {
                return false;
            }
        } else if (that.shape != null && !that.shape.isEmpty()) {
            return false;
        }
        DeliveryMode leftDeliveryMode = this.getDeliveryMode();
        DeliveryMode rightDeliveryMode = that.getDeliveryMode();
        if (this.deliveryMode != null) {
            if (that.deliveryMode == null) return false;
            if (!leftDeliveryMode.equals((Object)rightDeliveryMode)) {
                return false;
            }
        } else if (that.deliveryMode != null) {
            return false;
        }
        Resource leftDieLayout = this.getDieLayout();
        Resource rightDieLayout = that.getDieLayout();
        if (this.dieLayout != null) {
            if (that.dieLayout == null) return false;
            if (!leftDieLayout.equals(rightDieLayout)) {
                return false;
            }
        } else if (that.dieLayout != null) {
            return false;
        }
        String leftModuleID = this.getModuleID();
        String rightModuleID = that.getModuleID();
        if (this.moduleID != null) {
            if (that.moduleID == null) return false;
            if (!leftModuleID.equals(rightModuleID)) {
                return false;
            }
        } else if (that.moduleID != null) {
            return false;
        }
        SheetLay leftSheetLay = this.getSheetLay();
        SheetLay rightSheetLay = that.getSheetLay();
        if (this.sheetLay != null) {
            if (that.sheetLay == null) return false;
            if (leftSheetLay.equals((Object)rightSheetLay)) return true;
            return false;
        }
        if (that.sheetLay == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Shape> theShape;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<Shape> list = theShape = this.shape != null && !this.shape.isEmpty() ? this.getShape() : null;
        if (this.shape != null && !this.shape.isEmpty()) {
            currentHashCode += theShape.hashCode();
        }
        currentHashCode *= 31;
        DeliveryMode theDeliveryMode = this.getDeliveryMode();
        if (this.deliveryMode != null) {
            currentHashCode += theDeliveryMode.hashCode();
        }
        currentHashCode *= 31;
        Resource theDieLayout = this.getDieLayout();
        if (this.dieLayout != null) {
            currentHashCode += theDieLayout.hashCode();
        }
        currentHashCode *= 31;
        String theModuleID = this.getModuleID();
        if (this.moduleID != null) {
            currentHashCode += theModuleID.hashCode();
        }
        currentHashCode *= 31;
        SheetLay theSheetLay = this.getSheetLay();
        if (this.sheetLay != null) {
            currentHashCode += theSheetLay.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum DeliveryMode {
        FULL_SHEET("FullSheet"),
        REMOVE_GRIPPER_MARGIN("RemoveGripperMargin"),
        SEPARATE_BLANKS("SeparateBlanks");

        private final String value;

        private DeliveryMode(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DeliveryMode fromValue(String v) {
            for (DeliveryMode c : DeliveryMode.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

