/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.Matrix;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="TransferCurve")
public class TransferCurve
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="CTM")
    @XmlJavaTypeAdapter(value=Matrix.class)
    protected Matrix ctm;
    @XmlAttribute(name="Curve")
    protected List<Float> curve;

    public Matrix getCTM() {
        return this.ctm;
    }

    public void setCTM(Matrix value) {
        this.ctm = value;
    }

    public List<Float> getCurve() {
        if (this.curve == null) {
            this.curve = new ArrayList<Float>();
        }
        return this.curve;
    }

    public TransferCurve withCTM(Matrix value) {
        this.setCTM(value);
        return this;
    }

    public TransferCurve withCurve(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getCurve().add(value);
            }
        }
        return this;
    }

    public TransferCurve withCurve(Collection<Float> values) {
        if (values != null) {
            this.getCurve().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightCurve;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        TransferCurve that = (TransferCurve)object;
        Matrix leftCTM = this.getCTM();
        Matrix rightCTM = that.getCTM();
        if (this.ctm != null) {
            if (that.ctm == null) return false;
            if (!leftCTM.equals((Object)rightCTM)) {
                return false;
            }
        } else if (that.ctm != null) {
            return false;
        }
        List<Float> leftCurve = this.curve != null && !this.curve.isEmpty() ? this.getCurve() : null;
        List<Float> list = rightCurve = that.curve != null && !that.curve.isEmpty() ? that.getCurve() : null;
        if (this.curve != null && !this.curve.isEmpty()) {
            if (that.curve == null || that.curve.isEmpty()) return false;
            if (leftCurve.equals(rightCurve)) return true;
            return false;
        }
        if (that.curve == null || that.curve.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theCurve;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        Matrix theCTM = this.getCTM();
        if (this.ctm != null) {
            currentHashCode += theCTM.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theCurve = this.curve != null && !this.curve.isEmpty() ? this.getCurve() : null;
        if (this.curve != null && !this.curve.isEmpty()) {
            currentHashCode += theCurve.hashCode();
        }
        return currentHashCode;
    }
}

