/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import jakarta.xml.bind.JAXBException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.internal.XmlNavigator;
import org.xml.sax.SAXException;

public class XJdfNavigator
extends XmlNavigator {
    public static final String JOB_ID = "/xjdf:XJDF/@JobID";
    public static final String CATEGORY = "/xjdf:XJDF/@Category";
    public static final String GENERAL_CATALOG_ID = "/xjdf:XJDF/xjdf:GeneralID[@IDUsage='CatalogID']/@IDValue";
    public static final String GENERAL_LINE_ID = "/xjdf:XJDF/xjdf:GeneralID[@IDUsage='LineID']/@IDValue";
    public static final String FILE_SPEC_URL = "/xjdf:XJDF/xjdf:ResourceSet[@Name='RunList']/xjdf:Resource/xjdf:RunList/xjdf:FileSpec/@URL";
    public static final String MIN_APPROVALS = "/xjdf:XJDF/xjdf:ResourceSet[@Name='ApprovalParams']/xjdf:Resource/xjdf:ApprovalParams/@MinApprovals";
    public static final String CUSTOMER_ID = "/xjdf:XJDF/xjdf:ResourceSet[@Name='CustomerInfo']/xjdf:Resource/xjdf:CustomerInfo/@CustomerID";
    public static final String AMOUNT = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/@Amount";
    public static final String MEDIA_QUALITY = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='MediaIntent']/xjdf:MediaIntent/@MediaQuality";
    public static final String LAYOUT_FINISHED_DIMENSIONS = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='LayoutIntent']/xjdf:LayoutIntent/@FinishedDimensions";
    public static final String LAYOUT_DIMENSIONS = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='LayoutIntent']/xjdf:LayoutIntent/@Dimensions";
    public static final String PRODUCTION_PRINT_PROCESS = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='ProductionIntent']/xjdf:ProductionIntent/@PrintProcess";
    public static final String FOLD_CATALOG = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='FoldingIntent']/xjdf:FoldingIntent/@FoldCatalog";
    public static final String COLOR_NUM_COLORS = "/xjdf:XJDF/xjdf:ProductList/xjdf:Product/xjdf:Intent[@Name='ColorIntent']/xjdf:ColorIntent/@NumColors";

    public XJdfNavigator(InputStream xJdfStream) throws ParserConfigurationException, SAXException, IOException {
        this(xJdfStream, false);
    }

    public XJdfNavigator(InputStream xJdfStream, boolean namespaceAware) throws IOException, SAXException, ParserConfigurationException {
        super(xJdfStream, namespaceAware);
        this.addNamespace("xjdf", XJdfConstants.NAMESPACE_JDF20);
    }

    public XJdfNavigator(String xjdfPath) throws IOException, SAXException, ParserConfigurationException {
        this(new FileInputStream(xjdfPath));
    }

    public XJdfNavigator(String xjdfPath, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        this(new FileInputStream(xjdfPath), namespaceAware);
    }

    public XJdfNavigator(File xjdfFile) throws IOException, SAXException, ParserConfigurationException {
        this(new FileInputStream(xjdfFile));
    }

    public XJdfNavigator(File xjdfFile, boolean namespaceAware) throws IOException, ParserConfigurationException, SAXException {
        this(new FileInputStream(xjdfFile), namespaceAware);
    }

    public XJdfNavigator(byte[] xJdfBytes) throws IOException, SAXException, ParserConfigurationException {
        this(new ByteArrayInputStream(xJdfBytes));
    }

    public XJdfNavigator(byte[] xJdfBytes, boolean namespaceAware) throws ParserConfigurationException, SAXException, IOException {
        this(new ByteArrayInputStream(xJdfBytes), namespaceAware);
    }

    public Object extractNode(String xPath) throws XPathExpressionException, JAXBException {
        return super.extractNode(xPath, new XJdfParser());
    }

    public void replaceNode(String xPath, Object replacement) throws XPathExpressionException, JAXBException, ParserConfigurationException {
        super.replaceNode(xPath, replacement, new XJdfParser());
    }
}

