
package org.cip4.lib.xjdf.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for Device complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="Device">
 *   <complexContent>
 *     <extension base="{http://www.CIP4.org/JDFSchema_2_0}SpecificResource">
 *       <sequence>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}FileSpec" maxOccurs="2" minOccurs="0"/>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}IconList" minOccurs="0"/>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}IdentificationField" maxOccurs="unbounded" minOccurs="0"/>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}Module" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="CostCenterID" type="{http://www.w3.org/2001/XMLSchema}NMTOKEN" />
 *       <attribute name="DescriptiveName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="DeviceClass" type="{http://www.w3.org/2001/XMLSchema}NMTOKENS" />
 *       <attribute name="DeviceID" use="required" type="{http://www.w3.org/2001/XMLSchema}NMTOKEN" />
 *       <attribute name="DeviceType" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="ICSVersions" type="{http://www.w3.org/2001/XMLSchema}NMTOKENS" />
 *       <attribute name="JDFVersions">
 *         <simpleType>
 *           <list>
 *             <simpleType>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *                 <enumeration value="1.1"/>
 *                 <enumeration value="1.2"/>
 *                 <enumeration value="1.3"/>
 *                 <enumeration value="1.4"/>
 *                 <enumeration value="1.5"/>
 *                 <enumeration value="1.6"/>
 *                 <enumeration value="2.0"/>
 *               </restriction>
 *             </simpleType>
 *           </list>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="KnownLocalizations" type="{http://www.CIP4.org/JDFSchema_2_0}languages" />
 *       <attribute name="Manufacturer" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="ManufacturerURL" type="{http://www.CIP4.org/JDFSchema_2_0}URL" />
 *       <attribute name="MaxRunSpeed" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       <attribute name="Packaging">
 *         <simpleType>
 *           <list>
 *             <simpleType>
 *               <restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *                 <enumeration value="XML"/>
 *                 <enumeration value="Zip"/>
 *               </restriction>
 *             </simpleType>
 *           </list>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="PresentationURL" type="{http://www.CIP4.org/JDFSchema_2_0}URL" />
 *       <attribute name="Revision" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="SerialNumber" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="URLSchemes" type="{http://www.w3.org/2001/XMLSchema}NMTOKENS" />
 *       <attribute name="XJMFURL" type="{http://www.CIP4.org/JDFSchema_2_0}URL" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Device", propOrder = {
    "fileSpec",
    "iconList",
    "identificationField",
    "module"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
public class Device
    extends SpecificResource
    implements Serializable
{

    @XmlElement(name = "FileSpec")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<FileSpec> fileSpec;
    @XmlElement(name = "IconList")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected IconList iconList;
    @XmlElement(name = "IdentificationField")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<IdentificationField> identificationField;
    @XmlElement(name = "Module")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<Module> module;
    @XmlAttribute(name = "CostCenterID")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NMTOKEN")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String costCenterID;
    @XmlAttribute(name = "DescriptiveName")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String descriptiveName;
    @XmlAttribute(name = "DeviceClass")
    @XmlSchemaType(name = "NMTOKENS")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<String> deviceClass;
    @XmlAttribute(name = "DeviceID", required = true)
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NMTOKEN")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String deviceID;
    @XmlAttribute(name = "DeviceType")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String deviceType;
    @XmlAttribute(name = "ICSVersions")
    @XmlSchemaType(name = "NMTOKENS")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<String> icsVersions;
    @XmlAttribute(name = "JDFVersions")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<Device.JDFVersions> jdfVersions;
    @XmlAttribute(name = "KnownLocalizations")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<String> knownLocalizations;
    @XmlAttribute(name = "Manufacturer")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String manufacturer;
    @XmlAttribute(name = "ManufacturerURL")
    @XmlJavaTypeAdapter(org.cip4.lib.xjdf.type.URI.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected org.cip4.lib.xjdf.type.URI manufacturerURL;
    @XmlAttribute(name = "MaxRunSpeed")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected Float maxRunSpeed;
    @XmlAttribute(name = "Packaging")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<Device.Packaging> packaging;
    @XmlAttribute(name = "PresentationURL")
    @XmlJavaTypeAdapter(org.cip4.lib.xjdf.type.URI.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected org.cip4.lib.xjdf.type.URI presentationURL;
    @XmlAttribute(name = "Revision")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String revision;
    @XmlAttribute(name = "SerialNumber")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected String serialNumber;
    @XmlAttribute(name = "URLSchemes")
    @XmlSchemaType(name = "NMTOKENS")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected List<String> urlSchemes;
    @XmlAttribute(name = "XJMFURL")
    @XmlJavaTypeAdapter(org.cip4.lib.xjdf.type.URI.class)
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    protected org.cip4.lib.xjdf.type.URI xjmfurl;

    /**
     * Gets the value of the fileSpec property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the fileSpec property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFileSpec().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FileSpec }
     * 
     * 
     * @return
     *     The value of the fileSpec property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<FileSpec> getFileSpec() {
        if (fileSpec == null) {
            fileSpec = new ArrayList<>();
        }
        return this.fileSpec;
    }

    /**
     * Gets the value of the iconList property.
     * 
     * @return
     *     possible object is
     *     {@link IconList }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public IconList getIconList() {
        return iconList;
    }

    /**
     * Sets the value of the iconList property.
     * 
     * @param value
     *     allowed object is
     *     {@link IconList }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setIconList(IconList value) {
        this.iconList = value;
    }

    /**
     * Gets the value of the identificationField property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the identificationField property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getIdentificationField().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link IdentificationField }
     * 
     * 
     * @return
     *     The value of the identificationField property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<IdentificationField> getIdentificationField() {
        if (identificationField == null) {
            identificationField = new ArrayList<>();
        }
        return this.identificationField;
    }

    /**
     * Gets the value of the module property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the module property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getModule().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Module }
     * 
     * 
     * @return
     *     The value of the module property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<Module> getModule() {
        if (module == null) {
            module = new ArrayList<>();
        }
        return this.module;
    }

    /**
     * Gets the value of the costCenterID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getCostCenterID() {
        return costCenterID;
    }

    /**
     * Sets the value of the costCenterID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setCostCenterID(String value) {
        this.costCenterID = value;
    }

    /**
     * Gets the value of the descriptiveName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getDescriptiveName() {
        return descriptiveName;
    }

    /**
     * Sets the value of the descriptiveName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setDescriptiveName(String value) {
        this.descriptiveName = value;
    }

    /**
     * Gets the value of the deviceClass property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the deviceClass property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeviceClass().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the deviceClass property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<String> getDeviceClass() {
        if (deviceClass == null) {
            deviceClass = new ArrayList<>();
        }
        return this.deviceClass;
    }

    /**
     * Gets the value of the deviceID property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getDeviceID() {
        return deviceID;
    }

    /**
     * Sets the value of the deviceID property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setDeviceID(String value) {
        this.deviceID = value;
    }

    /**
     * Gets the value of the deviceType property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getDeviceType() {
        return deviceType;
    }

    /**
     * Sets the value of the deviceType property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setDeviceType(String value) {
        this.deviceType = value;
    }

    /**
     * Gets the value of the icsVersions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the icsVersions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getICSVersions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the icsVersions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<String> getICSVersions() {
        if (icsVersions == null) {
            icsVersions = new ArrayList<>();
        }
        return this.icsVersions;
    }

    /**
     * Gets the value of the jdfVersions property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the jdfVersions property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getJDFVersions().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Device.JDFVersions }
     * 
     * 
     * @return
     *     The value of the jdfVersions property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<Device.JDFVersions> getJDFVersions() {
        if (jdfVersions == null) {
            jdfVersions = new ArrayList<>();
        }
        return this.jdfVersions;
    }

    /**
     * Gets the value of the knownLocalizations property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the knownLocalizations property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getKnownLocalizations().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the knownLocalizations property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<String> getKnownLocalizations() {
        if (knownLocalizations == null) {
            knownLocalizations = new ArrayList<>();
        }
        return this.knownLocalizations;
    }

    /**
     * Gets the value of the manufacturer property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getManufacturer() {
        return manufacturer;
    }

    /**
     * Sets the value of the manufacturer property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setManufacturer(String value) {
        this.manufacturer = value;
    }

    /**
     * Gets the value of the manufacturerURL property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public org.cip4.lib.xjdf.type.URI getManufacturerURL() {
        return manufacturerURL;
    }

    /**
     * Sets the value of the manufacturerURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setManufacturerURL(org.cip4.lib.xjdf.type.URI value) {
        this.manufacturerURL = value;
    }

    /**
     * Gets the value of the maxRunSpeed property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public Float getMaxRunSpeed() {
        return maxRunSpeed;
    }

    /**
     * Sets the value of the maxRunSpeed property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setMaxRunSpeed(Float value) {
        this.maxRunSpeed = value;
    }

    /**
     * Gets the value of the packaging property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the packaging property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getPackaging().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Device.Packaging }
     * 
     * 
     * @return
     *     The value of the packaging property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<Device.Packaging> getPackaging() {
        if (packaging == null) {
            packaging = new ArrayList<>();
        }
        return this.packaging;
    }

    /**
     * Gets the value of the presentationURL property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public org.cip4.lib.xjdf.type.URI getPresentationURL() {
        return presentationURL;
    }

    /**
     * Sets the value of the presentationURL property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setPresentationURL(org.cip4.lib.xjdf.type.URI value) {
        this.presentationURL = value;
    }

    /**
     * Gets the value of the revision property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getRevision() {
        return revision;
    }

    /**
     * Sets the value of the revision property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setRevision(String value) {
        this.revision = value;
    }

    /**
     * Gets the value of the serialNumber property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public String getSerialNumber() {
        return serialNumber;
    }

    /**
     * Sets the value of the serialNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setSerialNumber(String value) {
        this.serialNumber = value;
    }

    /**
     * Gets the value of the urlSchemes property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the urlSchemes property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getURLSchemes().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link String }
     * 
     * 
     * @return
     *     The value of the urlSchemes property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public List<String> getURLSchemes() {
        if (urlSchemes == null) {
            urlSchemes = new ArrayList<>();
        }
        return this.urlSchemes;
    }

    /**
     * Gets the value of the xjmfurl property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public org.cip4.lib.xjdf.type.URI getXJMFURL() {
        return xjmfurl;
    }

    /**
     * Sets the value of the xjmfurl property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public void setXJMFURL(org.cip4.lib.xjdf.type.URI value) {
        this.xjmfurl = value;
    }

    public Device withFileSpec(FileSpec... values) {
        if (values!= null) {
            for (FileSpec value: values) {
                getFileSpec().add(value);
            }
        }
        return this;
    }

    public Device withFileSpec(Collection<FileSpec> values) {
        if (values!= null) {
            getFileSpec().addAll(values);
        }
        return this;
    }

    public Device withIconList(IconList value) {
        setIconList(value);
        return this;
    }

    public Device withIdentificationField(IdentificationField... values) {
        if (values!= null) {
            for (IdentificationField value: values) {
                getIdentificationField().add(value);
            }
        }
        return this;
    }

    public Device withIdentificationField(Collection<IdentificationField> values) {
        if (values!= null) {
            getIdentificationField().addAll(values);
        }
        return this;
    }

    public Device withModule(Module... values) {
        if (values!= null) {
            for (Module value: values) {
                getModule().add(value);
            }
        }
        return this;
    }

    public Device withModule(Collection<Module> values) {
        if (values!= null) {
            getModule().addAll(values);
        }
        return this;
    }

    public Device withCostCenterID(String value) {
        setCostCenterID(value);
        return this;
    }

    public Device withDescriptiveName(String value) {
        setDescriptiveName(value);
        return this;
    }

    public Device withDeviceClass(String... values) {
        if (values!= null) {
            for (String value: values) {
                getDeviceClass().add(value);
            }
        }
        return this;
    }

    public Device withDeviceClass(Collection<String> values) {
        if (values!= null) {
            getDeviceClass().addAll(values);
        }
        return this;
    }

    public Device withDeviceID(String value) {
        setDeviceID(value);
        return this;
    }

    public Device withDeviceType(String value) {
        setDeviceType(value);
        return this;
    }

    public Device withICSVersions(String... values) {
        if (values!= null) {
            for (String value: values) {
                getICSVersions().add(value);
            }
        }
        return this;
    }

    public Device withICSVersions(Collection<String> values) {
        if (values!= null) {
            getICSVersions().addAll(values);
        }
        return this;
    }

    public Device withJDFVersions(Device.JDFVersions... values) {
        if (values!= null) {
            for (Device.JDFVersions value: values) {
                getJDFVersions().add(value);
            }
        }
        return this;
    }

    public Device withJDFVersions(Collection<Device.JDFVersions> values) {
        if (values!= null) {
            getJDFVersions().addAll(values);
        }
        return this;
    }

    public Device withKnownLocalizations(String... values) {
        if (values!= null) {
            for (String value: values) {
                getKnownLocalizations().add(value);
            }
        }
        return this;
    }

    public Device withKnownLocalizations(Collection<String> values) {
        if (values!= null) {
            getKnownLocalizations().addAll(values);
        }
        return this;
    }

    public Device withManufacturer(String value) {
        setManufacturer(value);
        return this;
    }

    public Device withManufacturerURL(org.cip4.lib.xjdf.type.URI value) {
        setManufacturerURL(value);
        return this;
    }

    public Device withMaxRunSpeed(Float value) {
        setMaxRunSpeed(value);
        return this;
    }

    public Device withPackaging(Device.Packaging... values) {
        if (values!= null) {
            for (Device.Packaging value: values) {
                getPackaging().add(value);
            }
        }
        return this;
    }

    public Device withPackaging(Collection<Device.Packaging> values) {
        if (values!= null) {
            getPackaging().addAll(values);
        }
        return this;
    }

    public Device withPresentationURL(org.cip4.lib.xjdf.type.URI value) {
        setPresentationURL(value);
        return this;
    }

    public Device withRevision(String value) {
        setRevision(value);
        return this;
    }

    public Device withSerialNumber(String value) {
        setSerialNumber(value);
        return this;
    }

    public Device withURLSchemes(String... values) {
        if (values!= null) {
            for (String value: values) {
                getURLSchemes().add(value);
            }
        }
        return this;
    }

    public Device withURLSchemes(Collection<String> values) {
        if (values!= null) {
            getURLSchemes().addAll(values);
        }
        return this;
    }

    public Device withXJMFURL(org.cip4.lib.xjdf.type.URI value) {
        setXJMFURL(value);
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Device that = ((Device) object);
        {
            List<FileSpec> leftFileSpec;
            leftFileSpec = (((this.fileSpec!= null)&&(!this.fileSpec.isEmpty()))?this.getFileSpec():null);
            List<FileSpec> rightFileSpec;
            rightFileSpec = (((that.fileSpec!= null)&&(!that.fileSpec.isEmpty()))?that.getFileSpec():null);
            if ((this.fileSpec!= null)&&(!this.fileSpec.isEmpty())) {
                if ((that.fileSpec!= null)&&(!that.fileSpec.isEmpty())) {
                    if (!leftFileSpec.equals(rightFileSpec)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.fileSpec!= null)&&(!that.fileSpec.isEmpty())) {
                    return false;
                }
            }
        }
        {
            IconList leftIconList;
            leftIconList = this.getIconList();
            IconList rightIconList;
            rightIconList = that.getIconList();
            if (this.iconList!= null) {
                if (that.iconList!= null) {
                    if (!leftIconList.equals(rightIconList)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.iconList!= null) {
                    return false;
                }
            }
        }
        {
            List<IdentificationField> leftIdentificationField;
            leftIdentificationField = (((this.identificationField!= null)&&(!this.identificationField.isEmpty()))?this.getIdentificationField():null);
            List<IdentificationField> rightIdentificationField;
            rightIdentificationField = (((that.identificationField!= null)&&(!that.identificationField.isEmpty()))?that.getIdentificationField():null);
            if ((this.identificationField!= null)&&(!this.identificationField.isEmpty())) {
                if ((that.identificationField!= null)&&(!that.identificationField.isEmpty())) {
                    if (!leftIdentificationField.equals(rightIdentificationField)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.identificationField!= null)&&(!that.identificationField.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Module> leftModule;
            leftModule = (((this.module!= null)&&(!this.module.isEmpty()))?this.getModule():null);
            List<Module> rightModule;
            rightModule = (((that.module!= null)&&(!that.module.isEmpty()))?that.getModule():null);
            if ((this.module!= null)&&(!this.module.isEmpty())) {
                if ((that.module!= null)&&(!that.module.isEmpty())) {
                    if (!leftModule.equals(rightModule)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.module!= null)&&(!that.module.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftCostCenterID;
            leftCostCenterID = this.getCostCenterID();
            String rightCostCenterID;
            rightCostCenterID = that.getCostCenterID();
            if (this.costCenterID!= null) {
                if (that.costCenterID!= null) {
                    if (!leftCostCenterID.equals(rightCostCenterID)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.costCenterID!= null) {
                    return false;
                }
            }
        }
        {
            String leftDescriptiveName;
            leftDescriptiveName = this.getDescriptiveName();
            String rightDescriptiveName;
            rightDescriptiveName = that.getDescriptiveName();
            if (this.descriptiveName!= null) {
                if (that.descriptiveName!= null) {
                    if (!leftDescriptiveName.equals(rightDescriptiveName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.descriptiveName!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftDeviceClass;
            leftDeviceClass = (((this.deviceClass!= null)&&(!this.deviceClass.isEmpty()))?this.getDeviceClass():null);
            List<String> rightDeviceClass;
            rightDeviceClass = (((that.deviceClass!= null)&&(!that.deviceClass.isEmpty()))?that.getDeviceClass():null);
            if ((this.deviceClass!= null)&&(!this.deviceClass.isEmpty())) {
                if ((that.deviceClass!= null)&&(!that.deviceClass.isEmpty())) {
                    if (!leftDeviceClass.equals(rightDeviceClass)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.deviceClass!= null)&&(!that.deviceClass.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftDeviceID;
            leftDeviceID = this.getDeviceID();
            String rightDeviceID;
            rightDeviceID = that.getDeviceID();
            if (this.deviceID!= null) {
                if (that.deviceID!= null) {
                    if (!leftDeviceID.equals(rightDeviceID)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.deviceID!= null) {
                    return false;
                }
            }
        }
        {
            String leftDeviceType;
            leftDeviceType = this.getDeviceType();
            String rightDeviceType;
            rightDeviceType = that.getDeviceType();
            if (this.deviceType!= null) {
                if (that.deviceType!= null) {
                    if (!leftDeviceType.equals(rightDeviceType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.deviceType!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftICSVersions;
            leftICSVersions = (((this.icsVersions!= null)&&(!this.icsVersions.isEmpty()))?this.getICSVersions():null);
            List<String> rightICSVersions;
            rightICSVersions = (((that.icsVersions!= null)&&(!that.icsVersions.isEmpty()))?that.getICSVersions():null);
            if ((this.icsVersions!= null)&&(!this.icsVersions.isEmpty())) {
                if ((that.icsVersions!= null)&&(!that.icsVersions.isEmpty())) {
                    if (!leftICSVersions.equals(rightICSVersions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.icsVersions!= null)&&(!that.icsVersions.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Device.JDFVersions> leftJDFVersions;
            leftJDFVersions = (((this.jdfVersions!= null)&&(!this.jdfVersions.isEmpty()))?this.getJDFVersions():null);
            List<Device.JDFVersions> rightJDFVersions;
            rightJDFVersions = (((that.jdfVersions!= null)&&(!that.jdfVersions.isEmpty()))?that.getJDFVersions():null);
            if ((this.jdfVersions!= null)&&(!this.jdfVersions.isEmpty())) {
                if ((that.jdfVersions!= null)&&(!that.jdfVersions.isEmpty())) {
                    if (!leftJDFVersions.equals(rightJDFVersions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.jdfVersions!= null)&&(!that.jdfVersions.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<String> leftKnownLocalizations;
            leftKnownLocalizations = (((this.knownLocalizations!= null)&&(!this.knownLocalizations.isEmpty()))?this.getKnownLocalizations():null);
            List<String> rightKnownLocalizations;
            rightKnownLocalizations = (((that.knownLocalizations!= null)&&(!that.knownLocalizations.isEmpty()))?that.getKnownLocalizations():null);
            if ((this.knownLocalizations!= null)&&(!this.knownLocalizations.isEmpty())) {
                if ((that.knownLocalizations!= null)&&(!that.knownLocalizations.isEmpty())) {
                    if (!leftKnownLocalizations.equals(rightKnownLocalizations)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.knownLocalizations!= null)&&(!that.knownLocalizations.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftManufacturer;
            leftManufacturer = this.getManufacturer();
            String rightManufacturer;
            rightManufacturer = that.getManufacturer();
            if (this.manufacturer!= null) {
                if (that.manufacturer!= null) {
                    if (!leftManufacturer.equals(rightManufacturer)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.manufacturer!= null) {
                    return false;
                }
            }
        }
        {
            org.cip4.lib.xjdf.type.URI leftManufacturerURL;
            leftManufacturerURL = this.getManufacturerURL();
            org.cip4.lib.xjdf.type.URI rightManufacturerURL;
            rightManufacturerURL = that.getManufacturerURL();
            if (this.manufacturerURL!= null) {
                if (that.manufacturerURL!= null) {
                    if (!leftManufacturerURL.equals(rightManufacturerURL)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.manufacturerURL!= null) {
                    return false;
                }
            }
        }
        {
            Float leftMaxRunSpeed;
            leftMaxRunSpeed = this.getMaxRunSpeed();
            Float rightMaxRunSpeed;
            rightMaxRunSpeed = that.getMaxRunSpeed();
            if (this.maxRunSpeed!= null) {
                if (that.maxRunSpeed!= null) {
                    if (!leftMaxRunSpeed.equals(rightMaxRunSpeed)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.maxRunSpeed!= null) {
                    return false;
                }
            }
        }
        {
            List<Device.Packaging> leftPackaging;
            leftPackaging = (((this.packaging!= null)&&(!this.packaging.isEmpty()))?this.getPackaging():null);
            List<Device.Packaging> rightPackaging;
            rightPackaging = (((that.packaging!= null)&&(!that.packaging.isEmpty()))?that.getPackaging():null);
            if ((this.packaging!= null)&&(!this.packaging.isEmpty())) {
                if ((that.packaging!= null)&&(!that.packaging.isEmpty())) {
                    if (!leftPackaging.equals(rightPackaging)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.packaging!= null)&&(!that.packaging.isEmpty())) {
                    return false;
                }
            }
        }
        {
            org.cip4.lib.xjdf.type.URI leftPresentationURL;
            leftPresentationURL = this.getPresentationURL();
            org.cip4.lib.xjdf.type.URI rightPresentationURL;
            rightPresentationURL = that.getPresentationURL();
            if (this.presentationURL!= null) {
                if (that.presentationURL!= null) {
                    if (!leftPresentationURL.equals(rightPresentationURL)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.presentationURL!= null) {
                    return false;
                }
            }
        }
        {
            String leftRevision;
            leftRevision = this.getRevision();
            String rightRevision;
            rightRevision = that.getRevision();
            if (this.revision!= null) {
                if (that.revision!= null) {
                    if (!leftRevision.equals(rightRevision)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.revision!= null) {
                    return false;
                }
            }
        }
        {
            String leftSerialNumber;
            leftSerialNumber = this.getSerialNumber();
            String rightSerialNumber;
            rightSerialNumber = that.getSerialNumber();
            if (this.serialNumber!= null) {
                if (that.serialNumber!= null) {
                    if (!leftSerialNumber.equals(rightSerialNumber)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.serialNumber!= null) {
                    return false;
                }
            }
        }
        {
            List<String> leftURLSchemes;
            leftURLSchemes = (((this.urlSchemes!= null)&&(!this.urlSchemes.isEmpty()))?this.getURLSchemes():null);
            List<String> rightURLSchemes;
            rightURLSchemes = (((that.urlSchemes!= null)&&(!that.urlSchemes.isEmpty()))?that.getURLSchemes():null);
            if ((this.urlSchemes!= null)&&(!this.urlSchemes.isEmpty())) {
                if ((that.urlSchemes!= null)&&(!that.urlSchemes.isEmpty())) {
                    if (!leftURLSchemes.equals(rightURLSchemes)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.urlSchemes!= null)&&(!that.urlSchemes.isEmpty())) {
                    return false;
                }
            }
        }
        {
            org.cip4.lib.xjdf.type.URI leftXJMFURL;
            leftXJMFURL = this.getXJMFURL();
            org.cip4.lib.xjdf.type.URI rightXJMFURL;
            rightXJMFURL = that.getXJMFURL();
            if (this.xjmfurl!= null) {
                if (that.xjmfurl!= null) {
                    if (!leftXJMFURL.equals(rightXJMFURL)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.xjmfurl!= null) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            List<FileSpec> theFileSpec;
            theFileSpec = (((this.fileSpec!= null)&&(!this.fileSpec.isEmpty()))?this.getFileSpec():null);
            if ((this.fileSpec!= null)&&(!this.fileSpec.isEmpty())) {
                currentHashCode += theFileSpec.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            IconList theIconList;
            theIconList = this.getIconList();
            if (this.iconList!= null) {
                currentHashCode += theIconList.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<IdentificationField> theIdentificationField;
            theIdentificationField = (((this.identificationField!= null)&&(!this.identificationField.isEmpty()))?this.getIdentificationField():null);
            if ((this.identificationField!= null)&&(!this.identificationField.isEmpty())) {
                currentHashCode += theIdentificationField.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Module> theModule;
            theModule = (((this.module!= null)&&(!this.module.isEmpty()))?this.getModule():null);
            if ((this.module!= null)&&(!this.module.isEmpty())) {
                currentHashCode += theModule.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theCostCenterID;
            theCostCenterID = this.getCostCenterID();
            if (this.costCenterID!= null) {
                currentHashCode += theCostCenterID.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDescriptiveName;
            theDescriptiveName = this.getDescriptiveName();
            if (this.descriptiveName!= null) {
                currentHashCode += theDescriptiveName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theDeviceClass;
            theDeviceClass = (((this.deviceClass!= null)&&(!this.deviceClass.isEmpty()))?this.getDeviceClass():null);
            if ((this.deviceClass!= null)&&(!this.deviceClass.isEmpty())) {
                currentHashCode += theDeviceClass.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDeviceID;
            theDeviceID = this.getDeviceID();
            if (this.deviceID!= null) {
                currentHashCode += theDeviceID.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theDeviceType;
            theDeviceType = this.getDeviceType();
            if (this.deviceType!= null) {
                currentHashCode += theDeviceType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theICSVersions;
            theICSVersions = (((this.icsVersions!= null)&&(!this.icsVersions.isEmpty()))?this.getICSVersions():null);
            if ((this.icsVersions!= null)&&(!this.icsVersions.isEmpty())) {
                currentHashCode += theICSVersions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Device.JDFVersions> theJDFVersions;
            theJDFVersions = (((this.jdfVersions!= null)&&(!this.jdfVersions.isEmpty()))?this.getJDFVersions():null);
            if ((this.jdfVersions!= null)&&(!this.jdfVersions.isEmpty())) {
                currentHashCode += theJDFVersions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theKnownLocalizations;
            theKnownLocalizations = (((this.knownLocalizations!= null)&&(!this.knownLocalizations.isEmpty()))?this.getKnownLocalizations():null);
            if ((this.knownLocalizations!= null)&&(!this.knownLocalizations.isEmpty())) {
                currentHashCode += theKnownLocalizations.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theManufacturer;
            theManufacturer = this.getManufacturer();
            if (this.manufacturer!= null) {
                currentHashCode += theManufacturer.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            org.cip4.lib.xjdf.type.URI theManufacturerURL;
            theManufacturerURL = this.getManufacturerURL();
            if (this.manufacturerURL!= null) {
                currentHashCode += theManufacturerURL.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Float theMaxRunSpeed;
            theMaxRunSpeed = this.getMaxRunSpeed();
            if (this.maxRunSpeed!= null) {
                currentHashCode += theMaxRunSpeed.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Device.Packaging> thePackaging;
            thePackaging = (((this.packaging!= null)&&(!this.packaging.isEmpty()))?this.getPackaging():null);
            if ((this.packaging!= null)&&(!this.packaging.isEmpty())) {
                currentHashCode += thePackaging.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            org.cip4.lib.xjdf.type.URI thePresentationURL;
            thePresentationURL = this.getPresentationURL();
            if (this.presentationURL!= null) {
                currentHashCode += thePresentationURL.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theRevision;
            theRevision = this.getRevision();
            if (this.revision!= null) {
                currentHashCode += theRevision.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theSerialNumber;
            theSerialNumber = this.getSerialNumber();
            if (this.serialNumber!= null) {
                currentHashCode += theSerialNumber.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<String> theURLSchemes;
            theURLSchemes = (((this.urlSchemes!= null)&&(!this.urlSchemes.isEmpty()))?this.getURLSchemes():null);
            if ((this.urlSchemes!= null)&&(!this.urlSchemes.isEmpty())) {
                currentHashCode += theURLSchemes.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            org.cip4.lib.xjdf.type.URI theXJMFURL;
            theXJMFURL = this.getXJMFURL();
            if (this.xjmfurl!= null) {
                currentHashCode += theXJMFURL.hashCode();
            }
        }
        return currentHashCode;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <pre>{@code
     * <simpleType>
     *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     <enumeration value="1.1"/>
     *     <enumeration value="1.2"/>
     *     <enumeration value="1.3"/>
     *     <enumeration value="1.4"/>
     *     <enumeration value="1.5"/>
     *     <enumeration value="1.6"/>
     *     <enumeration value="2.0"/>
     *   </restriction>
     * </simpleType>
     * }</pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public enum JDFVersions {

        @XmlEnumValue("1.1")
        V1_1("1.1"),
        @XmlEnumValue("1.2")
        V1_2("1.2"),
        @XmlEnumValue("1.3")
        V1_3("1.3"),
        @XmlEnumValue("1.4")
        V1_4("1.4"),
        @XmlEnumValue("1.5")
        V1_5("1.5"),
        @XmlEnumValue("1.6")
        V1_6("1.6"),
        @XmlEnumValue("2.0")
        V2_0("2.0");
        private final String value;

        JDFVersions(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Device.JDFVersions fromValue(String v) {
            for (Device.JDFVersions c: Device.JDFVersions.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <pre>{@code
     * <simpleType>
     *   <restriction base="{http://www.w3.org/2001/XMLSchema}string">
     *     <enumeration value="XML"/>
     *     <enumeration value="Zip"/>
     *   </restriction>
     * </simpleType>
     * }</pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.1", date = "2022-12-21T00:11:33Z")
    public enum Packaging {

        XML("XML"),
        @XmlEnumValue("Zip")
        ZIP("Zip");
        private final String value;

        Packaging(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Device.Packaging fromValue(String v) {
            for (Device.Packaging c: Device.Packaging.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
