/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.type.DateTime;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"comment"})
@XmlRootElement(name="Activity")
public class Activity
implements Serializable {
    @XmlElement(name="Comment")
    protected Comment comment;
    @XmlAttribute(name="ActivityID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String activityID;
    @XmlAttribute(name="ActivityName")
    protected String activityName;
    @XmlAttribute(name="EndTime")
    @XmlJavaTypeAdapter(value=DateTime.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime endTime;
    @XmlAttribute(name="PersonalID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String personalID;
    @XmlAttribute(name="Roles")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> roles;
    @XmlAttribute(name="StartTime")
    @XmlJavaTypeAdapter(value=DateTime.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime startTime;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment value) {
        this.comment = value;
    }

    public String getActivityID() {
        return this.activityID;
    }

    public void setActivityID(String value) {
        this.activityID = value;
    }

    public String getActivityName() {
        return this.activityName;
    }

    public void setActivityName(String value) {
        this.activityName = value;
    }

    public DateTime getEndTime() {
        return this.endTime;
    }

    public void setEndTime(DateTime value) {
        this.endTime = value;
    }

    public String getPersonalID() {
        return this.personalID;
    }

    public void setPersonalID(String value) {
        this.personalID = value;
    }

    public List<String> getRoles() {
        if (this.roles == null) {
            this.roles = new ArrayList<String>();
        }
        return this.roles;
    }

    public DateTime getStartTime() {
        return this.startTime;
    }

    public void setStartTime(DateTime value) {
        this.startTime = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Activity withComment(Comment value) {
        this.setComment(value);
        return this;
    }

    public Activity withActivityID(String value) {
        this.setActivityID(value);
        return this;
    }

    public Activity withActivityName(String value) {
        this.setActivityName(value);
        return this;
    }

    public Activity withEndTime(DateTime value) {
        this.setEndTime(value);
        return this;
    }

    public Activity withPersonalID(String value) {
        this.setPersonalID(value);
        return this;
    }

    public Activity withRoles(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getRoles().add(value);
            }
        }
        return this;
    }

    public Activity withRoles(Collection<String> values) {
        if (values != null) {
            this.getRoles().addAll(values);
        }
        return this;
    }

    public Activity withStartTime(DateTime value) {
        this.setStartTime(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightRoles;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Activity that = (Activity)object;
        Comment leftComment = this.getComment();
        Comment rightComment = that.getComment();
        if (this.comment != null) {
            if (that.comment == null) return false;
            if (!leftComment.equals(rightComment)) {
                return false;
            }
        } else if (that.comment != null) {
            return false;
        }
        String leftActivityID = this.getActivityID();
        String rightActivityID = that.getActivityID();
        if (this.activityID != null) {
            if (that.activityID == null) return false;
            if (!leftActivityID.equals(rightActivityID)) {
                return false;
            }
        } else if (that.activityID != null) {
            return false;
        }
        String leftActivityName = this.getActivityName();
        String rightActivityName = that.getActivityName();
        if (this.activityName != null) {
            if (that.activityName == null) return false;
            if (!leftActivityName.equals(rightActivityName)) {
                return false;
            }
        } else if (that.activityName != null) {
            return false;
        }
        DateTime leftEndTime = this.getEndTime();
        DateTime rightEndTime = that.getEndTime();
        if (this.endTime != null) {
            if (that.endTime == null) return false;
            if (!leftEndTime.equals((Object)rightEndTime)) {
                return false;
            }
        } else if (that.endTime != null) {
            return false;
        }
        String leftPersonalID = this.getPersonalID();
        String rightPersonalID = that.getPersonalID();
        if (this.personalID != null) {
            if (that.personalID == null) return false;
            if (!leftPersonalID.equals(rightPersonalID)) {
                return false;
            }
        } else if (that.personalID != null) {
            return false;
        }
        List<String> leftRoles = this.roles != null && !this.roles.isEmpty() ? this.getRoles() : null;
        List<String> list = rightRoles = that.roles != null && !that.roles.isEmpty() ? that.getRoles() : null;
        if (this.roles != null && !this.roles.isEmpty()) {
            if (that.roles == null || that.roles.isEmpty()) return false;
            if (!leftRoles.equals(rightRoles)) {
                return false;
            }
        } else if (that.roles != null && !that.roles.isEmpty()) {
            return false;
        }
        DateTime leftStartTime = this.getStartTime();
        DateTime rightStartTime = that.getStartTime();
        if (this.startTime != null) {
            if (that.startTime == null) return false;
            if (leftStartTime.equals((Object)rightStartTime)) return true;
            return false;
        }
        if (that.startTime == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> theRoles;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Comment theComment = this.getComment();
        if (this.comment != null) {
            currentHashCode += theComment.hashCode();
        }
        currentHashCode *= 31;
        String theActivityID = this.getActivityID();
        if (this.activityID != null) {
            currentHashCode += theActivityID.hashCode();
        }
        currentHashCode *= 31;
        String theActivityName = this.getActivityName();
        if (this.activityName != null) {
            currentHashCode += theActivityName.hashCode();
        }
        currentHashCode *= 31;
        DateTime theEndTime = this.getEndTime();
        if (this.endTime != null) {
            currentHashCode += theEndTime.hashCode();
        }
        currentHashCode *= 31;
        String thePersonalID = this.getPersonalID();
        if (this.personalID != null) {
            currentHashCode += thePersonalID.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theRoles = this.roles != null && !this.roles.isEmpty() ? this.getRoles() : null;
        if (this.roles != null && !this.roles.isEmpty()) {
            currentHashCode += theRoles.hashCode();
        }
        currentHashCode *= 31;
        DateTime theStartTime = this.getStartTime();
        if (this.startTime != null) {
            currentHashCode += theStartTime.hashCode();
        }
        return currentHashCode;
    }
}

