/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.DropItem;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.DateTime;
import org.cip4.lib.xjdf.type.Duration;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="DeliveryParams", propOrder={"dropItem", "fileSpec"})
public class DeliveryParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="DropItem")
    protected List<DropItem> dropItem;
    @XmlElement(name="FileSpec")
    protected List<FileSpec> fileSpec;
    @XmlAttribute(name="BuyerAccount")
    protected String buyerAccount;
    @XmlAttribute(name="Earliest")
    @XmlJavaTypeAdapter(value=DateTime.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime earliest;
    @XmlAttribute(name="EarliestDuration")
    @XmlJavaTypeAdapter(value=Duration.class)
    @XmlSchemaType(name="duration")
    protected Duration earliestDuration;
    @XmlAttribute(name="Method")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String method;
    @XmlAttribute(name="Ownership")
    protected Ownership ownership;
    @XmlAttribute(name="Required")
    @XmlJavaTypeAdapter(value=DateTime.class)
    @XmlSchemaType(name="dateTime")
    protected DateTime required;
    @XmlAttribute(name="RequiredDuration")
    @XmlJavaTypeAdapter(value=Duration.class)
    @XmlSchemaType(name="duration")
    protected Duration requiredDuration;
    @XmlAttribute(name="TrackingID")
    protected String trackingID;
    @XmlAttribute(name="Transfer")
    protected Transfer transfer;

    public List<DropItem> getDropItem() {
        if (this.dropItem == null) {
            this.dropItem = new ArrayList<DropItem>();
        }
        return this.dropItem;
    }

    public List<FileSpec> getFileSpec() {
        if (this.fileSpec == null) {
            this.fileSpec = new ArrayList<FileSpec>();
        }
        return this.fileSpec;
    }

    public String getBuyerAccount() {
        return this.buyerAccount;
    }

    public void setBuyerAccount(String value) {
        this.buyerAccount = value;
    }

    public DateTime getEarliest() {
        return this.earliest;
    }

    public void setEarliest(DateTime value) {
        this.earliest = value;
    }

    public Duration getEarliestDuration() {
        return this.earliestDuration;
    }

    public void setEarliestDuration(Duration value) {
        this.earliestDuration = value;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String value) {
        this.method = value;
    }

    public Ownership getOwnership() {
        return this.ownership;
    }

    public void setOwnership(Ownership value) {
        this.ownership = value;
    }

    public DateTime getRequired() {
        return this.required;
    }

    public void setRequired(DateTime value) {
        this.required = value;
    }

    public Duration getRequiredDuration() {
        return this.requiredDuration;
    }

    public void setRequiredDuration(Duration value) {
        this.requiredDuration = value;
    }

    public String getTrackingID() {
        return this.trackingID;
    }

    public void setTrackingID(String value) {
        this.trackingID = value;
    }

    public Transfer getTransfer() {
        return this.transfer;
    }

    public void setTransfer(Transfer value) {
        this.transfer = value;
    }

    public DeliveryParams withDropItem(DropItem ... values) {
        if (values != null) {
            for (DropItem value : values) {
                this.getDropItem().add(value);
            }
        }
        return this;
    }

    public DeliveryParams withDropItem(Collection<DropItem> values) {
        if (values != null) {
            this.getDropItem().addAll(values);
        }
        return this;
    }

    public DeliveryParams withFileSpec(FileSpec ... values) {
        if (values != null) {
            for (FileSpec value : values) {
                this.getFileSpec().add(value);
            }
        }
        return this;
    }

    public DeliveryParams withFileSpec(Collection<FileSpec> values) {
        if (values != null) {
            this.getFileSpec().addAll(values);
        }
        return this;
    }

    public DeliveryParams withBuyerAccount(String value) {
        this.setBuyerAccount(value);
        return this;
    }

    public DeliveryParams withEarliest(DateTime value) {
        this.setEarliest(value);
        return this;
    }

    public DeliveryParams withEarliestDuration(Duration value) {
        this.setEarliestDuration(value);
        return this;
    }

    public DeliveryParams withMethod(String value) {
        this.setMethod(value);
        return this;
    }

    public DeliveryParams withOwnership(Ownership value) {
        this.setOwnership(value);
        return this;
    }

    public DeliveryParams withRequired(DateTime value) {
        this.setRequired(value);
        return this;
    }

    public DeliveryParams withRequiredDuration(Duration value) {
        this.setRequiredDuration(value);
        return this;
    }

    public DeliveryParams withTrackingID(String value) {
        this.setTrackingID(value);
        return this;
    }

    public DeliveryParams withTransfer(Transfer value) {
        this.setTransfer(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<FileSpec> rightFileSpec;
        List<DropItem> rightDropItem;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        DeliveryParams that = (DeliveryParams)object;
        List<DropItem> leftDropItem = this.dropItem != null && !this.dropItem.isEmpty() ? this.getDropItem() : null;
        List<DropItem> list = rightDropItem = that.dropItem != null && !that.dropItem.isEmpty() ? that.getDropItem() : null;
        if (this.dropItem != null && !this.dropItem.isEmpty()) {
            if (that.dropItem == null || that.dropItem.isEmpty()) return false;
            if (!leftDropItem.equals(rightDropItem)) {
                return false;
            }
        } else if (that.dropItem != null && !that.dropItem.isEmpty()) {
            return false;
        }
        List<FileSpec> leftFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        List<FileSpec> list2 = rightFileSpec = that.fileSpec != null && !that.fileSpec.isEmpty() ? that.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            if (that.fileSpec == null || that.fileSpec.isEmpty()) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null && !that.fileSpec.isEmpty()) {
            return false;
        }
        String leftBuyerAccount = this.getBuyerAccount();
        String rightBuyerAccount = that.getBuyerAccount();
        if (this.buyerAccount != null) {
            if (that.buyerAccount == null) return false;
            if (!leftBuyerAccount.equals(rightBuyerAccount)) {
                return false;
            }
        } else if (that.buyerAccount != null) {
            return false;
        }
        DateTime leftEarliest = this.getEarliest();
        DateTime rightEarliest = that.getEarliest();
        if (this.earliest != null) {
            if (that.earliest == null) return false;
            if (!leftEarliest.equals((Object)rightEarliest)) {
                return false;
            }
        } else if (that.earliest != null) {
            return false;
        }
        Duration leftEarliestDuration = this.getEarliestDuration();
        Duration rightEarliestDuration = that.getEarliestDuration();
        if (this.earliestDuration != null) {
            if (that.earliestDuration == null) return false;
            if (!leftEarliestDuration.equals((Object)rightEarliestDuration)) {
                return false;
            }
        } else if (that.earliestDuration != null) {
            return false;
        }
        String leftMethod = this.getMethod();
        String rightMethod = that.getMethod();
        if (this.method != null) {
            if (that.method == null) return false;
            if (!leftMethod.equals(rightMethod)) {
                return false;
            }
        } else if (that.method != null) {
            return false;
        }
        Ownership leftOwnership = this.getOwnership();
        Ownership rightOwnership = that.getOwnership();
        if (this.ownership != null) {
            if (that.ownership == null) return false;
            if (!leftOwnership.equals((Object)rightOwnership)) {
                return false;
            }
        } else if (that.ownership != null) {
            return false;
        }
        DateTime leftRequired = this.getRequired();
        DateTime rightRequired = that.getRequired();
        if (this.required != null) {
            if (that.required == null) return false;
            if (!leftRequired.equals((Object)rightRequired)) {
                return false;
            }
        } else if (that.required != null) {
            return false;
        }
        Duration leftRequiredDuration = this.getRequiredDuration();
        Duration rightRequiredDuration = that.getRequiredDuration();
        if (this.requiredDuration != null) {
            if (that.requiredDuration == null) return false;
            if (!leftRequiredDuration.equals((Object)rightRequiredDuration)) {
                return false;
            }
        } else if (that.requiredDuration != null) {
            return false;
        }
        String leftTrackingID = this.getTrackingID();
        String rightTrackingID = that.getTrackingID();
        if (this.trackingID != null) {
            if (that.trackingID == null) return false;
            if (!leftTrackingID.equals(rightTrackingID)) {
                return false;
            }
        } else if (that.trackingID != null) {
            return false;
        }
        Transfer leftTransfer = this.getTransfer();
        Transfer rightTransfer = that.getTransfer();
        if (this.transfer != null) {
            if (that.transfer == null) return false;
            if (leftTransfer.equals((Object)rightTransfer)) return true;
            return false;
        }
        if (that.transfer == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<FileSpec> theFileSpec;
        List<DropItem> theDropItem;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<DropItem> list = theDropItem = this.dropItem != null && !this.dropItem.isEmpty() ? this.getDropItem() : null;
        if (this.dropItem != null && !this.dropItem.isEmpty()) {
            currentHashCode += theDropItem.hashCode();
        }
        currentHashCode *= 31;
        List<FileSpec> list2 = theFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        String theBuyerAccount = this.getBuyerAccount();
        if (this.buyerAccount != null) {
            currentHashCode += theBuyerAccount.hashCode();
        }
        currentHashCode *= 31;
        DateTime theEarliest = this.getEarliest();
        if (this.earliest != null) {
            currentHashCode += theEarliest.hashCode();
        }
        currentHashCode *= 31;
        Duration theEarliestDuration = this.getEarliestDuration();
        if (this.earliestDuration != null) {
            currentHashCode += theEarliestDuration.hashCode();
        }
        currentHashCode *= 31;
        String theMethod = this.getMethod();
        if (this.method != null) {
            currentHashCode += theMethod.hashCode();
        }
        currentHashCode *= 31;
        Ownership theOwnership = this.getOwnership();
        if (this.ownership != null) {
            currentHashCode += theOwnership.hashCode();
        }
        currentHashCode *= 31;
        DateTime theRequired = this.getRequired();
        if (this.required != null) {
            currentHashCode += theRequired.hashCode();
        }
        currentHashCode *= 31;
        Duration theRequiredDuration = this.getRequiredDuration();
        if (this.requiredDuration != null) {
            currentHashCode += theRequiredDuration.hashCode();
        }
        currentHashCode *= 31;
        String theTrackingID = this.getTrackingID();
        if (this.trackingID != null) {
            currentHashCode += theTrackingID.hashCode();
        }
        currentHashCode *= 31;
        Transfer theTransfer = this.getTransfer();
        if (this.transfer != null) {
            currentHashCode += theTransfer.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Transfer {
        BUYER_TO_PRINTER_DELIVER("BuyerToPrinterDeliver"),
        BUYER_TO_PRINTER_PICKUP("BuyerToPrinterPickup"),
        PRINTER_TO_BUYER_DELIVER("PrinterToBuyerDeliver"),
        PRINTER_TO_BUYER_PICKUP("PrinterToBuyerPickup");

        private final String value;

        private Transfer(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Transfer fromValue(String v) {
            for (Transfer c : Transfer.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Ownership {
        DESTINATION("Destination"),
        ORIGIN("Origin");

        private final String value;

        private Ownership(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Ownership fromValue(String v) {
            for (Ownership c : Ownership.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

