/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LayoutElementProductionParams", propOrder={"fileSpec"})
public class LayoutElementProductionParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlAttribute(name="ContentRefs")
    @XmlIDREF
    @XmlSchemaType(name="IDREFS")
    protected List<Resource> contents;
    @XmlAttribute(name="ShapeDefRef")
    @XmlIDREF
    @XmlSchemaType(name="IDREF")
    protected Resource shapeDef;

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public List<Resource> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<Resource>();
        }
        return this.contents;
    }

    public Resource getShapeDef() {
        return this.shapeDef;
    }

    public void setShapeDef(Resource value) {
        this.shapeDef = value;
    }

    public LayoutElementProductionParams withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public LayoutElementProductionParams withContents(Resource ... values) {
        if (values != null) {
            for (Resource value : values) {
                this.getContents().add(value);
            }
        }
        return this;
    }

    public LayoutElementProductionParams withContents(Collection<Resource> values) {
        if (values != null) {
            this.getContents().addAll(values);
        }
        return this;
    }

    public LayoutElementProductionParams withShapeDef(Resource value) {
        this.setShapeDef(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Resource> rightContents;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LayoutElementProductionParams that = (LayoutElementProductionParams)object;
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        List<Resource> leftContents = this.contents != null && !this.contents.isEmpty() ? this.getContents() : null;
        List<Resource> list = rightContents = that.contents != null && !that.contents.isEmpty() ? that.getContents() : null;
        if (this.contents != null && !this.contents.isEmpty()) {
            if (that.contents == null || that.contents.isEmpty()) return false;
            if (!leftContents.equals(rightContents)) {
                return false;
            }
        } else if (that.contents != null && !that.contents.isEmpty()) {
            return false;
        }
        Resource leftShapeDef = this.getShapeDef();
        Resource rightShapeDef = that.getShapeDef();
        if (this.shapeDef != null) {
            if (that.shapeDef == null) return false;
            if (leftShapeDef.equals(rightShapeDef)) return true;
            return false;
        }
        if (that.shapeDef == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Resource> theContents;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        List<Resource> list = theContents = this.contents != null && !this.contents.isEmpty() ? this.getContents() : null;
        if (this.contents != null && !this.contents.isEmpty()) {
            currentHashCode += theContents.hashCode();
        }
        currentHashCode *= 31;
        Resource theShapeDef = this.getShapeDef();
        if (this.shapeDef != null) {
            currentHashCode += theShapeDef.hashCode();
        }
        return currentHashCode;
    }
}

