/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="ObjectResolution")
public class ObjectResolution
implements Serializable {
    @XmlAttribute(name="AntiAliasing")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String antiAliasing;
    @XmlAttribute(name="Resolution", required=true)
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair resolution;
    @XmlAttribute(name="SourceObjects")
    protected List<String> sourceObjects;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public String getAntiAliasing() {
        return this.antiAliasing;
    }

    public void setAntiAliasing(String value) {
        this.antiAliasing = value;
    }

    public XYPair getResolution() {
        return this.resolution;
    }

    public void setResolution(XYPair value) {
        this.resolution = value;
    }

    public List<String> getSourceObjects() {
        if (this.sourceObjects == null) {
            this.sourceObjects = new ArrayList<String>();
        }
        return this.sourceObjects;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ObjectResolution withAntiAliasing(String value) {
        this.setAntiAliasing(value);
        return this;
    }

    public ObjectResolution withResolution(XYPair value) {
        this.setResolution(value);
        return this;
    }

    public ObjectResolution withSourceObjects(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSourceObjects().add(value);
            }
        }
        return this;
    }

    public ObjectResolution withSourceObjects(Collection<String> values) {
        if (values != null) {
            this.getSourceObjects().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightSourceObjects;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ObjectResolution that = (ObjectResolution)object;
        String leftAntiAliasing = this.getAntiAliasing();
        String rightAntiAliasing = that.getAntiAliasing();
        if (this.antiAliasing != null) {
            if (that.antiAliasing == null) return false;
            if (!leftAntiAliasing.equals(rightAntiAliasing)) {
                return false;
            }
        } else if (that.antiAliasing != null) {
            return false;
        }
        XYPair leftResolution = this.getResolution();
        XYPair rightResolution = that.getResolution();
        if (this.resolution != null) {
            if (that.resolution == null) return false;
            if (!leftResolution.equals((Object)rightResolution)) {
                return false;
            }
        } else if (that.resolution != null) {
            return false;
        }
        List<String> leftSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        List<String> list = rightSourceObjects = that.sourceObjects != null && !that.sourceObjects.isEmpty() ? that.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            if (that.sourceObjects == null || that.sourceObjects.isEmpty()) return false;
            if (leftSourceObjects.equals(rightSourceObjects)) return true;
            return false;
        }
        if (that.sourceObjects == null || that.sourceObjects.isEmpty()) return true;
        return false;
    }

    public int hashCode() {
        List<String> theSourceObjects;
        int currentHashCode = 1;
        currentHashCode *= 31;
        String theAntiAliasing = this.getAntiAliasing();
        if (this.antiAliasing != null) {
            currentHashCode += theAntiAliasing.hashCode();
        }
        currentHashCode *= 31;
        XYPair theResolution = this.getResolution();
        if (this.resolution != null) {
            currentHashCode += theResolution.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = theSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            currentHashCode += theSourceObjects.hashCode();
        }
        return currentHashCode;
    }
}

