/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.PreflightCheck;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PreflightReport", propOrder={"fileSpec", "preflightCheck"})
public class PreflightReport
extends SpecificResource
implements Serializable {
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlElement(name="PreflightCheck")
    protected List<PreflightCheck> preflightCheck;
    @XmlAttribute(name="ErrorCount")
    protected Integer errorCount;
    @XmlAttribute(name="WarningCount")
    protected Integer warningCount;

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public List<PreflightCheck> getPreflightCheck() {
        if (this.preflightCheck == null) {
            this.preflightCheck = new ArrayList<PreflightCheck>();
        }
        return this.preflightCheck;
    }

    public Integer getErrorCount() {
        return this.errorCount;
    }

    public void setErrorCount(Integer value) {
        this.errorCount = value;
    }

    public Integer getWarningCount() {
        return this.warningCount;
    }

    public void setWarningCount(Integer value) {
        this.warningCount = value;
    }

    public PreflightReport withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public PreflightReport withPreflightCheck(PreflightCheck ... values) {
        if (values != null) {
            for (PreflightCheck value : values) {
                this.getPreflightCheck().add(value);
            }
        }
        return this;
    }

    public PreflightReport withPreflightCheck(Collection<PreflightCheck> values) {
        if (values != null) {
            this.getPreflightCheck().addAll(values);
        }
        return this;
    }

    public PreflightReport withErrorCount(Integer value) {
        this.setErrorCount(value);
        return this;
    }

    public PreflightReport withWarningCount(Integer value) {
        this.setWarningCount(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<PreflightCheck> rightPreflightCheck;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PreflightReport that = (PreflightReport)object;
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        List<PreflightCheck> leftPreflightCheck = this.preflightCheck != null && !this.preflightCheck.isEmpty() ? this.getPreflightCheck() : null;
        List<PreflightCheck> list = rightPreflightCheck = that.preflightCheck != null && !that.preflightCheck.isEmpty() ? that.getPreflightCheck() : null;
        if (this.preflightCheck != null && !this.preflightCheck.isEmpty()) {
            if (that.preflightCheck == null || that.preflightCheck.isEmpty()) return false;
            if (!leftPreflightCheck.equals(rightPreflightCheck)) {
                return false;
            }
        } else if (that.preflightCheck != null && !that.preflightCheck.isEmpty()) {
            return false;
        }
        Integer leftErrorCount = this.getErrorCount();
        Integer rightErrorCount = that.getErrorCount();
        if (this.errorCount != null) {
            if (that.errorCount == null) return false;
            if (!leftErrorCount.equals(rightErrorCount)) {
                return false;
            }
        } else if (that.errorCount != null) {
            return false;
        }
        Integer leftWarningCount = this.getWarningCount();
        Integer rightWarningCount = that.getWarningCount();
        if (this.warningCount != null) {
            if (that.warningCount == null) return false;
            if (leftWarningCount.equals(rightWarningCount)) return true;
            return false;
        }
        if (that.warningCount == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<PreflightCheck> thePreflightCheck;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        List<PreflightCheck> list = thePreflightCheck = this.preflightCheck != null && !this.preflightCheck.isEmpty() ? this.getPreflightCheck() : null;
        if (this.preflightCheck != null && !this.preflightCheck.isEmpty()) {
            currentHashCode += thePreflightCheck.hashCode();
        }
        currentHashCode *= 31;
        Integer theErrorCount = this.getErrorCount();
        if (this.errorCount != null) {
            currentHashCode += theErrorCount.hashCode();
        }
        currentHashCode *= 31;
        Integer theWarningCount = this.getWarningCount();
        if (this.warningCount != null) {
            currentHashCode += theWarningCount.hashCode();
        }
        return currentHashCode;
    }
}

