/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="PreviewGenerationParams")
public class PreviewGenerationParams
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="AspectRatio")
    protected AspectRatio aspectRatio;
    @XmlAttribute(name="Resolution")
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair resolution;
    @XmlAttribute(name="Size")
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair size;

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(AspectRatio value) {
        this.aspectRatio = value;
    }

    public XYPair getResolution() {
        return this.resolution;
    }

    public void setResolution(XYPair value) {
        this.resolution = value;
    }

    public XYPair getSize() {
        return this.size;
    }

    public void setSize(XYPair value) {
        this.size = value;
    }

    public PreviewGenerationParams withAspectRatio(AspectRatio value) {
        this.setAspectRatio(value);
        return this;
    }

    public PreviewGenerationParams withResolution(XYPair value) {
        this.setResolution(value);
        return this;
    }

    public PreviewGenerationParams withSize(XYPair value) {
        this.setSize(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        PreviewGenerationParams that = (PreviewGenerationParams)object;
        AspectRatio leftAspectRatio = this.getAspectRatio();
        AspectRatio rightAspectRatio = that.getAspectRatio();
        if (this.aspectRatio != null) {
            if (that.aspectRatio == null) return false;
            if (!leftAspectRatio.equals((Object)rightAspectRatio)) {
                return false;
            }
        } else if (that.aspectRatio != null) {
            return false;
        }
        XYPair leftResolution = this.getResolution();
        XYPair rightResolution = that.getResolution();
        if (this.resolution != null) {
            if (that.resolution == null) return false;
            if (!leftResolution.equals((Object)rightResolution)) {
                return false;
            }
        } else if (that.resolution != null) {
            return false;
        }
        XYPair leftSize = this.getSize();
        XYPair rightSize = that.getSize();
        if (this.size != null) {
            if (that.size == null) return false;
            if (leftSize.equals((Object)rightSize)) return true;
            return false;
        }
        if (that.size == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        AspectRatio theAspectRatio = this.getAspectRatio();
        if (this.aspectRatio != null) {
            currentHashCode += theAspectRatio.hashCode();
        }
        currentHashCode *= 31;
        XYPair theResolution = this.getResolution();
        if (this.resolution != null) {
            currentHashCode += theResolution.hashCode();
        }
        currentHashCode *= 31;
        XYPair theSize = this.getSize();
        if (this.size != null) {
            currentHashCode += theSize.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum AspectRatio {
        CENTER_MAX("CenterMax"),
        CENTER_MIN("CenterMin"),
        CROP("Crop"),
        EXPAND("Expand"),
        IGNORE("Ignore");

        private final String value;

        private AspectRatio(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static AspectRatio fromValue(String v) {
            for (AspectRatio c : AspectRatio.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

