/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.BindingQuality;
import org.cip4.lib.xjdf.schema.BindingQualityParams;
import org.cip4.lib.xjdf.schema.ColorMeasurement;
import org.cip4.lib.xjdf.schema.Face;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.RegistrationQuality;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.Duration;
import org.cip4.lib.xjdf.type.Rectangle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="QualityControlParams", propOrder={"bindingQualityParams", "bindingQuality", "colorMeasurement", "fileSpec", "registrationQuality"})
public class QualityControlParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="BindingQualityParams")
    protected BindingQualityParams bindingQualityParams;
    @XmlElement(name="BindingQuality")
    protected BindingQuality bindingQuality;
    @XmlElement(name="ColorMeasurement")
    protected ColorMeasurement colorMeasurement;
    @XmlElement(name="FileSpec")
    protected List<FileSpec> fileSpec;
    @XmlElement(name="RegistrationQuality")
    protected RegistrationQuality registrationQuality;
    @XmlAttribute(name="Box")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle box;
    @XmlAttribute(name="Position")
    protected Face position;
    @XmlAttribute(name="QualityBase")
    protected QualityBase qualityBase;
    @XmlAttribute(name="QualityControlMethods")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> qualityControlMethods;
    @XmlAttribute(name="SampleInterval")
    protected Integer sampleInterval;
    @XmlAttribute(name="Severity")
    protected Integer severity;
    @XmlAttribute(name="SourceDeviceID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String sourceDeviceID;
    @XmlAttribute(name="TimeInterval")
    @XmlJavaTypeAdapter(value=Duration.class)
    @XmlSchemaType(name="duration")
    protected Duration timeInterval;

    public BindingQualityParams getBindingQualityParams() {
        return this.bindingQualityParams;
    }

    public void setBindingQualityParams(BindingQualityParams value) {
        this.bindingQualityParams = value;
    }

    public BindingQuality getBindingQuality() {
        return this.bindingQuality;
    }

    public void setBindingQuality(BindingQuality value) {
        this.bindingQuality = value;
    }

    public ColorMeasurement getColorMeasurement() {
        return this.colorMeasurement;
    }

    public void setColorMeasurement(ColorMeasurement value) {
        this.colorMeasurement = value;
    }

    public List<FileSpec> getFileSpec() {
        if (this.fileSpec == null) {
            this.fileSpec = new ArrayList<FileSpec>();
        }
        return this.fileSpec;
    }

    public RegistrationQuality getRegistrationQuality() {
        return this.registrationQuality;
    }

    public void setRegistrationQuality(RegistrationQuality value) {
        this.registrationQuality = value;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle value) {
        this.box = value;
    }

    public Face getPosition() {
        return this.position;
    }

    public void setPosition(Face value) {
        this.position = value;
    }

    public QualityBase getQualityBase() {
        return this.qualityBase;
    }

    public void setQualityBase(QualityBase value) {
        this.qualityBase = value;
    }

    public List<String> getQualityControlMethods() {
        if (this.qualityControlMethods == null) {
            this.qualityControlMethods = new ArrayList<String>();
        }
        return this.qualityControlMethods;
    }

    public Integer getSampleInterval() {
        return this.sampleInterval;
    }

    public void setSampleInterval(Integer value) {
        this.sampleInterval = value;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer value) {
        this.severity = value;
    }

    public String getSourceDeviceID() {
        return this.sourceDeviceID;
    }

    public void setSourceDeviceID(String value) {
        this.sourceDeviceID = value;
    }

    public Duration getTimeInterval() {
        return this.timeInterval;
    }

    public void setTimeInterval(Duration value) {
        this.timeInterval = value;
    }

    public QualityControlParams withBindingQualityParams(BindingQualityParams value) {
        this.setBindingQualityParams(value);
        return this;
    }

    public QualityControlParams withBindingQuality(BindingQuality value) {
        this.setBindingQuality(value);
        return this;
    }

    public QualityControlParams withColorMeasurement(ColorMeasurement value) {
        this.setColorMeasurement(value);
        return this;
    }

    public QualityControlParams withFileSpec(FileSpec ... values) {
        if (values != null) {
            for (FileSpec value : values) {
                this.getFileSpec().add(value);
            }
        }
        return this;
    }

    public QualityControlParams withFileSpec(Collection<FileSpec> values) {
        if (values != null) {
            this.getFileSpec().addAll(values);
        }
        return this;
    }

    public QualityControlParams withRegistrationQuality(RegistrationQuality value) {
        this.setRegistrationQuality(value);
        return this;
    }

    public QualityControlParams withBox(Rectangle value) {
        this.setBox(value);
        return this;
    }

    public QualityControlParams withPosition(Face value) {
        this.setPosition(value);
        return this;
    }

    public QualityControlParams withQualityBase(QualityBase value) {
        this.setQualityBase(value);
        return this;
    }

    public QualityControlParams withQualityControlMethods(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getQualityControlMethods().add(value);
            }
        }
        return this;
    }

    public QualityControlParams withQualityControlMethods(Collection<String> values) {
        if (values != null) {
            this.getQualityControlMethods().addAll(values);
        }
        return this;
    }

    public QualityControlParams withSampleInterval(Integer value) {
        this.setSampleInterval(value);
        return this;
    }

    public QualityControlParams withSeverity(Integer value) {
        this.setSeverity(value);
        return this;
    }

    public QualityControlParams withSourceDeviceID(String value) {
        this.setSourceDeviceID(value);
        return this;
    }

    public QualityControlParams withTimeInterval(Duration value) {
        this.setTimeInterval(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightQualityControlMethods;
        List<FileSpec> rightFileSpec;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        QualityControlParams that = (QualityControlParams)object;
        BindingQualityParams leftBindingQualityParams = this.getBindingQualityParams();
        BindingQualityParams rightBindingQualityParams = that.getBindingQualityParams();
        if (this.bindingQualityParams != null) {
            if (that.bindingQualityParams == null) return false;
            if (!leftBindingQualityParams.equals(rightBindingQualityParams)) {
                return false;
            }
        } else if (that.bindingQualityParams != null) {
            return false;
        }
        BindingQuality leftBindingQuality = this.getBindingQuality();
        BindingQuality rightBindingQuality = that.getBindingQuality();
        if (this.bindingQuality != null) {
            if (that.bindingQuality == null) return false;
            if (!leftBindingQuality.equals(rightBindingQuality)) {
                return false;
            }
        } else if (that.bindingQuality != null) {
            return false;
        }
        ColorMeasurement leftColorMeasurement = this.getColorMeasurement();
        ColorMeasurement rightColorMeasurement = that.getColorMeasurement();
        if (this.colorMeasurement != null) {
            if (that.colorMeasurement == null) return false;
            if (!leftColorMeasurement.equals(rightColorMeasurement)) {
                return false;
            }
        } else if (that.colorMeasurement != null) {
            return false;
        }
        List<FileSpec> leftFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        List<FileSpec> list = rightFileSpec = that.fileSpec != null && !that.fileSpec.isEmpty() ? that.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            if (that.fileSpec == null || that.fileSpec.isEmpty()) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null && !that.fileSpec.isEmpty()) {
            return false;
        }
        RegistrationQuality leftRegistrationQuality = this.getRegistrationQuality();
        RegistrationQuality rightRegistrationQuality = that.getRegistrationQuality();
        if (this.registrationQuality != null) {
            if (that.registrationQuality == null) return false;
            if (!leftRegistrationQuality.equals(rightRegistrationQuality)) {
                return false;
            }
        } else if (that.registrationQuality != null) {
            return false;
        }
        Rectangle leftBox = this.getBox();
        Rectangle rightBox = that.getBox();
        if (this.box != null) {
            if (that.box == null) return false;
            if (!leftBox.equals((Object)rightBox)) {
                return false;
            }
        } else if (that.box != null) {
            return false;
        }
        Face leftPosition = this.getPosition();
        Face rightPosition = that.getPosition();
        if (this.position != null) {
            if (that.position == null) return false;
            if (!leftPosition.equals((Object)rightPosition)) {
                return false;
            }
        } else if (that.position != null) {
            return false;
        }
        QualityBase leftQualityBase = this.getQualityBase();
        QualityBase rightQualityBase = that.getQualityBase();
        if (this.qualityBase != null) {
            if (that.qualityBase == null) return false;
            if (!leftQualityBase.equals((Object)rightQualityBase)) {
                return false;
            }
        } else if (that.qualityBase != null) {
            return false;
        }
        List<String> leftQualityControlMethods = this.qualityControlMethods != null && !this.qualityControlMethods.isEmpty() ? this.getQualityControlMethods() : null;
        List<String> list2 = rightQualityControlMethods = that.qualityControlMethods != null && !that.qualityControlMethods.isEmpty() ? that.getQualityControlMethods() : null;
        if (this.qualityControlMethods != null && !this.qualityControlMethods.isEmpty()) {
            if (that.qualityControlMethods == null || that.qualityControlMethods.isEmpty()) return false;
            if (!leftQualityControlMethods.equals(rightQualityControlMethods)) {
                return false;
            }
        } else if (that.qualityControlMethods != null && !that.qualityControlMethods.isEmpty()) {
            return false;
        }
        Integer leftSampleInterval = this.getSampleInterval();
        Integer rightSampleInterval = that.getSampleInterval();
        if (this.sampleInterval != null) {
            if (that.sampleInterval == null) return false;
            if (!leftSampleInterval.equals(rightSampleInterval)) {
                return false;
            }
        } else if (that.sampleInterval != null) {
            return false;
        }
        Integer leftSeverity = this.getSeverity();
        Integer rightSeverity = that.getSeverity();
        if (this.severity != null) {
            if (that.severity == null) return false;
            if (!leftSeverity.equals(rightSeverity)) {
                return false;
            }
        } else if (that.severity != null) {
            return false;
        }
        String leftSourceDeviceID = this.getSourceDeviceID();
        String rightSourceDeviceID = that.getSourceDeviceID();
        if (this.sourceDeviceID != null) {
            if (that.sourceDeviceID == null) return false;
            if (!leftSourceDeviceID.equals(rightSourceDeviceID)) {
                return false;
            }
        } else if (that.sourceDeviceID != null) {
            return false;
        }
        Duration leftTimeInterval = this.getTimeInterval();
        Duration rightTimeInterval = that.getTimeInterval();
        if (this.timeInterval != null) {
            if (that.timeInterval == null) return false;
            if (leftTimeInterval.equals((Object)rightTimeInterval)) return true;
            return false;
        }
        if (that.timeInterval == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theQualityControlMethods;
        List<FileSpec> theFileSpec;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        BindingQualityParams theBindingQualityParams = this.getBindingQualityParams();
        if (this.bindingQualityParams != null) {
            currentHashCode += theBindingQualityParams.hashCode();
        }
        currentHashCode *= 31;
        BindingQuality theBindingQuality = this.getBindingQuality();
        if (this.bindingQuality != null) {
            currentHashCode += theBindingQuality.hashCode();
        }
        currentHashCode *= 31;
        ColorMeasurement theColorMeasurement = this.getColorMeasurement();
        if (this.colorMeasurement != null) {
            currentHashCode += theColorMeasurement.hashCode();
        }
        currentHashCode *= 31;
        List<FileSpec> list = theFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        RegistrationQuality theRegistrationQuality = this.getRegistrationQuality();
        if (this.registrationQuality != null) {
            currentHashCode += theRegistrationQuality.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theBox = this.getBox();
        if (this.box != null) {
            currentHashCode += theBox.hashCode();
        }
        currentHashCode *= 31;
        Face thePosition = this.getPosition();
        if (this.position != null) {
            currentHashCode += thePosition.hashCode();
        }
        currentHashCode *= 31;
        QualityBase theQualityBase = this.getQualityBase();
        if (this.qualityBase != null) {
            currentHashCode += theQualityBase.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theQualityControlMethods = this.qualityControlMethods != null && !this.qualityControlMethods.isEmpty() ? this.getQualityControlMethods() : null;
        if (this.qualityControlMethods != null && !this.qualityControlMethods.isEmpty()) {
            currentHashCode += theQualityControlMethods.hashCode();
        }
        currentHashCode *= 31;
        Integer theSampleInterval = this.getSampleInterval();
        if (this.sampleInterval != null) {
            currentHashCode += theSampleInterval.hashCode();
        }
        currentHashCode *= 31;
        Integer theSeverity = this.getSeverity();
        if (this.severity != null) {
            currentHashCode += theSeverity.hashCode();
        }
        currentHashCode *= 31;
        String theSourceDeviceID = this.getSourceDeviceID();
        if (this.sourceDeviceID != null) {
            currentHashCode += theSourceDeviceID.hashCode();
        }
        currentHashCode *= 31;
        Duration theTimeInterval = this.getTimeInterval();
        if (this.timeInterval != null) {
            currentHashCode += theTimeInterval.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum QualityBase {
        ABSOLUTE("Absolute"),
        STANDARD("Standard");

        private final String value;

        private QualityBase(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static QualityBase fromValue(String v) {
            for (QualityBase c : QualityBase.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

