/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.AutomatedOverPrintParams;
import org.cip4.lib.xjdf.schema.ObjectResolution;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.TIFFFormatParams;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RenderingParams", propOrder={"automatedOverPrintParams", "objectResolution", "tiffFormatParams"})
public class RenderingParams
extends SpecificResource
implements Serializable {
    @XmlElement(name="AutomatedOverPrintParams")
    protected AutomatedOverPrintParams automatedOverPrintParams;
    @XmlElement(name="ObjectResolution")
    protected List<ObjectResolution> objectResolution;
    @XmlElement(name="TIFFFormatParams")
    protected TIFFFormatParams tiffFormatParams;
    @XmlAttribute(name="BandHeight")
    protected Integer bandHeight;
    @XmlAttribute(name="BandOrdering")
    protected BandOrdering bandOrdering;
    @XmlAttribute(name="BandWidth")
    protected Integer bandWidth;
    @XmlAttribute(name="ColorantDepth")
    protected Integer colorantDepth;
    @XmlAttribute(name="Interleaved")
    protected Boolean interleaved;
    @XmlAttribute(name="MimeType")
    protected String mimeType;

    public AutomatedOverPrintParams getAutomatedOverPrintParams() {
        return this.automatedOverPrintParams;
    }

    public void setAutomatedOverPrintParams(AutomatedOverPrintParams value) {
        this.automatedOverPrintParams = value;
    }

    public List<ObjectResolution> getObjectResolution() {
        if (this.objectResolution == null) {
            this.objectResolution = new ArrayList<ObjectResolution>();
        }
        return this.objectResolution;
    }

    public TIFFFormatParams getTIFFFormatParams() {
        return this.tiffFormatParams;
    }

    public void setTIFFFormatParams(TIFFFormatParams value) {
        this.tiffFormatParams = value;
    }

    public Integer getBandHeight() {
        return this.bandHeight;
    }

    public void setBandHeight(Integer value) {
        this.bandHeight = value;
    }

    public BandOrdering getBandOrdering() {
        return this.bandOrdering;
    }

    public void setBandOrdering(BandOrdering value) {
        this.bandOrdering = value;
    }

    public Integer getBandWidth() {
        return this.bandWidth;
    }

    public void setBandWidth(Integer value) {
        this.bandWidth = value;
    }

    public Integer getColorantDepth() {
        return this.colorantDepth;
    }

    public void setColorantDepth(Integer value) {
        this.colorantDepth = value;
    }

    public Boolean isInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(Boolean value) {
        this.interleaved = value;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String value) {
        this.mimeType = value;
    }

    public RenderingParams withAutomatedOverPrintParams(AutomatedOverPrintParams value) {
        this.setAutomatedOverPrintParams(value);
        return this;
    }

    public RenderingParams withObjectResolution(ObjectResolution ... values) {
        if (values != null) {
            for (ObjectResolution value : values) {
                this.getObjectResolution().add(value);
            }
        }
        return this;
    }

    public RenderingParams withObjectResolution(Collection<ObjectResolution> values) {
        if (values != null) {
            this.getObjectResolution().addAll(values);
        }
        return this;
    }

    public RenderingParams withTIFFFormatParams(TIFFFormatParams value) {
        this.setTIFFFormatParams(value);
        return this;
    }

    public RenderingParams withBandHeight(Integer value) {
        this.setBandHeight(value);
        return this;
    }

    public RenderingParams withBandOrdering(BandOrdering value) {
        this.setBandOrdering(value);
        return this;
    }

    public RenderingParams withBandWidth(Integer value) {
        this.setBandWidth(value);
        return this;
    }

    public RenderingParams withColorantDepth(Integer value) {
        this.setColorantDepth(value);
        return this;
    }

    public RenderingParams withInterleaved(Boolean value) {
        this.setInterleaved(value);
        return this;
    }

    public RenderingParams withMimeType(String value) {
        this.setMimeType(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<ObjectResolution> rightObjectResolution;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RenderingParams that = (RenderingParams)object;
        AutomatedOverPrintParams leftAutomatedOverPrintParams = this.getAutomatedOverPrintParams();
        AutomatedOverPrintParams rightAutomatedOverPrintParams = that.getAutomatedOverPrintParams();
        if (this.automatedOverPrintParams != null) {
            if (that.automatedOverPrintParams == null) return false;
            if (!leftAutomatedOverPrintParams.equals(rightAutomatedOverPrintParams)) {
                return false;
            }
        } else if (that.automatedOverPrintParams != null) {
            return false;
        }
        List<ObjectResolution> leftObjectResolution = this.objectResolution != null && !this.objectResolution.isEmpty() ? this.getObjectResolution() : null;
        List<ObjectResolution> list = rightObjectResolution = that.objectResolution != null && !that.objectResolution.isEmpty() ? that.getObjectResolution() : null;
        if (this.objectResolution != null && !this.objectResolution.isEmpty()) {
            if (that.objectResolution == null || that.objectResolution.isEmpty()) return false;
            if (!leftObjectResolution.equals(rightObjectResolution)) {
                return false;
            }
        } else if (that.objectResolution != null && !that.objectResolution.isEmpty()) {
            return false;
        }
        TIFFFormatParams leftTIFFFormatParams = this.getTIFFFormatParams();
        TIFFFormatParams rightTIFFFormatParams = that.getTIFFFormatParams();
        if (this.tiffFormatParams != null) {
            if (that.tiffFormatParams == null) return false;
            if (!leftTIFFFormatParams.equals(rightTIFFFormatParams)) {
                return false;
            }
        } else if (that.tiffFormatParams != null) {
            return false;
        }
        Integer leftBandHeight = this.getBandHeight();
        Integer rightBandHeight = that.getBandHeight();
        if (this.bandHeight != null) {
            if (that.bandHeight == null) return false;
            if (!leftBandHeight.equals(rightBandHeight)) {
                return false;
            }
        } else if (that.bandHeight != null) {
            return false;
        }
        BandOrdering leftBandOrdering = this.getBandOrdering();
        BandOrdering rightBandOrdering = that.getBandOrdering();
        if (this.bandOrdering != null) {
            if (that.bandOrdering == null) return false;
            if (!leftBandOrdering.equals((Object)rightBandOrdering)) {
                return false;
            }
        } else if (that.bandOrdering != null) {
            return false;
        }
        Integer leftBandWidth = this.getBandWidth();
        Integer rightBandWidth = that.getBandWidth();
        if (this.bandWidth != null) {
            if (that.bandWidth == null) return false;
            if (!leftBandWidth.equals(rightBandWidth)) {
                return false;
            }
        } else if (that.bandWidth != null) {
            return false;
        }
        Integer leftColorantDepth = this.getColorantDepth();
        Integer rightColorantDepth = that.getColorantDepth();
        if (this.colorantDepth != null) {
            if (that.colorantDepth == null) return false;
            if (!leftColorantDepth.equals(rightColorantDepth)) {
                return false;
            }
        } else if (that.colorantDepth != null) {
            return false;
        }
        Boolean leftInterleaved = this.isInterleaved();
        Boolean rightInterleaved = that.isInterleaved();
        if (this.interleaved != null) {
            if (that.interleaved == null) return false;
            if (!leftInterleaved.equals(rightInterleaved)) {
                return false;
            }
        } else if (that.interleaved != null) {
            return false;
        }
        String leftMimeType = this.getMimeType();
        String rightMimeType = that.getMimeType();
        if (this.mimeType != null) {
            if (that.mimeType == null) return false;
            if (leftMimeType.equals(rightMimeType)) return true;
            return false;
        }
        if (that.mimeType == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<ObjectResolution> theObjectResolution;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        AutomatedOverPrintParams theAutomatedOverPrintParams = this.getAutomatedOverPrintParams();
        if (this.automatedOverPrintParams != null) {
            currentHashCode += theAutomatedOverPrintParams.hashCode();
        }
        currentHashCode *= 31;
        List<ObjectResolution> list = theObjectResolution = this.objectResolution != null && !this.objectResolution.isEmpty() ? this.getObjectResolution() : null;
        if (this.objectResolution != null && !this.objectResolution.isEmpty()) {
            currentHashCode += theObjectResolution.hashCode();
        }
        currentHashCode *= 31;
        TIFFFormatParams theTIFFFormatParams = this.getTIFFFormatParams();
        if (this.tiffFormatParams != null) {
            currentHashCode += theTIFFFormatParams.hashCode();
        }
        currentHashCode *= 31;
        Integer theBandHeight = this.getBandHeight();
        if (this.bandHeight != null) {
            currentHashCode += theBandHeight.hashCode();
        }
        currentHashCode *= 31;
        BandOrdering theBandOrdering = this.getBandOrdering();
        if (this.bandOrdering != null) {
            currentHashCode += theBandOrdering.hashCode();
        }
        currentHashCode *= 31;
        Integer theBandWidth = this.getBandWidth();
        if (this.bandWidth != null) {
            currentHashCode += theBandWidth.hashCode();
        }
        currentHashCode *= 31;
        Integer theColorantDepth = this.getColorantDepth();
        if (this.colorantDepth != null) {
            currentHashCode += theColorantDepth.hashCode();
        }
        currentHashCode *= 31;
        Boolean theInterleaved = this.isInterleaved();
        if (this.interleaved != null) {
            currentHashCode += theInterleaved.hashCode();
        }
        currentHashCode *= 31;
        String theMimeType = this.getMimeType();
        if (this.mimeType != null) {
            currentHashCode += theMimeType.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BandOrdering {
        BAND_MAJOR("BandMajor"),
        COLOR_MAJOR("ColorMajor");

        private final String value;

        private BandOrdering(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BandOrdering fromValue(String v) {
            for (BandOrdering c : BandOrdering.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

