/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.ByteMap;
import org.cip4.lib.xjdf.schema.EnumAutomation;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.MetadataMap;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.IntegerList;
import org.cip4.lib.xjdf.type.Rectangle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="RunList", propOrder={"byteMap", "fileSpec", "metadataMap"})
public class RunList
extends SpecificResource
implements Serializable {
    @XmlElement(name="ByteMap")
    protected ByteMap byteMap;
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlElement(name="MetadataMap")
    protected List<MetadataMap> metadataMap;
    @XmlAttribute(name="Automation")
    protected EnumAutomation automation;
    @XmlAttribute(name="ClipPath")
    protected String clipPath;
    @XmlAttribute(name="ContentRefs")
    @XmlIDREF
    @XmlSchemaType(name="IDREFS")
    protected List<Resource> contents;
    @XmlAttribute(name="Docs")
    @XmlJavaTypeAdapter(value=IntegerList.class)
    protected IntegerList docs;
    @XmlAttribute(name="DocPages")
    @XmlJavaTypeAdapter(value=IntegerList.class)
    protected IntegerList docPages;
    @XmlAttribute(name="EndOfDocument")
    protected Boolean endOfDocument;
    @XmlAttribute(name="EndOfSet")
    protected Boolean endOfSet;
    @XmlAttribute(name="FinishedPages")
    protected Integer finishedPages;
    @XmlAttribute(name="LogicalPage")
    protected Integer logicalPage;
    @XmlAttribute(name="NPage")
    protected Integer nPage;
    @XmlAttribute(name="OrdType")
    protected OrdType ordType;
    @XmlAttribute(name="Pages")
    @XmlJavaTypeAdapter(value=IntegerList.class)
    protected IntegerList pages;
    @XmlAttribute(name="Sets")
    @XmlJavaTypeAdapter(value=IntegerList.class)
    protected IntegerList sets;
    @XmlAttribute(name="SourceBleedBox")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle sourceBleedBox;
    @XmlAttribute(name="SourceClipBox")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle sourceClipBox;
    @XmlAttribute(name="SourceMediaBox")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle sourceMediaBox;
    @XmlAttribute(name="SourceTrimBox")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle sourceTrimBox;

    public ByteMap getByteMap() {
        return this.byteMap;
    }

    public void setByteMap(ByteMap value) {
        this.byteMap = value;
    }

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public List<MetadataMap> getMetadataMap() {
        if (this.metadataMap == null) {
            this.metadataMap = new ArrayList<MetadataMap>();
        }
        return this.metadataMap;
    }

    public EnumAutomation getAutomation() {
        return this.automation;
    }

    public void setAutomation(EnumAutomation value) {
        this.automation = value;
    }

    public String getClipPath() {
        return this.clipPath;
    }

    public void setClipPath(String value) {
        this.clipPath = value;
    }

    public List<Resource> getContents() {
        if (this.contents == null) {
            this.contents = new ArrayList<Resource>();
        }
        return this.contents;
    }

    public IntegerList getDocs() {
        return this.docs;
    }

    public void setDocs(IntegerList value) {
        this.docs = value;
    }

    public IntegerList getDocPages() {
        return this.docPages;
    }

    public void setDocPages(IntegerList value) {
        this.docPages = value;
    }

    public Boolean isEndOfDocument() {
        return this.endOfDocument;
    }

    public void setEndOfDocument(Boolean value) {
        this.endOfDocument = value;
    }

    public Boolean isEndOfSet() {
        return this.endOfSet;
    }

    public void setEndOfSet(Boolean value) {
        this.endOfSet = value;
    }

    public Integer getFinishedPages() {
        return this.finishedPages;
    }

    public void setFinishedPages(Integer value) {
        this.finishedPages = value;
    }

    public Integer getLogicalPage() {
        return this.logicalPage;
    }

    public void setLogicalPage(Integer value) {
        this.logicalPage = value;
    }

    public Integer getNPage() {
        return this.nPage;
    }

    public void setNPage(Integer value) {
        this.nPage = value;
    }

    public OrdType getOrdType() {
        return this.ordType;
    }

    public void setOrdType(OrdType value) {
        this.ordType = value;
    }

    public IntegerList getPages() {
        return this.pages;
    }

    public void setPages(IntegerList value) {
        this.pages = value;
    }

    public IntegerList getSets() {
        return this.sets;
    }

    public void setSets(IntegerList value) {
        this.sets = value;
    }

    public Rectangle getSourceBleedBox() {
        return this.sourceBleedBox;
    }

    public void setSourceBleedBox(Rectangle value) {
        this.sourceBleedBox = value;
    }

    public Rectangle getSourceClipBox() {
        return this.sourceClipBox;
    }

    public void setSourceClipBox(Rectangle value) {
        this.sourceClipBox = value;
    }

    public Rectangle getSourceMediaBox() {
        return this.sourceMediaBox;
    }

    public void setSourceMediaBox(Rectangle value) {
        this.sourceMediaBox = value;
    }

    public Rectangle getSourceTrimBox() {
        return this.sourceTrimBox;
    }

    public void setSourceTrimBox(Rectangle value) {
        this.sourceTrimBox = value;
    }

    public RunList withByteMap(ByteMap value) {
        this.setByteMap(value);
        return this;
    }

    public RunList withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public RunList withMetadataMap(MetadataMap ... values) {
        if (values != null) {
            for (MetadataMap value : values) {
                this.getMetadataMap().add(value);
            }
        }
        return this;
    }

    public RunList withMetadataMap(Collection<MetadataMap> values) {
        if (values != null) {
            this.getMetadataMap().addAll(values);
        }
        return this;
    }

    public RunList withAutomation(EnumAutomation value) {
        this.setAutomation(value);
        return this;
    }

    public RunList withClipPath(String value) {
        this.setClipPath(value);
        return this;
    }

    public RunList withContents(Resource ... values) {
        if (values != null) {
            for (Resource value : values) {
                this.getContents().add(value);
            }
        }
        return this;
    }

    public RunList withContents(Collection<Resource> values) {
        if (values != null) {
            this.getContents().addAll(values);
        }
        return this;
    }

    public RunList withDocs(IntegerList value) {
        this.setDocs(value);
        return this;
    }

    public RunList withDocPages(IntegerList value) {
        this.setDocPages(value);
        return this;
    }

    public RunList withEndOfDocument(Boolean value) {
        this.setEndOfDocument(value);
        return this;
    }

    public RunList withEndOfSet(Boolean value) {
        this.setEndOfSet(value);
        return this;
    }

    public RunList withFinishedPages(Integer value) {
        this.setFinishedPages(value);
        return this;
    }

    public RunList withLogicalPage(Integer value) {
        this.setLogicalPage(value);
        return this;
    }

    public RunList withNPage(Integer value) {
        this.setNPage(value);
        return this;
    }

    public RunList withOrdType(OrdType value) {
        this.setOrdType(value);
        return this;
    }

    public RunList withPages(IntegerList value) {
        this.setPages(value);
        return this;
    }

    public RunList withSets(IntegerList value) {
        this.setSets(value);
        return this;
    }

    public RunList withSourceBleedBox(Rectangle value) {
        this.setSourceBleedBox(value);
        return this;
    }

    public RunList withSourceClipBox(Rectangle value) {
        this.setSourceClipBox(value);
        return this;
    }

    public RunList withSourceMediaBox(Rectangle value) {
        this.setSourceMediaBox(value);
        return this;
    }

    public RunList withSourceTrimBox(Rectangle value) {
        this.setSourceTrimBox(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Resource> rightContents;
        List<MetadataMap> rightMetadataMap;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        RunList that = (RunList)object;
        ByteMap leftByteMap = this.getByteMap();
        ByteMap rightByteMap = that.getByteMap();
        if (this.byteMap != null) {
            if (that.byteMap == null) return false;
            if (!leftByteMap.equals(rightByteMap)) {
                return false;
            }
        } else if (that.byteMap != null) {
            return false;
        }
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        List<MetadataMap> leftMetadataMap = this.metadataMap != null && !this.metadataMap.isEmpty() ? this.getMetadataMap() : null;
        List<MetadataMap> list = rightMetadataMap = that.metadataMap != null && !that.metadataMap.isEmpty() ? that.getMetadataMap() : null;
        if (this.metadataMap != null && !this.metadataMap.isEmpty()) {
            if (that.metadataMap == null || that.metadataMap.isEmpty()) return false;
            if (!leftMetadataMap.equals(rightMetadataMap)) {
                return false;
            }
        } else if (that.metadataMap != null && !that.metadataMap.isEmpty()) {
            return false;
        }
        EnumAutomation leftAutomation = this.getAutomation();
        EnumAutomation rightAutomation = that.getAutomation();
        if (this.automation != null) {
            if (that.automation == null) return false;
            if (!leftAutomation.equals((Object)rightAutomation)) {
                return false;
            }
        } else if (that.automation != null) {
            return false;
        }
        String leftClipPath = this.getClipPath();
        String rightClipPath = that.getClipPath();
        if (this.clipPath != null) {
            if (that.clipPath == null) return false;
            if (!leftClipPath.equals(rightClipPath)) {
                return false;
            }
        } else if (that.clipPath != null) {
            return false;
        }
        List<Resource> leftContents = this.contents != null && !this.contents.isEmpty() ? this.getContents() : null;
        List<Resource> list2 = rightContents = that.contents != null && !that.contents.isEmpty() ? that.getContents() : null;
        if (this.contents != null && !this.contents.isEmpty()) {
            if (that.contents == null || that.contents.isEmpty()) return false;
            if (!leftContents.equals(rightContents)) {
                return false;
            }
        } else if (that.contents != null && !that.contents.isEmpty()) {
            return false;
        }
        IntegerList leftDocs = this.getDocs();
        IntegerList rightDocs = that.getDocs();
        if (this.docs != null) {
            if (that.docs == null) return false;
            if (!leftDocs.equals((Object)rightDocs)) {
                return false;
            }
        } else if (that.docs != null) {
            return false;
        }
        IntegerList leftDocPages = this.getDocPages();
        IntegerList rightDocPages = that.getDocPages();
        if (this.docPages != null) {
            if (that.docPages == null) return false;
            if (!leftDocPages.equals((Object)rightDocPages)) {
                return false;
            }
        } else if (that.docPages != null) {
            return false;
        }
        Boolean leftEndOfDocument = this.isEndOfDocument();
        Boolean rightEndOfDocument = that.isEndOfDocument();
        if (this.endOfDocument != null) {
            if (that.endOfDocument == null) return false;
            if (!leftEndOfDocument.equals(rightEndOfDocument)) {
                return false;
            }
        } else if (that.endOfDocument != null) {
            return false;
        }
        Boolean leftEndOfSet = this.isEndOfSet();
        Boolean rightEndOfSet = that.isEndOfSet();
        if (this.endOfSet != null) {
            if (that.endOfSet == null) return false;
            if (!leftEndOfSet.equals(rightEndOfSet)) {
                return false;
            }
        } else if (that.endOfSet != null) {
            return false;
        }
        Integer leftFinishedPages = this.getFinishedPages();
        Integer rightFinishedPages = that.getFinishedPages();
        if (this.finishedPages != null) {
            if (that.finishedPages == null) return false;
            if (!leftFinishedPages.equals(rightFinishedPages)) {
                return false;
            }
        } else if (that.finishedPages != null) {
            return false;
        }
        Integer leftLogicalPage = this.getLogicalPage();
        Integer rightLogicalPage = that.getLogicalPage();
        if (this.logicalPage != null) {
            if (that.logicalPage == null) return false;
            if (!leftLogicalPage.equals(rightLogicalPage)) {
                return false;
            }
        } else if (that.logicalPage != null) {
            return false;
        }
        Integer leftNPage = this.getNPage();
        Integer rightNPage = that.getNPage();
        if (this.nPage != null) {
            if (that.nPage == null) return false;
            if (!leftNPage.equals(rightNPage)) {
                return false;
            }
        } else if (that.nPage != null) {
            return false;
        }
        OrdType leftOrdType = this.getOrdType();
        OrdType rightOrdType = that.getOrdType();
        if (this.ordType != null) {
            if (that.ordType == null) return false;
            if (!leftOrdType.equals((Object)rightOrdType)) {
                return false;
            }
        } else if (that.ordType != null) {
            return false;
        }
        IntegerList leftPages = this.getPages();
        IntegerList rightPages = that.getPages();
        if (this.pages != null) {
            if (that.pages == null) return false;
            if (!leftPages.equals((Object)rightPages)) {
                return false;
            }
        } else if (that.pages != null) {
            return false;
        }
        IntegerList leftSets = this.getSets();
        IntegerList rightSets = that.getSets();
        if (this.sets != null) {
            if (that.sets == null) return false;
            if (!leftSets.equals((Object)rightSets)) {
                return false;
            }
        } else if (that.sets != null) {
            return false;
        }
        Rectangle leftSourceBleedBox = this.getSourceBleedBox();
        Rectangle rightSourceBleedBox = that.getSourceBleedBox();
        if (this.sourceBleedBox != null) {
            if (that.sourceBleedBox == null) return false;
            if (!leftSourceBleedBox.equals((Object)rightSourceBleedBox)) {
                return false;
            }
        } else if (that.sourceBleedBox != null) {
            return false;
        }
        Rectangle leftSourceClipBox = this.getSourceClipBox();
        Rectangle rightSourceClipBox = that.getSourceClipBox();
        if (this.sourceClipBox != null) {
            if (that.sourceClipBox == null) return false;
            if (!leftSourceClipBox.equals((Object)rightSourceClipBox)) {
                return false;
            }
        } else if (that.sourceClipBox != null) {
            return false;
        }
        Rectangle leftSourceMediaBox = this.getSourceMediaBox();
        Rectangle rightSourceMediaBox = that.getSourceMediaBox();
        if (this.sourceMediaBox != null) {
            if (that.sourceMediaBox == null) return false;
            if (!leftSourceMediaBox.equals((Object)rightSourceMediaBox)) {
                return false;
            }
        } else if (that.sourceMediaBox != null) {
            return false;
        }
        Rectangle leftSourceTrimBox = this.getSourceTrimBox();
        Rectangle rightSourceTrimBox = that.getSourceTrimBox();
        if (this.sourceTrimBox != null) {
            if (that.sourceTrimBox == null) return false;
            if (leftSourceTrimBox.equals((Object)rightSourceTrimBox)) return true;
            return false;
        }
        if (that.sourceTrimBox == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Resource> theContents;
        List<MetadataMap> theMetadataMap;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        ByteMap theByteMap = this.getByteMap();
        if (this.byteMap != null) {
            currentHashCode += theByteMap.hashCode();
        }
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        List<MetadataMap> list = theMetadataMap = this.metadataMap != null && !this.metadataMap.isEmpty() ? this.getMetadataMap() : null;
        if (this.metadataMap != null && !this.metadataMap.isEmpty()) {
            currentHashCode += theMetadataMap.hashCode();
        }
        currentHashCode *= 31;
        EnumAutomation theAutomation = this.getAutomation();
        if (this.automation != null) {
            currentHashCode += theAutomation.hashCode();
        }
        currentHashCode *= 31;
        String theClipPath = this.getClipPath();
        if (this.clipPath != null) {
            currentHashCode += theClipPath.hashCode();
        }
        currentHashCode *= 31;
        List<Resource> list2 = theContents = this.contents != null && !this.contents.isEmpty() ? this.getContents() : null;
        if (this.contents != null && !this.contents.isEmpty()) {
            currentHashCode += theContents.hashCode();
        }
        currentHashCode *= 31;
        IntegerList theDocs = this.getDocs();
        if (this.docs != null) {
            currentHashCode += theDocs.hashCode();
        }
        currentHashCode *= 31;
        IntegerList theDocPages = this.getDocPages();
        if (this.docPages != null) {
            currentHashCode += theDocPages.hashCode();
        }
        currentHashCode *= 31;
        Boolean theEndOfDocument = this.isEndOfDocument();
        if (this.endOfDocument != null) {
            currentHashCode += theEndOfDocument.hashCode();
        }
        currentHashCode *= 31;
        Boolean theEndOfSet = this.isEndOfSet();
        if (this.endOfSet != null) {
            currentHashCode += theEndOfSet.hashCode();
        }
        currentHashCode *= 31;
        Integer theFinishedPages = this.getFinishedPages();
        if (this.finishedPages != null) {
            currentHashCode += theFinishedPages.hashCode();
        }
        currentHashCode *= 31;
        Integer theLogicalPage = this.getLogicalPage();
        if (this.logicalPage != null) {
            currentHashCode += theLogicalPage.hashCode();
        }
        currentHashCode *= 31;
        Integer theNPage = this.getNPage();
        if (this.nPage != null) {
            currentHashCode += theNPage.hashCode();
        }
        currentHashCode *= 31;
        OrdType theOrdType = this.getOrdType();
        if (this.ordType != null) {
            currentHashCode += theOrdType.hashCode();
        }
        currentHashCode *= 31;
        IntegerList thePages = this.getPages();
        if (this.pages != null) {
            currentHashCode += thePages.hashCode();
        }
        currentHashCode *= 31;
        IntegerList theSets = this.getSets();
        if (this.sets != null) {
            currentHashCode += theSets.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theSourceBleedBox = this.getSourceBleedBox();
        if (this.sourceBleedBox != null) {
            currentHashCode += theSourceBleedBox.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theSourceClipBox = this.getSourceClipBox();
        if (this.sourceClipBox != null) {
            currentHashCode += theSourceClipBox.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theSourceMediaBox = this.getSourceMediaBox();
        if (this.sourceMediaBox != null) {
            currentHashCode += theSourceMediaBox.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theSourceTrimBox = this.getSourceTrimBox();
        if (this.sourceTrimBox != null) {
            currentHashCode += theSourceTrimBox.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum OrdType {
        CONTENT("Content"),
        INSERT("Insert"),
        RESERVATION("Reservation");

        private final String value;

        private OrdType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static OrdType fromValue(String v) {
            for (OrdType c : OrdType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

