/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="StrappingParams")
public class StrappingParams
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="StrappingType", required=true)
    protected StrappingType strappingType;
    @XmlAttribute(name="StrapPositions")
    protected List<Float> strapPositions;

    public StrappingType getStrappingType() {
        return this.strappingType;
    }

    public void setStrappingType(StrappingType value) {
        this.strappingType = value;
    }

    public List<Float> getStrapPositions() {
        if (this.strapPositions == null) {
            this.strapPositions = new ArrayList<Float>();
        }
        return this.strapPositions;
    }

    public StrappingParams withStrappingType(StrappingType value) {
        this.setStrappingType(value);
        return this;
    }

    public StrappingParams withStrapPositions(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getStrapPositions().add(value);
            }
        }
        return this;
    }

    public StrappingParams withStrapPositions(Collection<Float> values) {
        if (values != null) {
            this.getStrapPositions().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightStrapPositions;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        StrappingParams that = (StrappingParams)object;
        StrappingType leftStrappingType = this.getStrappingType();
        StrappingType rightStrappingType = that.getStrappingType();
        if (this.strappingType != null) {
            if (that.strappingType == null) return false;
            if (!leftStrappingType.equals((Object)rightStrappingType)) {
                return false;
            }
        } else if (that.strappingType != null) {
            return false;
        }
        List<Float> leftStrapPositions = this.strapPositions != null && !this.strapPositions.isEmpty() ? this.getStrapPositions() : null;
        List<Float> list = rightStrapPositions = that.strapPositions != null && !that.strapPositions.isEmpty() ? that.getStrapPositions() : null;
        if (this.strapPositions != null && !this.strapPositions.isEmpty()) {
            if (that.strapPositions == null || that.strapPositions.isEmpty()) return false;
            if (leftStrapPositions.equals(rightStrapPositions)) return true;
            return false;
        }
        if (that.strapPositions == null || that.strapPositions.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theStrapPositions;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        StrappingType theStrappingType = this.getStrappingType();
        if (this.strappingType != null) {
            currentHashCode += theStrappingType.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theStrapPositions = this.strapPositions != null && !this.strapPositions.isEmpty() ? this.getStrapPositions() : null;
        if (this.strapPositions != null && !this.strapPositions.isEmpty()) {
            currentHashCode += theStrapPositions.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum StrappingType {
        SINGLE("Single"),
        DOUBLE("Double"),
        CROSS("Cross"),
        DOUBLE_CROSS("DoubleCross");

        private final String value;

        private StrappingType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static StrappingType fromValue(String v) {
            for (StrappingType c : StrappingType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

