/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="ThreadSewingParams")
public class ThreadSewingParams
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="BlindStitch")
    protected Boolean blindStitch;
    @XmlAttribute(name="NeedlePositions")
    protected List<Float> needlePositions;
    @XmlAttribute(name="NumberOfNeedles")
    protected Integer numberOfNeedles;
    @XmlAttribute(name="Offset")
    protected Float offset;
    @XmlAttribute(name="SewingPattern")
    protected SewingPattern sewingPattern;
    @XmlAttribute(name="ThreadThickness")
    protected Float threadThickness;

    public Boolean isBlindStitch() {
        return this.blindStitch;
    }

    public void setBlindStitch(Boolean value) {
        this.blindStitch = value;
    }

    public List<Float> getNeedlePositions() {
        if (this.needlePositions == null) {
            this.needlePositions = new ArrayList<Float>();
        }
        return this.needlePositions;
    }

    public Integer getNumberOfNeedles() {
        return this.numberOfNeedles;
    }

    public void setNumberOfNeedles(Integer value) {
        this.numberOfNeedles = value;
    }

    public Float getOffset() {
        return this.offset;
    }

    public void setOffset(Float value) {
        this.offset = value;
    }

    public SewingPattern getSewingPattern() {
        return this.sewingPattern;
    }

    public void setSewingPattern(SewingPattern value) {
        this.sewingPattern = value;
    }

    public Float getThreadThickness() {
        return this.threadThickness;
    }

    public void setThreadThickness(Float value) {
        this.threadThickness = value;
    }

    public ThreadSewingParams withBlindStitch(Boolean value) {
        this.setBlindStitch(value);
        return this;
    }

    public ThreadSewingParams withNeedlePositions(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getNeedlePositions().add(value);
            }
        }
        return this;
    }

    public ThreadSewingParams withNeedlePositions(Collection<Float> values) {
        if (values != null) {
            this.getNeedlePositions().addAll(values);
        }
        return this;
    }

    public ThreadSewingParams withNumberOfNeedles(Integer value) {
        this.setNumberOfNeedles(value);
        return this;
    }

    public ThreadSewingParams withOffset(Float value) {
        this.setOffset(value);
        return this;
    }

    public ThreadSewingParams withSewingPattern(SewingPattern value) {
        this.setSewingPattern(value);
        return this;
    }

    public ThreadSewingParams withThreadThickness(Float value) {
        this.setThreadThickness(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightNeedlePositions;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        ThreadSewingParams that = (ThreadSewingParams)object;
        Boolean leftBlindStitch = this.isBlindStitch();
        Boolean rightBlindStitch = that.isBlindStitch();
        if (this.blindStitch != null) {
            if (that.blindStitch == null) return false;
            if (!leftBlindStitch.equals(rightBlindStitch)) {
                return false;
            }
        } else if (that.blindStitch != null) {
            return false;
        }
        List<Float> leftNeedlePositions = this.needlePositions != null && !this.needlePositions.isEmpty() ? this.getNeedlePositions() : null;
        List<Float> list = rightNeedlePositions = that.needlePositions != null && !that.needlePositions.isEmpty() ? that.getNeedlePositions() : null;
        if (this.needlePositions != null && !this.needlePositions.isEmpty()) {
            if (that.needlePositions == null || that.needlePositions.isEmpty()) return false;
            if (!leftNeedlePositions.equals(rightNeedlePositions)) {
                return false;
            }
        } else if (that.needlePositions != null && !that.needlePositions.isEmpty()) {
            return false;
        }
        Integer leftNumberOfNeedles = this.getNumberOfNeedles();
        Integer rightNumberOfNeedles = that.getNumberOfNeedles();
        if (this.numberOfNeedles != null) {
            if (that.numberOfNeedles == null) return false;
            if (!leftNumberOfNeedles.equals(rightNumberOfNeedles)) {
                return false;
            }
        } else if (that.numberOfNeedles != null) {
            return false;
        }
        Float leftOffset = this.getOffset();
        Float rightOffset = that.getOffset();
        if (this.offset != null) {
            if (that.offset == null) return false;
            if (!leftOffset.equals(rightOffset)) {
                return false;
            }
        } else if (that.offset != null) {
            return false;
        }
        SewingPattern leftSewingPattern = this.getSewingPattern();
        SewingPattern rightSewingPattern = that.getSewingPattern();
        if (this.sewingPattern != null) {
            if (that.sewingPattern == null) return false;
            if (!leftSewingPattern.equals((Object)rightSewingPattern)) {
                return false;
            }
        } else if (that.sewingPattern != null) {
            return false;
        }
        Float leftThreadThickness = this.getThreadThickness();
        Float rightThreadThickness = that.getThreadThickness();
        if (this.threadThickness != null) {
            if (that.threadThickness == null) return false;
            if (leftThreadThickness.equals(rightThreadThickness)) return true;
            return false;
        }
        if (that.threadThickness == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theNeedlePositions;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        Boolean theBlindStitch = this.isBlindStitch();
        if (this.blindStitch != null) {
            currentHashCode += theBlindStitch.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theNeedlePositions = this.needlePositions != null && !this.needlePositions.isEmpty() ? this.getNeedlePositions() : null;
        if (this.needlePositions != null && !this.needlePositions.isEmpty()) {
            currentHashCode += theNeedlePositions.hashCode();
        }
        currentHashCode *= 31;
        Integer theNumberOfNeedles = this.getNumberOfNeedles();
        if (this.numberOfNeedles != null) {
            currentHashCode += theNumberOfNeedles.hashCode();
        }
        currentHashCode *= 31;
        Float theOffset = this.getOffset();
        if (this.offset != null) {
            currentHashCode += theOffset.hashCode();
        }
        currentHashCode *= 31;
        SewingPattern theSewingPattern = this.getSewingPattern();
        if (this.sewingPattern != null) {
            currentHashCode += theSewingPattern.hashCode();
        }
        currentHashCode *= 31;
        Float theThreadThickness = this.getThreadThickness();
        if (this.threadThickness != null) {
            currentHashCode += theThreadThickness.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum SewingPattern {
        COMBINED_STAGGERED("CombinedStaggered"),
        NORMAL("Normal"),
        SIDE("Side"),
        STAGGERED("Staggered");

        private final String value;

        private SewingPattern(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static SewingPattern fromValue(String v) {
            for (SewingPattern c : SewingPattern.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

