/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="UsageCounter")
public class UsageCounter
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="CounterTypes")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> counterTypes;
    @XmlAttribute(name="Scope", required=true)
    protected Scope scope;

    public List<String> getCounterTypes() {
        if (this.counterTypes == null) {
            this.counterTypes = new ArrayList<String>();
        }
        return this.counterTypes;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope value) {
        this.scope = value;
    }

    public UsageCounter withCounterTypes(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getCounterTypes().add(value);
            }
        }
        return this;
    }

    public UsageCounter withCounterTypes(Collection<String> values) {
        if (values != null) {
            this.getCounterTypes().addAll(values);
        }
        return this;
    }

    public UsageCounter withScope(Scope value) {
        this.setScope(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightCounterTypes;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        UsageCounter that = (UsageCounter)object;
        List<String> leftCounterTypes = this.counterTypes != null && !this.counterTypes.isEmpty() ? this.getCounterTypes() : null;
        List<String> list = rightCounterTypes = that.counterTypes != null && !that.counterTypes.isEmpty() ? that.getCounterTypes() : null;
        if (this.counterTypes != null && !this.counterTypes.isEmpty()) {
            if (that.counterTypes == null || that.counterTypes.isEmpty()) return false;
            if (!leftCounterTypes.equals(rightCounterTypes)) {
                return false;
            }
        } else if (that.counterTypes != null && !that.counterTypes.isEmpty()) {
            return false;
        }
        Scope leftScope = this.getScope();
        Scope rightScope = that.getScope();
        if (this.scope != null) {
            if (that.scope == null) return false;
            if (leftScope.equals((Object)rightScope)) return true;
            return false;
        }
        if (that.scope == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theCounterTypes;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<String> list = theCounterTypes = this.counterTypes != null && !this.counterTypes.isEmpty() ? this.getCounterTypes() : null;
        if (this.counterTypes != null && !this.counterTypes.isEmpty()) {
            currentHashCode += theCounterTypes.hashCode();
        }
        currentHashCode *= 31;
        Scope theScope = this.getScope();
        if (this.scope != null) {
            currentHashCode += theScope.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Scope {
        LIFETIME("Lifetime"),
        POWER_ON("PowerOn"),
        JOB("Job");

        private final String value;

        private Scope(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Scope fromValue(String v) {
            for (Scope c : Scope.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

