/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.exception.XJdfInitException;
import org.cip4.lib.xjdf.exception.XJdfParseException;
import org.cip4.lib.xjdf.exception.XJdfValidationException;
import org.cip4.lib.xjdf.partition.PartitionManager;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditCreated;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ProductList;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.util.Headers;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.jetbrains.annotations.NotNull;

public class XJdfDocument {
    private final XJdfParser<XJDF> xjdfParser;
    private final XJdfValidator xJdfValidator;
    private final XJDF xjdf;

    public XJdfDocument() throws XJdfInitException {
        this(new XJDF());
    }

    public XJdfDocument(String jobId, String ... types) throws XJdfInitException {
        this(new XJDF().withJobID(jobId).withTypes(types));
    }

    public XJdfDocument(byte[] bytes) throws XJdfInitException, XJdfParseException {
        this((XJDF)new XJdfParser().readXml(bytes));
    }

    public XJdfDocument(XJDF xjdf) throws XJdfInitException {
        this.xjdf = xjdf;
        this.xjdfParser = new XJdfParser();
        this.xJdfValidator = new XJdfValidator();
        if (xjdf.getVersion() == null) {
            xjdf.setVersion(XJdfConstants.XJDF_CURRENT_VERSION);
        }
        if (xjdf.getAuditPool() == null) {
            xjdf.setAuditPool(new AuditPool().withAudits(new AuditCreated().withHeader(Headers.createDefaultHeader())));
        }
    }

    public XJDF getXJdf() {
        return this.xjdf;
    }

    public byte[] toXml() throws XJdfParseException, XJdfValidationException {
        return this.toXml(true);
    }

    public byte[] toXml(boolean validate) throws XJdfParseException, XJdfValidationException {
        byte[] xml = this.xjdfParser.writeXml(this.xjdf);
        if (validate) {
            this.xJdfValidator.validate(xml);
        }
        return xml;
    }

    public void addAudits(Audit ... audits) {
        if (this.xjdf.getAuditPool() == null) {
            this.xjdf.setAuditPool(new AuditPool());
        }
        this.xjdf.getAuditPool().withAudits(audits);
    }

    public void addProduct(Product ... products) {
        if (this.xjdf.getProductList() == null) {
            this.xjdf.setProductList(new ProductList());
        }
        this.xjdf.getProductList().withProduct(products);
    }

    public ResourceSet addResourceSet(@NotNull SpecificResource specificResource, ResourceSet.Usage usage) {
        String paramName = specificResource.getClass().getSimpleName();
        QName qname = new QName("http://www.CIP4.org/JDFSchema_2_0", paramName);
        JAXBElement specificResourceJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)specificResource);
        Resource resource = new Resource();
        resource.setSpecificResource((JAXBElement<? extends SpecificResource>)specificResourceJaxB);
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.getResource().add(resource);
        resourceSet.setName(paramName);
        resourceSet.setUsage(usage);
        this.xjdf.getResourceSet().add(resourceSet);
        return resourceSet;
    }

    public ResourceSet addResourceSet(@NotNull SpecificResource specificResource, ResourceSet.Usage usage, Part part) throws IOException {
        if (part == null) {
            return this.addResourceSet(specificResource, usage);
        }
        HashMap<Part, SpecificResource> map = new HashMap<Part, SpecificResource>();
        map.put(part, specificResource);
        return this.addResourceSet(map, usage);
    }

    public ResourceSet addResourceSet(Map<Part, ? extends SpecificResource> map, ResourceSet.Usage usage) throws IOException {
        if (map.size() == 0) {
            throw new IOException("The resource map requries at leaset one entry.");
        }
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.setUsage(usage);
        for (Part part : map.keySet()) {
            String paramName = map.get(part).getClass().getSimpleName();
            QName qname = new QName("http://www.CIP4.org/JDFSchema_2_0", paramName);
            JAXBElement specificResourceJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)map.get(part));
            Resource resource = new Resource();
            resource.getPart().add(part);
            resource.setSpecificResource((JAXBElement<? extends SpecificResource>)specificResourceJaxB);
            resourceSet.getResource().add(resource);
            resourceSet.setName(paramName);
        }
        this.xjdf.getResourceSet().add(resourceSet);
        return resourceSet;
    }

    public Resource getResourceByPart(Class<? extends SpecificResource> resourceType, Part part) throws IllegalAccessException {
        List<ResourceSet> resourceSets = this.xjdf.getResourceSet();
        Resource result = null;
        for (int i = 0; i < resourceSets.size() && result == null; ++i) {
            ResourceSet resourceSet = resourceSets.get(i);
            if (!resourceType.getSimpleName().equals(resourceSet.getName())) continue;
            result = PartitionManager.getResourceByPart(resourceSet, part);
        }
        return result;
    }

    public Resource getResourceByPart(Class<? extends SpecificResource> resourceType) throws IllegalAccessException {
        return this.getResourceByPart(resourceType, null);
    }

    public <T extends SpecificResource> T getSpecificResourceByPart(Class<T> resourceType, Part part) throws IllegalAccessException {
        Resource resource = this.getResourceByPart(resourceType, part);
        return (T)((SpecificResource)resource.getSpecificResource().getValue());
    }

    public <T extends SpecificResource> T getSpecificResourceByPart(Class<T> resourceType) throws IllegalAccessException {
        return this.getSpecificResourceByPart(resourceType, null);
    }
}

