/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.partition;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;

public class PartitionManager {
    public static Resource getResourceByPart(ResourceSet resourceSet, Part part) throws IllegalAccessException {
        for (Resource resource : resourceSet.getResource()) {
            if (resource.getPart().size() == 0) {
                return resource;
            }
            for (Part resPart : resource.getPart()) {
                Set<String> resourceKeys;
                Set<String> givenKeys = PartitionManager.getPartitionKeys(part);
                if (!givenKeys.containsAll(resourceKeys = PartitionManager.getPartitionKeys(resPart))) continue;
                boolean isSelected = true;
                for (String resourceKey : resourceKeys) {
                    if (!isSelected) continue;
                    isSelected = PartitionManager.comparePartKeyValues(resourceKey, resPart, part);
                }
                if (!isSelected) continue;
                return resource;
            }
        }
        return null;
    }

    private static boolean comparePartKeyValues(String fieldName, Part resourcePart, Part givenPart) throws IllegalAccessException {
        Object resValue = FieldUtils.readField((Object)resourcePart, (String)fieldName, (boolean)true);
        Object givenValue = FieldUtils.readField((Object)givenPart, (String)fieldName, (boolean)true);
        return resValue.equals(givenValue);
    }

    private static Set<String> getPartitionKeys(Part part) throws IllegalAccessException {
        HashSet<String> partKeys = new HashSet<String>();
        if (part != null) {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(Part.class)) {
                if (FieldUtils.readField((Field)field, (Object)part, (boolean)true) == null) continue;
                partKeys.add(field.getName());
            }
        }
        return partKeys;
    }
}

