/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.Comment;
import org.cip4.lib.xjdf.schema.Face;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.type.Rectangle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"comment", "fileSpec"})
@XmlRootElement(name="Defect")
public class Defect
implements Serializable {
    @XmlElement(name="Comment")
    protected Comment comment;
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlAttribute(name="Box")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle box;
    @XmlAttribute(name="DefectReason")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String defectReason;
    @XmlAttribute(name="DefectType", required=true)
    protected List<DefectType> defectType;
    @XmlAttribute(name="DefectTypeDetails")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String defectTypeDetails;
    @XmlAttribute(name="Face")
    protected Face face;
    @XmlAttribute(name="Severity")
    protected Integer severity;
    @XmlAttribute(name="Size")
    protected Float size;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Comment getComment() {
        return this.comment;
    }

    public void setComment(Comment value) {
        this.comment = value;
    }

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle value) {
        this.box = value;
    }

    public String getDefectReason() {
        return this.defectReason;
    }

    public void setDefectReason(String value) {
        this.defectReason = value;
    }

    public List<DefectType> getDefectType() {
        if (this.defectType == null) {
            this.defectType = new ArrayList<DefectType>();
        }
        return this.defectType;
    }

    public String getDefectTypeDetails() {
        return this.defectTypeDetails;
    }

    public void setDefectTypeDetails(String value) {
        this.defectTypeDetails = value;
    }

    public Face getFace() {
        return this.face;
    }

    public void setFace(Face value) {
        this.face = value;
    }

    public Integer getSeverity() {
        return this.severity;
    }

    public void setSeverity(Integer value) {
        this.severity = value;
    }

    public Float getSize() {
        return this.size;
    }

    public void setSize(Float value) {
        this.size = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Defect withComment(Comment value) {
        this.setComment(value);
        return this;
    }

    public Defect withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public Defect withBox(Rectangle value) {
        this.setBox(value);
        return this;
    }

    public Defect withDefectReason(String value) {
        this.setDefectReason(value);
        return this;
    }

    public Defect withDefectType(DefectType ... values) {
        if (values != null) {
            for (DefectType value : values) {
                this.getDefectType().add(value);
            }
        }
        return this;
    }

    public Defect withDefectType(Collection<DefectType> values) {
        if (values != null) {
            this.getDefectType().addAll(values);
        }
        return this;
    }

    public Defect withDefectTypeDetails(String value) {
        this.setDefectTypeDetails(value);
        return this;
    }

    public Defect withFace(Face value) {
        this.setFace(value);
        return this;
    }

    public Defect withSeverity(Integer value) {
        this.setSeverity(value);
        return this;
    }

    public Defect withSize(Float value) {
        this.setSize(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<DefectType> rightDefectType;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Defect that = (Defect)object;
        Comment leftComment = this.getComment();
        Comment rightComment = that.getComment();
        if (this.comment != null) {
            if (that.comment == null) return false;
            if (!leftComment.equals(rightComment)) {
                return false;
            }
        } else if (that.comment != null) {
            return false;
        }
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        Rectangle leftBox = this.getBox();
        Rectangle rightBox = that.getBox();
        if (this.box != null) {
            if (that.box == null) return false;
            if (!leftBox.equals((Object)rightBox)) {
                return false;
            }
        } else if (that.box != null) {
            return false;
        }
        String leftDefectReason = this.getDefectReason();
        String rightDefectReason = that.getDefectReason();
        if (this.defectReason != null) {
            if (that.defectReason == null) return false;
            if (!leftDefectReason.equals(rightDefectReason)) {
                return false;
            }
        } else if (that.defectReason != null) {
            return false;
        }
        List<DefectType> leftDefectType = this.defectType != null && !this.defectType.isEmpty() ? this.getDefectType() : null;
        List<DefectType> list = rightDefectType = that.defectType != null && !that.defectType.isEmpty() ? that.getDefectType() : null;
        if (this.defectType != null && !this.defectType.isEmpty()) {
            if (that.defectType == null || that.defectType.isEmpty()) return false;
            if (!leftDefectType.equals(rightDefectType)) {
                return false;
            }
        } else if (that.defectType != null && !that.defectType.isEmpty()) {
            return false;
        }
        String leftDefectTypeDetails = this.getDefectTypeDetails();
        String rightDefectTypeDetails = that.getDefectTypeDetails();
        if (this.defectTypeDetails != null) {
            if (that.defectTypeDetails == null) return false;
            if (!leftDefectTypeDetails.equals(rightDefectTypeDetails)) {
                return false;
            }
        } else if (that.defectTypeDetails != null) {
            return false;
        }
        Face leftFace = this.getFace();
        Face rightFace = that.getFace();
        if (this.face != null) {
            if (that.face == null) return false;
            if (!leftFace.equals((Object)rightFace)) {
                return false;
            }
        } else if (that.face != null) {
            return false;
        }
        Integer leftSeverity = this.getSeverity();
        Integer rightSeverity = that.getSeverity();
        if (this.severity != null) {
            if (that.severity == null) return false;
            if (!leftSeverity.equals(rightSeverity)) {
                return false;
            }
        } else if (that.severity != null) {
            return false;
        }
        Float leftSize = this.getSize();
        Float rightSize = that.getSize();
        if (this.size != null) {
            if (that.size == null) return false;
            if (leftSize.equals(rightSize)) return true;
            return false;
        }
        if (that.size == null) return true;
        return false;
    }

    public int hashCode() {
        List<DefectType> theDefectType;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Comment theComment = this.getComment();
        if (this.comment != null) {
            currentHashCode += theComment.hashCode();
        }
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theBox = this.getBox();
        if (this.box != null) {
            currentHashCode += theBox.hashCode();
        }
        currentHashCode *= 31;
        String theDefectReason = this.getDefectReason();
        if (this.defectReason != null) {
            currentHashCode += theDefectReason.hashCode();
        }
        currentHashCode *= 31;
        List<DefectType> list = theDefectType = this.defectType != null && !this.defectType.isEmpty() ? this.getDefectType() : null;
        if (this.defectType != null && !this.defectType.isEmpty()) {
            currentHashCode += theDefectType.hashCode();
        }
        currentHashCode *= 31;
        String theDefectTypeDetails = this.getDefectTypeDetails();
        if (this.defectTypeDetails != null) {
            currentHashCode += theDefectTypeDetails.hashCode();
        }
        currentHashCode *= 31;
        Face theFace = this.getFace();
        if (this.face != null) {
            currentHashCode += theFace.hashCode();
        }
        currentHashCode *= 31;
        Integer theSeverity = this.getSeverity();
        if (this.severity != null) {
            currentHashCode += theSeverity.hashCode();
        }
        currentHashCode *= 31;
        Float theSize = this.getSize();
        if (this.size != null) {
            currentHashCode += theSize.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum DefectType {
        FINISHING_DEFECT("FinishingDefect"),
        IMAGE_DEFECT("ImageDefect"),
        IMAGE_FINISHING_DEFECT("ImageFinishingDefect"),
        OTHER("Other"),
        SHEET_DEFECT("SheetDefect"),
        SUBSTRATE_DEFECT("SubstrateDefect");

        private final String value;

        private DefectType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static DefectType fromValue(String v) {
            for (DefectType c : DefectType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

