/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.type.IntegerList;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="TIFFtag")
public class TIFFtag
implements Serializable {
    @XmlAttribute(name="BinaryValue")
    @XmlJavaTypeAdapter(value=HexBinaryAdapter.class)
    @XmlSchemaType(name="hexBinary")
    protected byte[] binaryValue;
    @XmlAttribute(name="IntegerValue")
    @XmlJavaTypeAdapter(value=IntegerList.class)
    protected IntegerList integerValue;
    @XmlAttribute(name="NumberValue")
    protected List<Float> numberValue;
    @XmlAttribute(name="StringValue")
    protected String stringValue;
    @XmlAttribute(name="TagNumber", required=true)
    protected int tagNumber;
    @XmlAttribute(name="TagType", required=true)
    protected int tagType;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public byte[] getBinaryValue() {
        return this.binaryValue;
    }

    public void setBinaryValue(byte[] value) {
        this.binaryValue = value;
    }

    public IntegerList getIntegerValue() {
        return this.integerValue;
    }

    public void setIntegerValue(IntegerList value) {
        this.integerValue = value;
    }

    public List<Float> getNumberValue() {
        if (this.numberValue == null) {
            this.numberValue = new ArrayList<Float>();
        }
        return this.numberValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public void setStringValue(String value) {
        this.stringValue = value;
    }

    public int getTagNumber() {
        return this.tagNumber;
    }

    public void setTagNumber(int value) {
        this.tagNumber = value;
    }

    public int getTagType() {
        return this.tagType;
    }

    public void setTagType(int value) {
        this.tagType = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public TIFFtag withBinaryValue(byte[] value) {
        this.setBinaryValue(value);
        return this;
    }

    public TIFFtag withIntegerValue(IntegerList value) {
        this.setIntegerValue(value);
        return this;
    }

    public TIFFtag withNumberValue(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getNumberValue().add(value);
            }
        }
        return this;
    }

    public TIFFtag withNumberValue(Collection<Float> values) {
        if (values != null) {
            this.getNumberValue().addAll(values);
        }
        return this;
    }

    public TIFFtag withStringValue(String value) {
        this.setStringValue(value);
        return this;
    }

    public TIFFtag withTagNumber(int value) {
        this.setTagNumber(value);
        return this;
    }

    public TIFFtag withTagType(int value) {
        this.setTagType(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        int rightTagNumber;
        int leftTagNumber;
        List<Float> rightNumberValue;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        TIFFtag that = (TIFFtag)object;
        byte[] leftBinaryValue = this.getBinaryValue();
        byte[] rightBinaryValue = that.getBinaryValue();
        if (this.binaryValue != null) {
            if (that.binaryValue == null) return false;
            if (!Arrays.equals(leftBinaryValue, rightBinaryValue)) {
                return false;
            }
        } else if (that.binaryValue != null) {
            return false;
        }
        IntegerList leftIntegerValue = this.getIntegerValue();
        IntegerList rightIntegerValue = that.getIntegerValue();
        if (this.integerValue != null) {
            if (that.integerValue == null) return false;
            if (!leftIntegerValue.equals((Object)rightIntegerValue)) {
                return false;
            }
        } else if (that.integerValue != null) {
            return false;
        }
        List<Float> leftNumberValue = this.numberValue != null && !this.numberValue.isEmpty() ? this.getNumberValue() : null;
        List<Float> list = rightNumberValue = that.numberValue != null && !that.numberValue.isEmpty() ? that.getNumberValue() : null;
        if (this.numberValue != null && !this.numberValue.isEmpty()) {
            if (that.numberValue == null || that.numberValue.isEmpty()) return false;
            if (!leftNumberValue.equals(rightNumberValue)) {
                return false;
            }
        } else if (that.numberValue != null && !that.numberValue.isEmpty()) {
            return false;
        }
        String leftStringValue = this.getStringValue();
        String rightStringValue = that.getStringValue();
        if (this.stringValue != null) {
            if (that.stringValue == null) return false;
            if (!leftStringValue.equals(rightStringValue)) {
                return false;
            }
        } else if (that.stringValue != null) {
            return false;
        }
        if ((leftTagNumber = this.getTagNumber()) == (rightTagNumber = that.getTagNumber())) int rightTagType;
        int leftTagType;
        return (leftTagType = this.getTagType()) == (rightTagType = that.getTagType());
        return false;
    }

    public int hashCode() {
        List<Float> theNumberValue;
        int currentHashCode = 1;
        currentHashCode *= 31;
        byte[] theBinaryValue = this.getBinaryValue();
        currentHashCode += Arrays.hashCode(theBinaryValue);
        currentHashCode *= 31;
        IntegerList theIntegerValue = this.getIntegerValue();
        if (this.integerValue != null) {
            currentHashCode += theIntegerValue.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theNumberValue = this.numberValue != null && !this.numberValue.isEmpty() ? this.getNumberValue() : null;
        if (this.numberValue != null && !this.numberValue.isEmpty()) {
            currentHashCode += theNumberValue.hashCode();
        }
        currentHashCode *= 31;
        String theStringValue = this.getStringValue();
        if (this.stringValue != null) {
            currentHashCode += theStringValue.hashCode();
        }
        currentHashCode *= 31;
        int theTagNumber = this.getTagNumber();
        currentHashCode += theTagNumber;
        currentHashCode *= 31;
        int theTagType = this.getTagType();
        return currentHashCode += theTagType;
    }
}

