/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.Locale;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class Matrix
extends AbstractXJdfType<String, Matrix> {
    private final float a;
    private final float b;
    private final float c;
    private final float d;
    private final float tx;
    private final float ty;

    public Matrix() {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 1.0f;
        this.tx = 0.0f;
        this.ty = 0.0f;
    }

    public Matrix(float a, float b, float c, float d, float tx, float ty) {
        this.a = a;
        this.b = b;
        this.c = c;
        this.d = d;
        this.tx = tx;
        this.ty = ty;
    }

    public Matrix(float tx, float ty) {
        this.a = 1.0f;
        this.b = 0.0f;
        this.c = 0.0f;
        this.d = 1.0f;
        this.tx = tx;
        this.ty = ty;
    }

    public Matrix(String expression) {
        String[] s = expression.split(" ");
        this.a = Float.parseFloat(s[0]);
        this.b = Float.parseFloat(s[1]);
        this.c = Float.parseFloat(s[2]);
        this.d = Float.parseFloat(s[3]);
        this.tx = Float.parseFloat(s[4]);
        this.ty = Float.parseFloat(s[5]);
    }

    public float getA() {
        return this.a;
    }

    public float getB() {
        return this.b;
    }

    public float getC() {
        return this.c;
    }

    public float getD() {
        return this.d;
    }

    public float getTx() {
        return this.tx;
    }

    public float getTy() {
        return this.ty;
    }

    public String marshal(Matrix matrix) {
        if (matrix == null) {
            return null;
        }
        float a = matrix.getA();
        float b = matrix.getB();
        float c = matrix.getC();
        float d = matrix.getD();
        float tx = matrix.getTx();
        float ty = matrix.getTy();
        return String.format(Locale.US, "%.3f %.3f %.3f %.3f %.3f %.3f", Float.valueOf(a), Float.valueOf(b), Float.valueOf(c), Float.valueOf(d), Float.valueOf(tx), Float.valueOf(ty));
    }

    public Matrix unmarshal(String v) {
        return new Matrix(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

