/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.Locale;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class Shape
extends AbstractXJdfType<String, Shape> {
    private final float x;
    private final float y;
    private final float z;

    public Shape() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
    }

    public Shape(float x, float y) {
        this.x = x;
        this.y = y;
        this.z = 0.0f;
    }

    public Shape(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Shape(String expression) {
        String[] s = expression.split(" ");
        this.x = s.length >= 1 ? Float.parseFloat(s[0]) : 0.0f;
        this.y = s.length >= 2 ? Float.parseFloat(s[1]) : 0.0f;
        this.z = s.length >= 3 ? Float.parseFloat(s[2]) : 0.0f;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public String marshal(Shape shape) {
        if (shape == null) {
            return null;
        }
        double x = shape.getX();
        double y = shape.getY();
        double z = shape.getZ();
        return String.format(Locale.US, "%.3f %.3f %.3f", x, y, z);
    }

    public Shape unmarshal(String v) {
        return new Shape(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

