/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.xml;

import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.Unmarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.cip4.lib.xjdf.exception.XJdfInitException;
import org.cip4.lib.xjdf.exception.XJdfParseException;
import org.cip4.lib.xjdf.xml.XJdfConstants;
import org.cip4.lib.xjdf.xml.internal.JAXBContextFactory;
import org.glassfish.jaxb.runtime.marshaller.NamespacePrefixMapper;

public class XJdfParser<T> {
    private final JAXBContext jaxbContext = JAXBContextFactory.getInstance();
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    public final T readXml(byte[] bytes) throws XJdfParseException {
        if (bytes == null) {
            throw new XJdfParseException("Cannot read an XML byte array of null.");
        }
        return this.readXml(new ByteArrayInputStream(bytes));
    }

    public final T readXml(InputStream inputStream) throws XJdfParseException {
        try {
            Unmarshaller u = this.jaxbContext.createUnmarshaller();
            return (T)u.unmarshal(inputStream);
        }
        catch (JAXBException jaxbException) {
            throw new XJdfParseException(jaxbException);
        }
    }

    public final byte[] writeXml(T node) throws XJdfParseException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            this.writeXml(node, bos);
            bos.close();
            return bos.toByteArray();
        }
        catch (Exception exception) {
            throw new XJdfParseException(exception);
        }
    }

    public final void writeXml(T node, OutputStream outputStream) throws XJdfParseException {
        try {
            Marshaller m = this.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)true);
            m.setProperty("jaxb.encoding", (Object)CHARSET.name());
            m.setProperty("org.glassfish.jaxb.xmlHeaders", (Object)this.getXmlHeader());
            OutputStreamWriter writer = new OutputStreamWriter(outputStream, CHARSET);
            m.marshal(node, (Writer)writer);
        }
        catch (Exception exception) {
            throw new XJdfParseException(exception);
        }
    }

    private String getXmlHeader() {
        Object header = "<!-- Generated by CIP4 xJdfLib " + XJdfConstants.XJDFLIB_VERSION + " -->\r\n";
        header = ((String)header).replaceAll("  ", " ");
        return header;
    }

    Marshaller createMarshaller() throws XJdfParseException {
        Marshaller m;
        try {
            m = this.jaxbContext.createMarshaller();
            m.setProperty("org.glassfish.jaxb.namespacePrefixMapper", (Object)new XJdfNamespacePrefixMapper());
        }
        catch (JAXBException jaxbException) {
            throw new XJdfParseException(jaxbException);
        }
        return m;
    }

    static class XJdfNamespacePrefixMapper
    extends NamespacePrefixMapper {
        public String getPreferredPrefix(String namespaceUri, String suggestion, boolean requirePrefix) {
            String result = requirePrefix ? (namespaceUri.equals("http://www.CIP4.org/JDFSchema_2_0") ? "xjdf" : suggestion) : "";
            return result;
        }
    }
}

