
package org.cip4.lib.xjdf.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jakarta.annotation.Generated;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;


/**
 * <p>Java class for Color complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>{@code
 * <complexType name="Color">
 *   <complexContent>
 *     <extension base="{http://www.CIP4.org/JDFSchema_2_0}SpecificResource">
 *       <sequence>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}ColorMeasurementConditions" minOccurs="0"/>
 *         <element ref="{http://www.CIP4.org/JDFSchema_2_0}DeviceNColor" maxOccurs="unbounded" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="ActualColorName" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="CMYK" type="{http://www.CIP4.org/JDFSchema_2_0}CMYKColor" />
 *       <attribute name="ColorBook" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="ColorBookEntry" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="ColorDetails" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="ColorName" type="{http://www.CIP4.org/JDFSchema_2_0}NamedColor" />
 *       <attribute name="ColorType">
 *         <simpleType>
 *           <restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
 *             <enumeration value="DieLine"/>
 *             <enumeration value="Normal"/>
 *             <enumeration value="Opaque"/>
 *             <enumeration value="OpaqueIgnore"/>
 *             <enumeration value="Primer"/>
 *             <enumeration value="Transparent"/>
 *           </restriction>
 *         </simpleType>
 *       </attribute>
 *       <attribute name="ColorTypeDetails" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="Density" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       <attribute name="Gray" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       <attribute name="Lab" type="{http://www.CIP4.org/JDFSchema_2_0}LabColor" />
 *       <attribute name="NeutralDensity" type="{http://www.w3.org/2001/XMLSchema}float" />
 *       <attribute name="PrintingTechnology" type="{http://www.w3.org/2001/XMLSchema}NMTOKEN" />
 *       <attribute name="PrintStandard" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="RawName" type="{http://www.w3.org/2001/XMLSchema}hexBinary" />
 *       <attribute name="Spectrum" type="{http://www.CIP4.org/JDFSchema_2_0}TransferFunction" />
 *       <attribute name="sRGB" type="{http://www.CIP4.org/JDFSchema_2_0}sRGBColor" />
 *       <anyAttribute processContents='lax' namespace='##other'/>
 *     </extension>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "Color", propOrder = {
    "colorMeasurementConditions",
    "deviceNColor"
})
@Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
@XmlRootElement(name = "Color")
public class Color
    extends SpecificResource
    implements Serializable
{

    @XmlElement(name = "ColorMeasurementConditions")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected ColorMeasurementConditions colorMeasurementConditions;
    @XmlElement(name = "DeviceNColor")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected List<DeviceNColor> deviceNColor;
    @XmlAttribute(name = "ActualColorName")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String actualColorName;
    @XmlAttribute(name = "CMYK")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected List<Float> cmyk;
    @XmlAttribute(name = "ColorBook")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String colorBook;
    @XmlAttribute(name = "ColorBookEntry")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String colorBookEntry;
    @XmlAttribute(name = "ColorDetails")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String colorDetails;
    @XmlAttribute(name = "ColorName")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String colorName;
    @XmlAttribute(name = "ColorType")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected Color.ColorType colorType;
    @XmlAttribute(name = "ColorTypeDetails")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String colorTypeDetails;
    @XmlAttribute(name = "Density")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected Float density;
    @XmlAttribute(name = "Gray")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected Float gray;
    @XmlAttribute(name = "Lab")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected List<Float> lab;
    @XmlAttribute(name = "NeutralDensity")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected Float neutralDensity;
    @XmlAttribute(name = "PrintingTechnology")
    @XmlJavaTypeAdapter(CollapsedStringAdapter.class)
    @XmlSchemaType(name = "NMTOKEN")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String printingTechnology;
    @XmlAttribute(name = "PrintStandard")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected String printStandard;
    @XmlAttribute(name = "RawName")
    @XmlJavaTypeAdapter(HexBinaryAdapter.class)
    @XmlSchemaType(name = "hexBinary")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected byte[] rawName;
    @XmlAttribute(name = "Spectrum")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected List<Float> spectrum;
    @XmlAttribute(name = "sRGB")
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    protected List<Float> srgb;

    /**
     * Gets the value of the colorMeasurementConditions property.
     * 
     * @return
     *     possible object is
     *     {@link ColorMeasurementConditions }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public ColorMeasurementConditions getColorMeasurementConditions() {
        return colorMeasurementConditions;
    }

    /**
     * Sets the value of the colorMeasurementConditions property.
     * 
     * @param value
     *     allowed object is
     *     {@link ColorMeasurementConditions }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorMeasurementConditions(ColorMeasurementConditions value) {
        this.colorMeasurementConditions = value;
    }

    /**
     * Gets the value of the deviceNColor property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the deviceNColor property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDeviceNColor().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link DeviceNColor }
     * 
     * 
     * @return
     *     The value of the deviceNColor property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public List<DeviceNColor> getDeviceNColor() {
        if (deviceNColor == null) {
            deviceNColor = new ArrayList<>();
        }
        return this.deviceNColor;
    }

    /**
     * Gets the value of the actualColorName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getActualColorName() {
        return actualColorName;
    }

    /**
     * Sets the value of the actualColorName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setActualColorName(String value) {
        this.actualColorName = value;
    }

    /**
     * Gets the value of the cmyk property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the cmyk property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getCMYK().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Float }
     * 
     * 
     * @return
     *     The value of the cmyk property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public List<Float> getCMYK() {
        if (cmyk == null) {
            cmyk = new ArrayList<>();
        }
        return this.cmyk;
    }

    /**
     * Gets the value of the colorBook property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getColorBook() {
        return colorBook;
    }

    /**
     * Sets the value of the colorBook property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorBook(String value) {
        this.colorBook = value;
    }

    /**
     * Gets the value of the colorBookEntry property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getColorBookEntry() {
        return colorBookEntry;
    }

    /**
     * Sets the value of the colorBookEntry property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorBookEntry(String value) {
        this.colorBookEntry = value;
    }

    /**
     * Gets the value of the colorDetails property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getColorDetails() {
        return colorDetails;
    }

    /**
     * Sets the value of the colorDetails property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorDetails(String value) {
        this.colorDetails = value;
    }

    /**
     * Gets the value of the colorName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getColorName() {
        return colorName;
    }

    /**
     * Sets the value of the colorName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorName(String value) {
        this.colorName = value;
    }

    /**
     * Gets the value of the colorType property.
     * 
     * @return
     *     possible object is
     *     {@link Color.ColorType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public Color.ColorType getColorType() {
        return colorType;
    }

    /**
     * Sets the value of the colorType property.
     * 
     * @param value
     *     allowed object is
     *     {@link Color.ColorType }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorType(Color.ColorType value) {
        this.colorType = value;
    }

    /**
     * Gets the value of the colorTypeDetails property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getColorTypeDetails() {
        return colorTypeDetails;
    }

    /**
     * Sets the value of the colorTypeDetails property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setColorTypeDetails(String value) {
        this.colorTypeDetails = value;
    }

    /**
     * Gets the value of the density property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public Float getDensity() {
        return density;
    }

    /**
     * Sets the value of the density property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setDensity(Float value) {
        this.density = value;
    }

    /**
     * Gets the value of the gray property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public Float getGray() {
        return gray;
    }

    /**
     * Sets the value of the gray property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setGray(Float value) {
        this.gray = value;
    }

    /**
     * Gets the value of the lab property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the lab property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getLab().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Float }
     * 
     * 
     * @return
     *     The value of the lab property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public List<Float> getLab() {
        if (lab == null) {
            lab = new ArrayList<>();
        }
        return this.lab;
    }

    /**
     * Gets the value of the neutralDensity property.
     * 
     * @return
     *     possible object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public Float getNeutralDensity() {
        return neutralDensity;
    }

    /**
     * Sets the value of the neutralDensity property.
     * 
     * @param value
     *     allowed object is
     *     {@link Float }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setNeutralDensity(Float value) {
        this.neutralDensity = value;
    }

    /**
     * Gets the value of the printingTechnology property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getPrintingTechnology() {
        return printingTechnology;
    }

    /**
     * Sets the value of the printingTechnology property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setPrintingTechnology(String value) {
        this.printingTechnology = value;
    }

    /**
     * Gets the value of the printStandard property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public String getPrintStandard() {
        return printStandard;
    }

    /**
     * Sets the value of the printStandard property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setPrintStandard(String value) {
        this.printStandard = value;
    }

    /**
     * Gets the value of the rawName property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public byte[] getRawName() {
        return rawName;
    }

    /**
     * Sets the value of the rawName property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public void setRawName(byte[] value) {
        this.rawName = value;
    }

    /**
     * Gets the value of the spectrum property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the spectrum property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSpectrum().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Float }
     * 
     * 
     * @return
     *     The value of the spectrum property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public List<Float> getSpectrum() {
        if (spectrum == null) {
            spectrum = new ArrayList<>();
        }
        return this.spectrum;
    }

    /**
     * Gets the value of the srgb property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the Jakarta XML Binding object.
     * This is why there is not a {@code set} method for the srgb property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSRGB().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Float }
     * 
     * 
     * @return
     *     The value of the srgb property.
     */
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public List<Float> getSRGB() {
        if (srgb == null) {
            srgb = new ArrayList<>();
        }
        return this.srgb;
    }

    public Color withColorMeasurementConditions(ColorMeasurementConditions value) {
        setColorMeasurementConditions(value);
        return this;
    }

    public Color withDeviceNColor(DeviceNColor... values) {
        if (values!= null) {
            for (DeviceNColor value: values) {
                getDeviceNColor().add(value);
            }
        }
        return this;
    }

    public Color withDeviceNColor(Collection<DeviceNColor> values) {
        if (values!= null) {
            getDeviceNColor().addAll(values);
        }
        return this;
    }

    public Color withActualColorName(String value) {
        setActualColorName(value);
        return this;
    }

    public Color withCMYK(Float... values) {
        if (values!= null) {
            for (Float value: values) {
                getCMYK().add(value);
            }
        }
        return this;
    }

    public Color withCMYK(Collection<Float> values) {
        if (values!= null) {
            getCMYK().addAll(values);
        }
        return this;
    }

    public Color withColorBook(String value) {
        setColorBook(value);
        return this;
    }

    public Color withColorBookEntry(String value) {
        setColorBookEntry(value);
        return this;
    }

    public Color withColorDetails(String value) {
        setColorDetails(value);
        return this;
    }

    public Color withColorName(String value) {
        setColorName(value);
        return this;
    }

    public Color withColorType(Color.ColorType value) {
        setColorType(value);
        return this;
    }

    public Color withColorTypeDetails(String value) {
        setColorTypeDetails(value);
        return this;
    }

    public Color withDensity(Float value) {
        setDensity(value);
        return this;
    }

    public Color withGray(Float value) {
        setGray(value);
        return this;
    }

    public Color withLab(Float... values) {
        if (values!= null) {
            for (Float value: values) {
                getLab().add(value);
            }
        }
        return this;
    }

    public Color withLab(Collection<Float> values) {
        if (values!= null) {
            getLab().addAll(values);
        }
        return this;
    }

    public Color withNeutralDensity(Float value) {
        setNeutralDensity(value);
        return this;
    }

    public Color withPrintingTechnology(String value) {
        setPrintingTechnology(value);
        return this;
    }

    public Color withPrintStandard(String value) {
        setPrintStandard(value);
        return this;
    }

    public Color withRawName(byte[] value) {
        setRawName(value);
        return this;
    }

    public Color withSpectrum(Float... values) {
        if (values!= null) {
            for (Float value: values) {
                getSpectrum().add(value);
            }
        }
        return this;
    }

    public Color withSpectrum(Collection<Float> values) {
        if (values!= null) {
            getSpectrum().addAll(values);
        }
        return this;
    }

    public Color withSRGB(Float... values) {
        if (values!= null) {
            for (Float value: values) {
                getSRGB().add(value);
            }
        }
        return this;
    }

    public Color withSRGB(Collection<Float> values) {
        if (values!= null) {
            getSRGB().addAll(values);
        }
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if ((object == null)||(this.getClass()!= object.getClass())) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        final Color that = ((Color) object);
        {
            ColorMeasurementConditions leftColorMeasurementConditions;
            leftColorMeasurementConditions = this.getColorMeasurementConditions();
            ColorMeasurementConditions rightColorMeasurementConditions;
            rightColorMeasurementConditions = that.getColorMeasurementConditions();
            if (this.colorMeasurementConditions!= null) {
                if (that.colorMeasurementConditions!= null) {
                    if (!leftColorMeasurementConditions.equals(rightColorMeasurementConditions)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorMeasurementConditions!= null) {
                    return false;
                }
            }
        }
        {
            List<DeviceNColor> leftDeviceNColor;
            leftDeviceNColor = (((this.deviceNColor!= null)&&(!this.deviceNColor.isEmpty()))?this.getDeviceNColor():null);
            List<DeviceNColor> rightDeviceNColor;
            rightDeviceNColor = (((that.deviceNColor!= null)&&(!that.deviceNColor.isEmpty()))?that.getDeviceNColor():null);
            if ((this.deviceNColor!= null)&&(!this.deviceNColor.isEmpty())) {
                if ((that.deviceNColor!= null)&&(!that.deviceNColor.isEmpty())) {
                    if (!leftDeviceNColor.equals(rightDeviceNColor)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.deviceNColor!= null)&&(!that.deviceNColor.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftActualColorName;
            leftActualColorName = this.getActualColorName();
            String rightActualColorName;
            rightActualColorName = that.getActualColorName();
            if (this.actualColorName!= null) {
                if (that.actualColorName!= null) {
                    if (!leftActualColorName.equals(rightActualColorName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.actualColorName!= null) {
                    return false;
                }
            }
        }
        {
            List<Float> leftCMYK;
            leftCMYK = (((this.cmyk!= null)&&(!this.cmyk.isEmpty()))?this.getCMYK():null);
            List<Float> rightCMYK;
            rightCMYK = (((that.cmyk!= null)&&(!that.cmyk.isEmpty()))?that.getCMYK():null);
            if ((this.cmyk!= null)&&(!this.cmyk.isEmpty())) {
                if ((that.cmyk!= null)&&(!that.cmyk.isEmpty())) {
                    if (!leftCMYK.equals(rightCMYK)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.cmyk!= null)&&(!that.cmyk.isEmpty())) {
                    return false;
                }
            }
        }
        {
            String leftColorBook;
            leftColorBook = this.getColorBook();
            String rightColorBook;
            rightColorBook = that.getColorBook();
            if (this.colorBook!= null) {
                if (that.colorBook!= null) {
                    if (!leftColorBook.equals(rightColorBook)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorBook!= null) {
                    return false;
                }
            }
        }
        {
            String leftColorBookEntry;
            leftColorBookEntry = this.getColorBookEntry();
            String rightColorBookEntry;
            rightColorBookEntry = that.getColorBookEntry();
            if (this.colorBookEntry!= null) {
                if (that.colorBookEntry!= null) {
                    if (!leftColorBookEntry.equals(rightColorBookEntry)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorBookEntry!= null) {
                    return false;
                }
            }
        }
        {
            String leftColorDetails;
            leftColorDetails = this.getColorDetails();
            String rightColorDetails;
            rightColorDetails = that.getColorDetails();
            if (this.colorDetails!= null) {
                if (that.colorDetails!= null) {
                    if (!leftColorDetails.equals(rightColorDetails)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorDetails!= null) {
                    return false;
                }
            }
        }
        {
            String leftColorName;
            leftColorName = this.getColorName();
            String rightColorName;
            rightColorName = that.getColorName();
            if (this.colorName!= null) {
                if (that.colorName!= null) {
                    if (!leftColorName.equals(rightColorName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorName!= null) {
                    return false;
                }
            }
        }
        {
            Color.ColorType leftColorType;
            leftColorType = this.getColorType();
            Color.ColorType rightColorType;
            rightColorType = that.getColorType();
            if (this.colorType!= null) {
                if (that.colorType!= null) {
                    if (!leftColorType.equals(rightColorType)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorType!= null) {
                    return false;
                }
            }
        }
        {
            String leftColorTypeDetails;
            leftColorTypeDetails = this.getColorTypeDetails();
            String rightColorTypeDetails;
            rightColorTypeDetails = that.getColorTypeDetails();
            if (this.colorTypeDetails!= null) {
                if (that.colorTypeDetails!= null) {
                    if (!leftColorTypeDetails.equals(rightColorTypeDetails)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.colorTypeDetails!= null) {
                    return false;
                }
            }
        }
        {
            Float leftDensity;
            leftDensity = this.getDensity();
            Float rightDensity;
            rightDensity = that.getDensity();
            if (this.density!= null) {
                if (that.density!= null) {
                    if (!leftDensity.equals(rightDensity)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.density!= null) {
                    return false;
                }
            }
        }
        {
            Float leftGray;
            leftGray = this.getGray();
            Float rightGray;
            rightGray = that.getGray();
            if (this.gray!= null) {
                if (that.gray!= null) {
                    if (!leftGray.equals(rightGray)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.gray!= null) {
                    return false;
                }
            }
        }
        {
            List<Float> leftLab;
            leftLab = (((this.lab!= null)&&(!this.lab.isEmpty()))?this.getLab():null);
            List<Float> rightLab;
            rightLab = (((that.lab!= null)&&(!that.lab.isEmpty()))?that.getLab():null);
            if ((this.lab!= null)&&(!this.lab.isEmpty())) {
                if ((that.lab!= null)&&(!that.lab.isEmpty())) {
                    if (!leftLab.equals(rightLab)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.lab!= null)&&(!that.lab.isEmpty())) {
                    return false;
                }
            }
        }
        {
            Float leftNeutralDensity;
            leftNeutralDensity = this.getNeutralDensity();
            Float rightNeutralDensity;
            rightNeutralDensity = that.getNeutralDensity();
            if (this.neutralDensity!= null) {
                if (that.neutralDensity!= null) {
                    if (!leftNeutralDensity.equals(rightNeutralDensity)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.neutralDensity!= null) {
                    return false;
                }
            }
        }
        {
            String leftPrintingTechnology;
            leftPrintingTechnology = this.getPrintingTechnology();
            String rightPrintingTechnology;
            rightPrintingTechnology = that.getPrintingTechnology();
            if (this.printingTechnology!= null) {
                if (that.printingTechnology!= null) {
                    if (!leftPrintingTechnology.equals(rightPrintingTechnology)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.printingTechnology!= null) {
                    return false;
                }
            }
        }
        {
            String leftPrintStandard;
            leftPrintStandard = this.getPrintStandard();
            String rightPrintStandard;
            rightPrintStandard = that.getPrintStandard();
            if (this.printStandard!= null) {
                if (that.printStandard!= null) {
                    if (!leftPrintStandard.equals(rightPrintStandard)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.printStandard!= null) {
                    return false;
                }
            }
        }
        {
            byte[] leftRawName;
            leftRawName = this.getRawName();
            byte[] rightRawName;
            rightRawName = that.getRawName();
            if (this.rawName!= null) {
                if (that.rawName!= null) {
                    if (!Arrays.equals(leftRawName, rightRawName)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if (that.rawName!= null) {
                    return false;
                }
            }
        }
        {
            List<Float> leftSpectrum;
            leftSpectrum = (((this.spectrum!= null)&&(!this.spectrum.isEmpty()))?this.getSpectrum():null);
            List<Float> rightSpectrum;
            rightSpectrum = (((that.spectrum!= null)&&(!that.spectrum.isEmpty()))?that.getSpectrum():null);
            if ((this.spectrum!= null)&&(!this.spectrum.isEmpty())) {
                if ((that.spectrum!= null)&&(!that.spectrum.isEmpty())) {
                    if (!leftSpectrum.equals(rightSpectrum)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.spectrum!= null)&&(!that.spectrum.isEmpty())) {
                    return false;
                }
            }
        }
        {
            List<Float> leftSRGB;
            leftSRGB = (((this.srgb!= null)&&(!this.srgb.isEmpty()))?this.getSRGB():null);
            List<Float> rightSRGB;
            rightSRGB = (((that.srgb!= null)&&(!that.srgb.isEmpty()))?that.getSRGB():null);
            if ((this.srgb!= null)&&(!this.srgb.isEmpty())) {
                if ((that.srgb!= null)&&(!that.srgb.isEmpty())) {
                    if (!leftSRGB.equals(rightSRGB)) {
                        return false;
                    }
                } else {
                    return false;
                }
            } else {
                if ((that.srgb!= null)&&(!that.srgb.isEmpty())) {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int hashCode() {
        int currentHashCode = 1;
        currentHashCode = ((currentHashCode* 31)+ super.hashCode());
        {
            currentHashCode = (currentHashCode* 31);
            ColorMeasurementConditions theColorMeasurementConditions;
            theColorMeasurementConditions = this.getColorMeasurementConditions();
            if (this.colorMeasurementConditions!= null) {
                currentHashCode += theColorMeasurementConditions.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<DeviceNColor> theDeviceNColor;
            theDeviceNColor = (((this.deviceNColor!= null)&&(!this.deviceNColor.isEmpty()))?this.getDeviceNColor():null);
            if ((this.deviceNColor!= null)&&(!this.deviceNColor.isEmpty())) {
                currentHashCode += theDeviceNColor.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theActualColorName;
            theActualColorName = this.getActualColorName();
            if (this.actualColorName!= null) {
                currentHashCode += theActualColorName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Float> theCMYK;
            theCMYK = (((this.cmyk!= null)&&(!this.cmyk.isEmpty()))?this.getCMYK():null);
            if ((this.cmyk!= null)&&(!this.cmyk.isEmpty())) {
                currentHashCode += theCMYK.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theColorBook;
            theColorBook = this.getColorBook();
            if (this.colorBook!= null) {
                currentHashCode += theColorBook.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theColorBookEntry;
            theColorBookEntry = this.getColorBookEntry();
            if (this.colorBookEntry!= null) {
                currentHashCode += theColorBookEntry.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theColorDetails;
            theColorDetails = this.getColorDetails();
            if (this.colorDetails!= null) {
                currentHashCode += theColorDetails.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theColorName;
            theColorName = this.getColorName();
            if (this.colorName!= null) {
                currentHashCode += theColorName.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Color.ColorType theColorType;
            theColorType = this.getColorType();
            if (this.colorType!= null) {
                currentHashCode += theColorType.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String theColorTypeDetails;
            theColorTypeDetails = this.getColorTypeDetails();
            if (this.colorTypeDetails!= null) {
                currentHashCode += theColorTypeDetails.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Float theDensity;
            theDensity = this.getDensity();
            if (this.density!= null) {
                currentHashCode += theDensity.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Float theGray;
            theGray = this.getGray();
            if (this.gray!= null) {
                currentHashCode += theGray.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Float> theLab;
            theLab = (((this.lab!= null)&&(!this.lab.isEmpty()))?this.getLab():null);
            if ((this.lab!= null)&&(!this.lab.isEmpty())) {
                currentHashCode += theLab.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            Float theNeutralDensity;
            theNeutralDensity = this.getNeutralDensity();
            if (this.neutralDensity!= null) {
                currentHashCode += theNeutralDensity.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String thePrintingTechnology;
            thePrintingTechnology = this.getPrintingTechnology();
            if (this.printingTechnology!= null) {
                currentHashCode += thePrintingTechnology.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            String thePrintStandard;
            thePrintStandard = this.getPrintStandard();
            if (this.printStandard!= null) {
                currentHashCode += thePrintStandard.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            byte[] theRawName;
            theRawName = this.getRawName();
            currentHashCode += Arrays.hashCode(theRawName);
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Float> theSpectrum;
            theSpectrum = (((this.spectrum!= null)&&(!this.spectrum.isEmpty()))?this.getSpectrum():null);
            if ((this.spectrum!= null)&&(!this.spectrum.isEmpty())) {
                currentHashCode += theSpectrum.hashCode();
            }
        }
        {
            currentHashCode = (currentHashCode* 31);
            List<Float> theSRGB;
            theSRGB = (((this.srgb!= null)&&(!this.srgb.isEmpty()))?this.getSRGB():null);
            if ((this.srgb!= null)&&(!this.srgb.isEmpty())) {
                currentHashCode += theSRGB.hashCode();
            }
        }
        return currentHashCode;
    }


    /**
     * <p>Java class for null.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * <pre>{@code
     * <simpleType>
     *   <restriction base="{http://www.w3.org/2001/XMLSchema}NMTOKEN">
     *     <enumeration value="DieLine"/>
     *     <enumeration value="Normal"/>
     *     <enumeration value="Opaque"/>
     *     <enumeration value="OpaqueIgnore"/>
     *     <enumeration value="Primer"/>
     *     <enumeration value="Transparent"/>
     *   </restriction>
     * </simpleType>
     * }</pre>
     * 
     */
    @XmlType(name = "")
    @XmlEnum
    @Generated(value = "com.sun.tools.xjc.Driver", comments = "JAXB RI v4.0.2", date = "2023-07-17T18:40:39Z")
    public enum ColorType {

        @XmlEnumValue("DieLine")
        DIE_LINE("DieLine"),
        @XmlEnumValue("Normal")
        NORMAL("Normal"),
        @XmlEnumValue("Opaque")
        OPAQUE("Opaque"),
        @XmlEnumValue("OpaqueIgnore")
        OPAQUE_IGNORE("OpaqueIgnore"),
        @XmlEnumValue("Primer")
        PRIMER("Primer"),
        @XmlEnumValue("Transparent")
        TRANSPARENT("Transparent");
        private final String value;

        ColorType(String v) {
            value = v;
        }

        public String value() {
            return value;
        }

        public static Color.ColorType fromValue(String v) {
            for (Color.ColorType c: Color.ColorType.values()) {
                if (c.value.equals(v)) {
                    return c;
                }
            }
            throw new IllegalArgumentException(v);
        }

    }

}
