/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.cip4.lib.xjdf.FinalProduct;
import org.cip4.lib.xjdf.XJdfConstants;
import org.cip4.lib.xjdf.exception.XJdfDocumentException;
import org.cip4.lib.xjdf.exception.XJdfParseException;
import org.cip4.lib.xjdf.exception.XJdfValidationException;
import org.cip4.lib.xjdf.schema.Audit;
import org.cip4.lib.xjdf.schema.AuditCreated;
import org.cip4.lib.xjdf.schema.AuditPool;
import org.cip4.lib.xjdf.schema.GeneralID;
import org.cip4.lib.xjdf.schema.Header;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Product;
import org.cip4.lib.xjdf.schema.ProductList;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.schema.XJDF;
import org.cip4.lib.xjdf.type.IntegerList;
import org.cip4.lib.xjdf.util.Headers;
import org.cip4.lib.xjdf.util.Partitions;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.jetbrains.annotations.NotNull;

public class XJdfDocument {
    private final XJdfParser<XJDF> xjdfParser;
    private final XJdfValidator xJdfValidator;
    private final XJDF xjdf;

    public XJdfDocument() {
        this(new XJDF());
    }

    public XJdfDocument(String jobId, String ... types) {
        this(new XJDF().withJobID(jobId).withTypes(types));
    }

    public XJdfDocument(byte[] bytes) throws XJdfParseException {
        this((XJDF)new XJdfParser().readXml(bytes));
    }

    public XJdfDocument(XJDF xjdf) {
        this.xjdf = xjdf;
        this.xjdfParser = new XJdfParser();
        this.xJdfValidator = new XJdfValidator();
        if (xjdf.getVersion() == null) {
            xjdf.setVersion(XJdfConstants.XJDF_CURRENT_VERSION);
        }
        if (xjdf.getAuditPool() == null) {
            xjdf.setAuditPool(new AuditPool().withAudits(new AuditCreated().withHeader(Headers.createDefaultHeader())));
        }
    }

    public void setDescriptiveName(String descriptiveName) {
        this.getXJdf().setDescriptiveName(descriptiveName);
    }

    public String getDescriptiveName() {
        return this.getXJdf().getDescriptiveName();
    }

    public XJDF getXJdf() {
        return this.xjdf;
    }

    public byte[] toXml() throws XJdfParseException, XJdfValidationException {
        return this.toXml(true);
    }

    public byte[] toXml(boolean validate) throws XJdfParseException, XJdfValidationException {
        byte[] xml = this.xjdfParser.writeXml(this.xjdf);
        if (validate) {
            this.xJdfValidator.validate(xml);
        }
        return xml;
    }

    public String toString() {
        try {
            return new String(this.toXml(false));
        }
        catch (Exception e) {
            return "Error creating an XML preview.";
        }
    }

    public List<String> getCombinedProcess() {
        return Collections.unmodifiableList(this.xjdf.getTypes());
    }

    public int getCombinedProcessIndex(String processName) throws XJdfDocumentException {
        assert (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{processName})) : "ProcessName cannot be null or empty.";
        List matchingProcessNames = this.getCombinedProcess().stream().filter(entry -> StringUtils.equalsIgnoreCase((CharSequence)entry, (CharSequence)processName)).collect(Collectors.toList());
        if (matchingProcessNames.size() > 1) {
            throw new XJdfDocumentException("ProcessName '" + processName + "' is not unique.");
        }
        if (matchingProcessNames.size() == 0) {
            throw new XJdfDocumentException("ProcessName '" + processName + "' has not been found.");
        }
        return this.getCombinedProcess().indexOf(matchingProcessNames.get(0));
    }

    public void addGeneralID(GeneralID generalID) {
        this.addGeneralIDs(generalID);
    }

    public void addGeneralIDs(GeneralID ... generalIDs) {
        this.xjdf.getGeneralID().addAll(Arrays.asList(generalIDs));
        this.xjdf.getGeneralID().sort(Comparator.comparing(GeneralID::getIDUsage));
    }

    public GeneralID getGeneralID(String idUsage) {
        List generalIDs = this.xjdf.getGeneralID().stream().filter(generalID -> Objects.equals(generalID.getIDUsage(), idUsage)).collect(Collectors.toList());
        if (generalIDs.size() > 1) {
            throw new IllegalArgumentException("IDUsage '" + idUsage + "' is not unique.");
        }
        return generalIDs.size() == 0 ? null : (GeneralID)generalIDs.get(0);
    }

    public boolean removeGeneralID(String idUsage) {
        return this.removeGeneralID(this.getGeneralID(idUsage));
    }

    public boolean removeGeneralID(GeneralID generalID) {
        return this.xjdf.getGeneralID().remove(generalID);
    }

    public void addAudits(Audit ... audits) {
        if (this.xjdf.getAuditPool() == null) {
            this.xjdf.setAuditPool(new AuditPool());
        }
        this.xjdf.getAuditPool().withAudits(audits);
    }

    public Header getAuditCreated() {
        if (this.xjdf.getAuditPool() != null) {
            for (Audit audit : this.xjdf.getAuditPool().getAudits()) {
                if (!(audit instanceof AuditCreated)) continue;
                AuditCreated auditCreated = (AuditCreated)audit;
                return auditCreated.getHeader();
            }
        }
        return null;
    }

    public void addFinalProduct(FinalProduct ... finalProducts) {
        if (this.xjdf.getProductList() == null) {
            this.xjdf.setProductList(new ProductList());
        }
        for (FinalProduct finalProduct : finalProducts) {
            this.xjdf.getProductList().withProduct(finalProduct.getProductParts());
        }
    }

    public List<FinalProduct> getFinalProducts() {
        ArrayList<FinalProduct> finalProducts = new ArrayList<FinalProduct>();
        if (this.xjdf.getProductList() != null) {
            List<Product> productParts = this.xjdf.getProductList().getProduct();
            for (Product product : productParts) {
                if (!product.isIsRoot().booleanValue()) continue;
                finalProducts.add(new FinalProduct(product, productParts));
            }
        }
        return finalProducts;
    }

    public ResourceSet addResourceSet(@NotNull Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage) {
        return this.addResourceSet(resourceType, usage, null, (IntegerList)null);
    }

    public ResourceSet addResourceSet(@NotNull Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage) {
        return this.addResourceSet(resourceType, usage, processUsage, (IntegerList)null);
    }

    public ResourceSet addResourceSet(@NotNull Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, String processName) throws XJdfDocumentException {
        return this.addResourceSet(resourceType, usage, processUsage, new IntegerList(this.getCombinedProcessIndex(processName)));
    }

    public ResourceSet addResourceSet(@NotNull Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, IntegerList combinedProcessIndices) {
        ResourceSet resourceSet = new ResourceSet();
        resourceSet.setUsage(usage);
        resourceSet.setProcessUsage(processUsage);
        resourceSet.setCombinedProcessIndex(combinedProcessIndices);
        resourceSet.setName(resourceType.getSimpleName());
        this.xjdf.getResourceSet().add(resourceSet);
        Comparator usageComparator = (rs1, rs2) -> StringUtils.compare((String)(rs1.getUsage() == null ? null : rs1.getUsage().name()), rs2.getUsage() == null ? null : rs2.getUsage().name());
        Comparator combinedProcessIndexComparator = (rs1, rs2) -> StringUtils.compare((String)(rs1.getCombinedProcessIndex() == null ? null : rs1.getCombinedProcessIndex().toString()), rs2.getCombinedProcessIndex() == null ? null : rs2.getCombinedProcessIndex().toString());
        this.xjdf.getResourceSet().sort(usageComparator.thenComparing(ResourceSet::getName).thenComparing(combinedProcessIndexComparator));
        return resourceSet;
    }

    public boolean removeResourceSet(Class<? extends SpecificResource> resourceType) throws XJdfDocumentException {
        return this.removeResourceSet(this.getResourceSet(resourceType));
    }

    public boolean removeResourceSet(Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, String processName) throws XJdfDocumentException {
        return this.removeResourceSet(this.getResourceSet(resourceType, usage, processUsage, processName));
    }

    public boolean removeResourceSet(Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, IntegerList combinedProcessIndices) throws XJdfDocumentException {
        return this.removeResourceSet(this.getResourceSet(resourceType, usage, processUsage, combinedProcessIndices));
    }

    public boolean removeResourceSet(ResourceSet resourceSet) {
        return this.xjdf.getResourceSet().remove(resourceSet);
    }

    public Resource addSpecificResource(ResourceSet resourceSet, SpecificResource specificResource) throws XJdfDocumentException {
        return this.addSpecificResource(resourceSet, specificResource, List.of());
    }

    public Resource addSpecificResource(ResourceSet resourceSet, SpecificResource specificResource, Part part) throws XJdfDocumentException {
        return this.addSpecificResource(resourceSet, specificResource, List.of(part));
    }

    public Resource addSpecificResource(ResourceSet resourceSet, SpecificResource specificResource, List<Part> parts) {
        if (!Objects.equals(resourceSet.getName(), specificResource.getClass().getSimpleName())) {
            throw new IllegalArgumentException("Resource type does not match ResourceSet type.");
        }
        String paramName = specificResource.getClass().getSimpleName();
        QName qname = new QName("http://www.CIP4.org/JDFSchema_2_0", paramName);
        JAXBElement specificResourceJaxB = new JAXBElement(qname, SpecificResource.class, null, (Object)specificResource);
        Resource resource = new Resource();
        for (Part part : parts) {
            resource.getPart().add(part);
        }
        resource.setSpecificResource((JAXBElement<? extends SpecificResource>)specificResourceJaxB);
        resourceSet.getResource().add(resource);
        return resource;
    }

    public ResourceSet getResourceSet(Class<? extends SpecificResource> resourceType) throws XJdfDocumentException {
        return this.getResourceSet(resourceType, null, null, (IntegerList)null);
    }

    public ResourceSet getResourceSet(Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, String processName) throws XJdfDocumentException {
        return this.getResourceSet(resourceType, usage, processUsage, new IntegerList(this.getCombinedProcessIndex(processName)));
    }

    public ResourceSet getResourceSet(Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, IntegerList combinedProcessIndices) throws XJdfDocumentException {
        List resourceSets = this.xjdf.getResourceSet().stream().filter(resourceSet -> resourceType == null || Objects.equals(resourceSet.getName(), resourceType.getSimpleName())).filter(resourceSet -> usage == null || Objects.equals((Object)resourceSet.getUsage(), (Object)usage)).filter(resourceSet -> processUsage == null || Objects.equals(resourceSet.getProcessUsage(), processUsage)).filter(resourceSet -> combinedProcessIndices == null || Objects.equals((Object)resourceSet.getCombinedProcessIndex(), (Object)combinedProcessIndices)).collect(Collectors.toList());
        if (resourceSets.size() > 1) {
            throw new XJdfDocumentException("ResourceSet '" + resourceType.getSimpleName() + "' is ambiguous.");
        }
        ResourceSet resourceSet2 = resourceSets.size() == 1 ? (ResourceSet)resourceSets.get(0) : null;
        return resourceSet2;
    }

    public List<Part> getParts(Class<? extends SpecificResource> resourceType) throws XJdfDocumentException {
        return this.getParts(this.getResourceSet(resourceType, null, null, (IntegerList)null));
    }

    public List<Part> getParts(Class<? extends SpecificResource> resourceType, ResourceSet.Usage usage, String processUsage, String processName) throws XJdfDocumentException {
        return this.getParts(this.getResourceSet(resourceType, usage, processUsage, new IntegerList(this.getCombinedProcessIndex(processName))));
    }

    public List<Part> getParts(ResourceSet resourceSet) {
        ArrayList<Part> parts = new ArrayList<Part>();
        resourceSet.getResource().forEach(resource -> {
            if (resource.getPart().size() == 0) {
                parts.add(null);
            } else {
                parts.addAll(resource.getPart());
            }
        });
        return parts;
    }

    public List<Resource> getResources(Class<? extends SpecificResource> resourceType, String ... partKeys) throws XJdfDocumentException {
        ResourceSet resourceSet = this.getResourceSet(resourceType);
        return this.getResources(resourceSet, partKeys);
    }

    public List<Resource> getResources(ResourceSet resourceSet, String ... partKeys) {
        List<Resource> result = null;
        if (resourceSet != null) {
            result = Partitions.getResourcesByPartKeys(resourceSet, partKeys);
        }
        return result;
    }

    public Resource getResource(Class<? extends SpecificResource> resourceType, Part part) throws XJdfDocumentException {
        ResourceSet resourceSet = this.getResourceSet(resourceType);
        return this.getResource(resourceSet, part);
    }

    public Resource getResource(ResourceSet resourceSet, Part part) {
        Resource result = null;
        if (resourceSet != null) {
            result = Partitions.getResourceByPart(resourceSet, part);
        }
        return result;
    }

    public Resource getResource(Class<? extends SpecificResource> resourceType) throws XJdfDocumentException {
        return this.getResource(resourceType, null);
    }

    public Resource getResource(ResourceSet resourceSet) throws XJdfDocumentException {
        return this.getResource(resourceSet, null);
    }

    public Resource getResource(String resourceId) {
        ArrayList matchingResources = new ArrayList();
        this.xjdf.getResourceSet().stream().forEach(resourceSet -> resourceSet.getResource().forEach(resource -> {
            if (Objects.equals(resource.getID(), resourceId)) {
                matchingResources.add(resource);
            }
        }));
        if (matchingResources.size() > 1) {
            throw new IllegalArgumentException("Multiple matching resources has been found. ID must be unique within the XJDF Document.");
        }
        return matchingResources.size() == 1 ? (Resource)matchingResources.get(0) : null;
    }

    public boolean removeResource(ResourceSet resourceSet, Part part) {
        Resource resource = this.getResource(resourceSet, part);
        return resourceSet.getResource().remove(resource);
    }

    public <T extends SpecificResource> List<T> getSpecificResources(Class<T> resourceType, String ... partKeys) throws XJdfDocumentException {
        ResourceSet resourceSet = this.getResourceSet(resourceType);
        return this.getSpecificResources(resourceSet, partKeys);
    }

    public <T extends SpecificResource> List<T> getSpecificResources(ResourceSet resourceSet, String ... partKeys) {
        List<Resource> resources = this.getResources(resourceSet, partKeys);
        if (resources == null) {
            return null;
        }
        return resources.stream().map(resource -> (SpecificResource)resource.getSpecificResource().getValue()).collect(Collectors.toList());
    }

    public <T extends SpecificResource> T getSpecificResource(Class<T> resourceType, Part part) throws XJdfDocumentException {
        ResourceSet resourceSet = this.getResourceSet(resourceType);
        return this.getSpecificResource(resourceSet, part);
    }

    public <T extends SpecificResource> T getSpecificResource(ResourceSet resourceSet, Part part) throws XJdfDocumentException {
        Resource resource = this.getResource(resourceSet, part);
        return (T)(resource == null ? null : (SpecificResource)resource.getSpecificResource().getValue());
    }

    public <T extends SpecificResource> T getSpecificResource(Class<T> resourceType) throws XJdfDocumentException {
        return this.getSpecificResource(resourceType, null);
    }

    public <T extends SpecificResource> T getSpecificResource(ResourceSet resourceSet) throws XJdfDocumentException {
        return this.getSpecificResource(resourceSet, null);
    }

    public <T extends SpecificResource> T getSpecificResource(String resourceId) {
        Resource resource = this.getResource(resourceId);
        return (T)(resource == null ? null : (SpecificResource)resource.getSpecificResource().getValue());
    }
}

