/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import jakarta.xml.bind.JAXBElement;
import java.util.ArrayList;
import java.util.List;
import org.cip4.lib.xjdf.XJdfConstants;
import org.cip4.lib.xjdf.exception.XJdfParseException;
import org.cip4.lib.xjdf.exception.XJdfValidationException;
import org.cip4.lib.xjdf.schema.Message;
import org.cip4.lib.xjdf.schema.XJMF;
import org.cip4.lib.xjdf.util.Headers;
import org.cip4.lib.xjdf.xml.XJdfParser;
import org.cip4.lib.xjdf.xml.XJdfValidator;
import org.jetbrains.annotations.NotNull;

public class XJmfMessage {
    private final XJdfParser<XJMF> xjmfParser;
    private final XJdfValidator xJdfValidator;
    private final XJMF xjmf;

    public XJmfMessage() {
        this(new XJMF().withHeader(Headers.createDefaultHeader()).withVersion(XJdfConstants.XJDF_CURRENT_VERSION));
    }

    public XJmfMessage(byte[] bytes) throws XJdfParseException {
        this((XJMF)new XJdfParser().readXml(bytes));
    }

    public XJmfMessage(XJMF xjmf) {
        this.xjmf = xjmf;
        this.xjmfParser = new XJdfParser();
        this.xJdfValidator = new XJdfValidator();
    }

    public XJMF getXJmf() {
        return this.xjmf;
    }

    public void addMessage(@NotNull Message message) {
        if (message.getHeader() == null) {
            message.setHeader(Headers.createDefaultHeader());
        }
        this.xjmf.getMessages().add(message);
    }

    public List<Message> getMessages() {
        ArrayList<Message> messages = new ArrayList<Message>(this.getXJmf().getMessages().size());
        for (Message obj : this.getXJmf().getMessages()) {
            JAXBElement jaxbElement = (JAXBElement)obj;
            messages.add((Message)jaxbElement.getValue());
        }
        return messages;
    }

    public byte[] toXml() throws XJdfParseException, XJdfValidationException {
        return this.toXml(true);
    }

    public byte[] toXml(boolean validate) throws XJdfParseException, XJdfValidationException {
        byte[] xml = this.xjmfParser.writeXml(this.xjmf);
        if (validate) {
            this.xJdfValidator.validate(xml);
        }
        return xml;
    }

    public String toString() {
        try {
            return new String(this.toXml(false));
        }
        catch (Exception e) {
            return "Error creating an XML preview.";
        }
    }
}

