/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.schema.RenderingIntent;
import org.cip4.lib.xjdf.schema.ScreenSelector;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"fileSpec", "screenSelector"})
@XmlRootElement(name="ColorSpaceConversionOp")
public class ColorSpaceConversionOp
implements Serializable {
    @XmlElement(name="FileSpec")
    protected List<FileSpec> fileSpec;
    @XmlElement(name="ScreenSelector")
    protected ScreenSelector screenSelector;
    @XmlAttribute(name="Operation", required=true)
    protected Operation operation;
    @XmlAttribute(name="PreserveBlack")
    protected Boolean preserveBlack;
    @XmlAttribute(name="RenderingIntent")
    protected RenderingIntent renderingIntent;
    @XmlAttribute(name="RGBGray2Black")
    protected Boolean rgbGray2Black;
    @XmlAttribute(name="RGBGray2BlackThreshold")
    protected Float rgbGray2BlackThreshold;
    @XmlAttribute(name="Separations")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> separations;
    @XmlAttribute(name="SourceCS")
    protected SourceCS sourceCS;
    @XmlAttribute(name="SourceObjects")
    protected List<String> sourceObjects;
    @XmlAttribute(name="SourceRenderingIntent")
    protected RenderingIntent sourceRenderingIntent;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<FileSpec> getFileSpec() {
        if (this.fileSpec == null) {
            this.fileSpec = new ArrayList<FileSpec>();
        }
        return this.fileSpec;
    }

    public ScreenSelector getScreenSelector() {
        return this.screenSelector;
    }

    public void setScreenSelector(ScreenSelector value) {
        this.screenSelector = value;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation value) {
        this.operation = value;
    }

    public Boolean isPreserveBlack() {
        return this.preserveBlack;
    }

    public void setPreserveBlack(Boolean value) {
        this.preserveBlack = value;
    }

    public RenderingIntent getRenderingIntent() {
        return this.renderingIntent;
    }

    public void setRenderingIntent(RenderingIntent value) {
        this.renderingIntent = value;
    }

    public Boolean isRGBGray2Black() {
        return this.rgbGray2Black;
    }

    public void setRGBGray2Black(Boolean value) {
        this.rgbGray2Black = value;
    }

    public Float getRGBGray2BlackThreshold() {
        return this.rgbGray2BlackThreshold;
    }

    public void setRGBGray2BlackThreshold(Float value) {
        this.rgbGray2BlackThreshold = value;
    }

    public List<String> getSeparations() {
        if (this.separations == null) {
            this.separations = new ArrayList<String>();
        }
        return this.separations;
    }

    public SourceCS getSourceCS() {
        return this.sourceCS;
    }

    public void setSourceCS(SourceCS value) {
        this.sourceCS = value;
    }

    public List<String> getSourceObjects() {
        if (this.sourceObjects == null) {
            this.sourceObjects = new ArrayList<String>();
        }
        return this.sourceObjects;
    }

    public RenderingIntent getSourceRenderingIntent() {
        return this.sourceRenderingIntent;
    }

    public void setSourceRenderingIntent(RenderingIntent value) {
        this.sourceRenderingIntent = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ColorSpaceConversionOp withFileSpec(FileSpec ... values) {
        if (values != null) {
            for (FileSpec value : values) {
                this.getFileSpec().add(value);
            }
        }
        return this;
    }

    public ColorSpaceConversionOp withFileSpec(Collection<FileSpec> values) {
        if (values != null) {
            this.getFileSpec().addAll(values);
        }
        return this;
    }

    public ColorSpaceConversionOp withScreenSelector(ScreenSelector value) {
        this.setScreenSelector(value);
        return this;
    }

    public ColorSpaceConversionOp withOperation(Operation value) {
        this.setOperation(value);
        return this;
    }

    public ColorSpaceConversionOp withPreserveBlack(Boolean value) {
        this.setPreserveBlack(value);
        return this;
    }

    public ColorSpaceConversionOp withRenderingIntent(RenderingIntent value) {
        this.setRenderingIntent(value);
        return this;
    }

    public ColorSpaceConversionOp withRGBGray2Black(Boolean value) {
        this.setRGBGray2Black(value);
        return this;
    }

    public ColorSpaceConversionOp withRGBGray2BlackThreshold(Float value) {
        this.setRGBGray2BlackThreshold(value);
        return this;
    }

    public ColorSpaceConversionOp withSeparations(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSeparations().add(value);
            }
        }
        return this;
    }

    public ColorSpaceConversionOp withSeparations(Collection<String> values) {
        if (values != null) {
            this.getSeparations().addAll(values);
        }
        return this;
    }

    public ColorSpaceConversionOp withSourceCS(SourceCS value) {
        this.setSourceCS(value);
        return this;
    }

    public ColorSpaceConversionOp withSourceObjects(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getSourceObjects().add(value);
            }
        }
        return this;
    }

    public ColorSpaceConversionOp withSourceObjects(Collection<String> values) {
        if (values != null) {
            this.getSourceObjects().addAll(values);
        }
        return this;
    }

    public ColorSpaceConversionOp withSourceRenderingIntent(RenderingIntent value) {
        this.setSourceRenderingIntent(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightSourceObjects;
        List<String> rightSeparations;
        List<FileSpec> rightFileSpec;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ColorSpaceConversionOp that = (ColorSpaceConversionOp)object;
        List<FileSpec> leftFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        List<FileSpec> list = rightFileSpec = that.fileSpec != null && !that.fileSpec.isEmpty() ? that.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            if (that.fileSpec == null || that.fileSpec.isEmpty()) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null && !that.fileSpec.isEmpty()) {
            return false;
        }
        ScreenSelector leftScreenSelector = this.getScreenSelector();
        ScreenSelector rightScreenSelector = that.getScreenSelector();
        if (this.screenSelector != null) {
            if (that.screenSelector == null) return false;
            if (!leftScreenSelector.equals(rightScreenSelector)) {
                return false;
            }
        } else if (that.screenSelector != null) {
            return false;
        }
        Operation leftOperation = this.getOperation();
        Operation rightOperation = that.getOperation();
        if (this.operation != null) {
            if (that.operation == null) return false;
            if (!leftOperation.equals((Object)rightOperation)) {
                return false;
            }
        } else if (that.operation != null) {
            return false;
        }
        Boolean leftPreserveBlack = this.isPreserveBlack();
        Boolean rightPreserveBlack = that.isPreserveBlack();
        if (this.preserveBlack != null) {
            if (that.preserveBlack == null) return false;
            if (!leftPreserveBlack.equals(rightPreserveBlack)) {
                return false;
            }
        } else if (that.preserveBlack != null) {
            return false;
        }
        RenderingIntent leftRenderingIntent = this.getRenderingIntent();
        RenderingIntent rightRenderingIntent = that.getRenderingIntent();
        if (this.renderingIntent != null) {
            if (that.renderingIntent == null) return false;
            if (!leftRenderingIntent.equals((Object)rightRenderingIntent)) {
                return false;
            }
        } else if (that.renderingIntent != null) {
            return false;
        }
        Boolean leftRGBGray2Black = this.isRGBGray2Black();
        Boolean rightRGBGray2Black = that.isRGBGray2Black();
        if (this.rgbGray2Black != null) {
            if (that.rgbGray2Black == null) return false;
            if (!leftRGBGray2Black.equals(rightRGBGray2Black)) {
                return false;
            }
        } else if (that.rgbGray2Black != null) {
            return false;
        }
        Float leftRGBGray2BlackThreshold = this.getRGBGray2BlackThreshold();
        Float rightRGBGray2BlackThreshold = that.getRGBGray2BlackThreshold();
        if (this.rgbGray2BlackThreshold != null) {
            if (that.rgbGray2BlackThreshold == null) return false;
            if (!leftRGBGray2BlackThreshold.equals(rightRGBGray2BlackThreshold)) {
                return false;
            }
        } else if (that.rgbGray2BlackThreshold != null) {
            return false;
        }
        List<String> leftSeparations = this.separations != null && !this.separations.isEmpty() ? this.getSeparations() : null;
        List<String> list2 = rightSeparations = that.separations != null && !that.separations.isEmpty() ? that.getSeparations() : null;
        if (this.separations != null && !this.separations.isEmpty()) {
            if (that.separations == null || that.separations.isEmpty()) return false;
            if (!leftSeparations.equals(rightSeparations)) {
                return false;
            }
        } else if (that.separations != null && !that.separations.isEmpty()) {
            return false;
        }
        SourceCS leftSourceCS = this.getSourceCS();
        SourceCS rightSourceCS = that.getSourceCS();
        if (this.sourceCS != null) {
            if (that.sourceCS == null) return false;
            if (!leftSourceCS.equals((Object)rightSourceCS)) {
                return false;
            }
        } else if (that.sourceCS != null) {
            return false;
        }
        List<String> leftSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        List<String> list3 = rightSourceObjects = that.sourceObjects != null && !that.sourceObjects.isEmpty() ? that.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            if (that.sourceObjects == null || that.sourceObjects.isEmpty()) return false;
            if (!leftSourceObjects.equals(rightSourceObjects)) {
                return false;
            }
        } else if (that.sourceObjects != null && !that.sourceObjects.isEmpty()) {
            return false;
        }
        RenderingIntent leftSourceRenderingIntent = this.getSourceRenderingIntent();
        RenderingIntent rightSourceRenderingIntent = that.getSourceRenderingIntent();
        if (this.sourceRenderingIntent != null) {
            if (that.sourceRenderingIntent == null) return false;
            if (leftSourceRenderingIntent.equals((Object)rightSourceRenderingIntent)) return true;
            return false;
        }
        if (that.sourceRenderingIntent == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> theSourceObjects;
        List<String> theSeparations;
        List<FileSpec> theFileSpec;
        int currentHashCode = 1;
        currentHashCode *= 31;
        List<FileSpec> list = theFileSpec = this.fileSpec != null && !this.fileSpec.isEmpty() ? this.getFileSpec() : null;
        if (this.fileSpec != null && !this.fileSpec.isEmpty()) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        ScreenSelector theScreenSelector = this.getScreenSelector();
        if (this.screenSelector != null) {
            currentHashCode += theScreenSelector.hashCode();
        }
        currentHashCode *= 31;
        Operation theOperation = this.getOperation();
        if (this.operation != null) {
            currentHashCode += theOperation.hashCode();
        }
        currentHashCode *= 31;
        Boolean thePreserveBlack = this.isPreserveBlack();
        if (this.preserveBlack != null) {
            currentHashCode += thePreserveBlack.hashCode();
        }
        currentHashCode *= 31;
        RenderingIntent theRenderingIntent = this.getRenderingIntent();
        if (this.renderingIntent != null) {
            currentHashCode += theRenderingIntent.hashCode();
        }
        currentHashCode *= 31;
        Boolean theRGBGray2Black = this.isRGBGray2Black();
        if (this.rgbGray2Black != null) {
            currentHashCode += theRGBGray2Black.hashCode();
        }
        currentHashCode *= 31;
        Float theRGBGray2BlackThreshold = this.getRGBGray2BlackThreshold();
        if (this.rgbGray2BlackThreshold != null) {
            currentHashCode += theRGBGray2BlackThreshold.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theSeparations = this.separations != null && !this.separations.isEmpty() ? this.getSeparations() : null;
        if (this.separations != null && !this.separations.isEmpty()) {
            currentHashCode += theSeparations.hashCode();
        }
        currentHashCode *= 31;
        SourceCS theSourceCS = this.getSourceCS();
        if (this.sourceCS != null) {
            currentHashCode += theSourceCS.hashCode();
        }
        currentHashCode *= 31;
        List<String> list3 = theSourceObjects = this.sourceObjects != null && !this.sourceObjects.isEmpty() ? this.getSourceObjects() : null;
        if (this.sourceObjects != null && !this.sourceObjects.isEmpty()) {
            currentHashCode += theSourceObjects.hashCode();
        }
        currentHashCode *= 31;
        RenderingIntent theSourceRenderingIntent = this.getSourceRenderingIntent();
        if (this.sourceRenderingIntent != null) {
            currentHashCode += theSourceRenderingIntent.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum SourceCS {
        ALL("All"),
        CAL_GRAY("CalGray"),
        CALIBRATED("Calibrated"),
        CAL_RGB("CalRGB"),
        CIE_BASED("CIEBased"),
        CMYK("CMYK"),
        DEVICE_CMYK("DeviceCMYK"),
        DEVICE_GRAY("DeviceGray"),
        DEVICE_N("DeviceN"),
        DEVICE_RGB("DeviceRGB"),
        DEV_INDEP("DevIndep"),
        GRAY("Gray"),
        ICC_BASED("ICCBased"),
        ICCCMYK("ICCCMYK"),
        ICC_GRAY("ICCGray"),
        ICCLAB("ICCLAB"),
        ICCRGB("ICCRGB"),
        LAB("Lab"),
        RGB("RGB"),
        SEPARATION("Separation"),
        YUV("YUV");

        private final String value;

        private SourceCS(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static SourceCS fromValue(String v) {
            for (SourceCS c : SourceCS.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Operation {
        CONVERT("Convert"),
        TAG("Tag"),
        UNTAG("Untag");

        private final String value;

        private Operation(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Operation fromValue(String v) {
            for (Operation c : Operation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

