/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.SpecificResource;
import org.cip4.lib.xjdf.type.Rectangle;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="LaminatingParams")
@XmlRootElement(name="LaminatingParams")
public class LaminatingParams
extends SpecificResource
implements Serializable {
    @XmlAttribute(name="GapList")
    protected List<Float> gapList;
    @XmlAttribute(name="LaminatingBox")
    @XmlJavaTypeAdapter(value=Rectangle.class)
    protected Rectangle laminatingBox;
    @XmlAttribute(name="LaminatingMethod")
    protected LaminatingMethod laminatingMethod;
    @XmlAttribute(name="ModuleID")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String moduleID;
    @XmlAttribute(name="NipWidth")
    protected Float nipWidth;
    @XmlAttribute(name="Temperature")
    protected Float temperature;

    public List<Float> getGapList() {
        if (this.gapList == null) {
            this.gapList = new ArrayList<Float>();
        }
        return this.gapList;
    }

    public Rectangle getLaminatingBox() {
        return this.laminatingBox;
    }

    public void setLaminatingBox(Rectangle value) {
        this.laminatingBox = value;
    }

    public LaminatingMethod getLaminatingMethod() {
        return this.laminatingMethod;
    }

    public void setLaminatingMethod(LaminatingMethod value) {
        this.laminatingMethod = value;
    }

    public String getModuleID() {
        return this.moduleID;
    }

    public void setModuleID(String value) {
        this.moduleID = value;
    }

    public Float getNipWidth() {
        return this.nipWidth;
    }

    public void setNipWidth(Float value) {
        this.nipWidth = value;
    }

    public Float getTemperature() {
        return this.temperature;
    }

    public void setTemperature(Float value) {
        this.temperature = value;
    }

    public LaminatingParams withGapList(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getGapList().add(value);
            }
        }
        return this;
    }

    public LaminatingParams withGapList(Collection<Float> values) {
        if (values != null) {
            this.getGapList().addAll(values);
        }
        return this;
    }

    public LaminatingParams withLaminatingBox(Rectangle value) {
        this.setLaminatingBox(value);
        return this;
    }

    public LaminatingParams withLaminatingMethod(LaminatingMethod value) {
        this.setLaminatingMethod(value);
        return this;
    }

    public LaminatingParams withModuleID(String value) {
        this.setModuleID(value);
        return this;
    }

    public LaminatingParams withNipWidth(Float value) {
        this.setNipWidth(value);
        return this;
    }

    public LaminatingParams withTemperature(Float value) {
        this.setTemperature(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightGapList;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        LaminatingParams that = (LaminatingParams)object;
        List<Float> leftGapList = this.gapList != null && !this.gapList.isEmpty() ? this.getGapList() : null;
        List<Float> list = rightGapList = that.gapList != null && !that.gapList.isEmpty() ? that.getGapList() : null;
        if (this.gapList != null && !this.gapList.isEmpty()) {
            if (that.gapList == null || that.gapList.isEmpty()) return false;
            if (!leftGapList.equals(rightGapList)) {
                return false;
            }
        } else if (that.gapList != null && !that.gapList.isEmpty()) {
            return false;
        }
        Rectangle leftLaminatingBox = this.getLaminatingBox();
        Rectangle rightLaminatingBox = that.getLaminatingBox();
        if (this.laminatingBox != null) {
            if (that.laminatingBox == null) return false;
            if (!leftLaminatingBox.equals((Object)rightLaminatingBox)) {
                return false;
            }
        } else if (that.laminatingBox != null) {
            return false;
        }
        LaminatingMethod leftLaminatingMethod = this.getLaminatingMethod();
        LaminatingMethod rightLaminatingMethod = that.getLaminatingMethod();
        if (this.laminatingMethod != null) {
            if (that.laminatingMethod == null) return false;
            if (!leftLaminatingMethod.equals((Object)rightLaminatingMethod)) {
                return false;
            }
        } else if (that.laminatingMethod != null) {
            return false;
        }
        String leftModuleID = this.getModuleID();
        String rightModuleID = that.getModuleID();
        if (this.moduleID != null) {
            if (that.moduleID == null) return false;
            if (!leftModuleID.equals(rightModuleID)) {
                return false;
            }
        } else if (that.moduleID != null) {
            return false;
        }
        Float leftNipWidth = this.getNipWidth();
        Float rightNipWidth = that.getNipWidth();
        if (this.nipWidth != null) {
            if (that.nipWidth == null) return false;
            if (!leftNipWidth.equals(rightNipWidth)) {
                return false;
            }
        } else if (that.nipWidth != null) {
            return false;
        }
        Float leftTemperature = this.getTemperature();
        Float rightTemperature = that.getTemperature();
        if (this.temperature != null) {
            if (that.temperature == null) return false;
            if (leftTemperature.equals(rightTemperature)) return true;
            return false;
        }
        if (that.temperature == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theGapList;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<Float> list = theGapList = this.gapList != null && !this.gapList.isEmpty() ? this.getGapList() : null;
        if (this.gapList != null && !this.gapList.isEmpty()) {
            currentHashCode += theGapList.hashCode();
        }
        currentHashCode *= 31;
        Rectangle theLaminatingBox = this.getLaminatingBox();
        if (this.laminatingBox != null) {
            currentHashCode += theLaminatingBox.hashCode();
        }
        currentHashCode *= 31;
        LaminatingMethod theLaminatingMethod = this.getLaminatingMethod();
        if (this.laminatingMethod != null) {
            currentHashCode += theLaminatingMethod.hashCode();
        }
        currentHashCode *= 31;
        String theModuleID = this.getModuleID();
        if (this.moduleID != null) {
            currentHashCode += theModuleID.hashCode();
        }
        currentHashCode *= 31;
        Float theNipWidth = this.getNipWidth();
        if (this.nipWidth != null) {
            currentHashCode += theNipWidth.hashCode();
        }
        currentHashCode *= 31;
        Float theTemperature = this.getTemperature();
        if (this.temperature != null) {
            currentHashCode += theTemperature.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum LaminatingMethod {
        COMPOUND_FOIL("CompoundFoil"),
        DISPERSION_GLUE("DispersionGlue"),
        FUSING("Fusing");

        private final String value;

        private LaminatingMethod(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static LaminatingMethod fromValue(String v) {
            for (LaminatingMethod c : LaminatingMethod.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

