/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.TIFFEmbeddedFile;
import org.cip4.lib.xjdf.schema.TIFFtag;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"tiffEmbeddedFile", "tifFtag"})
@XmlRootElement(name="TIFFFormatParams")
public class TIFFFormatParams
implements Serializable {
    @XmlElement(name="TIFFEmbeddedFile")
    protected List<TIFFEmbeddedFile> tiffEmbeddedFile;
    @XmlElement(name="TIFFtag")
    protected List<TIFFtag> tifFtag;
    @XmlAttribute(name="ByteOrder")
    protected ByteOrder byteOrder;
    @XmlAttribute(name="Interleaving")
    protected Integer interleaving;
    @XmlAttribute(name="RowsPerStrip")
    protected Integer rowsPerStrip;
    @XmlAttribute(name="Segmentation")
    protected Segmentation segmentation;
    @XmlAttribute(name="SeparationNameTag")
    protected Integer separationNameTag;
    @XmlAttribute(name="TileSize")
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair tileSize;
    @XmlAttribute(name="WhiteIsZero")
    protected Boolean whiteIsZero;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public List<TIFFEmbeddedFile> getTIFFEmbeddedFile() {
        if (this.tiffEmbeddedFile == null) {
            this.tiffEmbeddedFile = new ArrayList<TIFFEmbeddedFile>();
        }
        return this.tiffEmbeddedFile;
    }

    public List<TIFFtag> getTIFFtag() {
        if (this.tifFtag == null) {
            this.tifFtag = new ArrayList<TIFFtag>();
        }
        return this.tifFtag;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder value) {
        this.byteOrder = value;
    }

    public Integer getInterleaving() {
        return this.interleaving;
    }

    public void setInterleaving(Integer value) {
        this.interleaving = value;
    }

    public Integer getRowsPerStrip() {
        return this.rowsPerStrip;
    }

    public void setRowsPerStrip(Integer value) {
        this.rowsPerStrip = value;
    }

    public Segmentation getSegmentation() {
        return this.segmentation;
    }

    public void setSegmentation(Segmentation value) {
        this.segmentation = value;
    }

    public Integer getSeparationNameTag() {
        return this.separationNameTag;
    }

    public void setSeparationNameTag(Integer value) {
        this.separationNameTag = value;
    }

    public XYPair getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(XYPair value) {
        this.tileSize = value;
    }

    public Boolean isWhiteIsZero() {
        return this.whiteIsZero;
    }

    public void setWhiteIsZero(Boolean value) {
        this.whiteIsZero = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public TIFFFormatParams withTIFFEmbeddedFile(TIFFEmbeddedFile ... values) {
        if (values != null) {
            for (TIFFEmbeddedFile value : values) {
                this.getTIFFEmbeddedFile().add(value);
            }
        }
        return this;
    }

    public TIFFFormatParams withTIFFEmbeddedFile(Collection<TIFFEmbeddedFile> values) {
        if (values != null) {
            this.getTIFFEmbeddedFile().addAll(values);
        }
        return this;
    }

    public TIFFFormatParams withTIFFtag(TIFFtag ... values) {
        if (values != null) {
            for (TIFFtag value : values) {
                this.getTIFFtag().add(value);
            }
        }
        return this;
    }

    public TIFFFormatParams withTIFFtag(Collection<TIFFtag> values) {
        if (values != null) {
            this.getTIFFtag().addAll(values);
        }
        return this;
    }

    public TIFFFormatParams withByteOrder(ByteOrder value) {
        this.setByteOrder(value);
        return this;
    }

    public TIFFFormatParams withInterleaving(Integer value) {
        this.setInterleaving(value);
        return this;
    }

    public TIFFFormatParams withRowsPerStrip(Integer value) {
        this.setRowsPerStrip(value);
        return this;
    }

    public TIFFFormatParams withSegmentation(Segmentation value) {
        this.setSegmentation(value);
        return this;
    }

    public TIFFFormatParams withSeparationNameTag(Integer value) {
        this.setSeparationNameTag(value);
        return this;
    }

    public TIFFFormatParams withTileSize(XYPair value) {
        this.setTileSize(value);
        return this;
    }

    public TIFFFormatParams withWhiteIsZero(Boolean value) {
        this.setWhiteIsZero(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<TIFFtag> rightTIFFtag;
        List<TIFFEmbeddedFile> rightTIFFEmbeddedFile;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        TIFFFormatParams that = (TIFFFormatParams)object;
        List<TIFFEmbeddedFile> leftTIFFEmbeddedFile = this.tiffEmbeddedFile != null && !this.tiffEmbeddedFile.isEmpty() ? this.getTIFFEmbeddedFile() : null;
        List<TIFFEmbeddedFile> list = rightTIFFEmbeddedFile = that.tiffEmbeddedFile != null && !that.tiffEmbeddedFile.isEmpty() ? that.getTIFFEmbeddedFile() : null;
        if (this.tiffEmbeddedFile != null && !this.tiffEmbeddedFile.isEmpty()) {
            if (that.tiffEmbeddedFile == null || that.tiffEmbeddedFile.isEmpty()) return false;
            if (!leftTIFFEmbeddedFile.equals(rightTIFFEmbeddedFile)) {
                return false;
            }
        } else if (that.tiffEmbeddedFile != null && !that.tiffEmbeddedFile.isEmpty()) {
            return false;
        }
        List<TIFFtag> leftTIFFtag = this.tifFtag != null && !this.tifFtag.isEmpty() ? this.getTIFFtag() : null;
        List<TIFFtag> list2 = rightTIFFtag = that.tifFtag != null && !that.tifFtag.isEmpty() ? that.getTIFFtag() : null;
        if (this.tifFtag != null && !this.tifFtag.isEmpty()) {
            if (that.tifFtag == null || that.tifFtag.isEmpty()) return false;
            if (!leftTIFFtag.equals(rightTIFFtag)) {
                return false;
            }
        } else if (that.tifFtag != null && !that.tifFtag.isEmpty()) {
            return false;
        }
        ByteOrder leftByteOrder = this.getByteOrder();
        ByteOrder rightByteOrder = that.getByteOrder();
        if (this.byteOrder != null) {
            if (that.byteOrder == null) return false;
            if (!leftByteOrder.equals((Object)rightByteOrder)) {
                return false;
            }
        } else if (that.byteOrder != null) {
            return false;
        }
        Integer leftInterleaving = this.getInterleaving();
        Integer rightInterleaving = that.getInterleaving();
        if (this.interleaving != null) {
            if (that.interleaving == null) return false;
            if (!leftInterleaving.equals(rightInterleaving)) {
                return false;
            }
        } else if (that.interleaving != null) {
            return false;
        }
        Integer leftRowsPerStrip = this.getRowsPerStrip();
        Integer rightRowsPerStrip = that.getRowsPerStrip();
        if (this.rowsPerStrip != null) {
            if (that.rowsPerStrip == null) return false;
            if (!leftRowsPerStrip.equals(rightRowsPerStrip)) {
                return false;
            }
        } else if (that.rowsPerStrip != null) {
            return false;
        }
        Segmentation leftSegmentation = this.getSegmentation();
        Segmentation rightSegmentation = that.getSegmentation();
        if (this.segmentation != null) {
            if (that.segmentation == null) return false;
            if (!leftSegmentation.equals((Object)rightSegmentation)) {
                return false;
            }
        } else if (that.segmentation != null) {
            return false;
        }
        Integer leftSeparationNameTag = this.getSeparationNameTag();
        Integer rightSeparationNameTag = that.getSeparationNameTag();
        if (this.separationNameTag != null) {
            if (that.separationNameTag == null) return false;
            if (!leftSeparationNameTag.equals(rightSeparationNameTag)) {
                return false;
            }
        } else if (that.separationNameTag != null) {
            return false;
        }
        XYPair leftTileSize = this.getTileSize();
        XYPair rightTileSize = that.getTileSize();
        if (this.tileSize != null) {
            if (that.tileSize == null) return false;
            if (!leftTileSize.equals((Object)rightTileSize)) {
                return false;
            }
        } else if (that.tileSize != null) {
            return false;
        }
        Boolean leftWhiteIsZero = this.isWhiteIsZero();
        Boolean rightWhiteIsZero = that.isWhiteIsZero();
        if (this.whiteIsZero != null) {
            if (that.whiteIsZero == null) return false;
            if (leftWhiteIsZero.equals(rightWhiteIsZero)) return true;
            return false;
        }
        if (that.whiteIsZero == null) return true;
        return false;
    }

    public int hashCode() {
        List<TIFFtag> theTIFFtag;
        List<TIFFEmbeddedFile> theTIFFEmbeddedFile;
        int currentHashCode = 1;
        currentHashCode *= 31;
        List<TIFFEmbeddedFile> list = theTIFFEmbeddedFile = this.tiffEmbeddedFile != null && !this.tiffEmbeddedFile.isEmpty() ? this.getTIFFEmbeddedFile() : null;
        if (this.tiffEmbeddedFile != null && !this.tiffEmbeddedFile.isEmpty()) {
            currentHashCode += theTIFFEmbeddedFile.hashCode();
        }
        currentHashCode *= 31;
        List<TIFFtag> list2 = theTIFFtag = this.tifFtag != null && !this.tifFtag.isEmpty() ? this.getTIFFtag() : null;
        if (this.tifFtag != null && !this.tifFtag.isEmpty()) {
            currentHashCode += theTIFFtag.hashCode();
        }
        currentHashCode *= 31;
        ByteOrder theByteOrder = this.getByteOrder();
        if (this.byteOrder != null) {
            currentHashCode += theByteOrder.hashCode();
        }
        currentHashCode *= 31;
        Integer theInterleaving = this.getInterleaving();
        if (this.interleaving != null) {
            currentHashCode += theInterleaving.hashCode();
        }
        currentHashCode *= 31;
        Integer theRowsPerStrip = this.getRowsPerStrip();
        if (this.rowsPerStrip != null) {
            currentHashCode += theRowsPerStrip.hashCode();
        }
        currentHashCode *= 31;
        Segmentation theSegmentation = this.getSegmentation();
        if (this.segmentation != null) {
            currentHashCode += theSegmentation.hashCode();
        }
        currentHashCode *= 31;
        Integer theSeparationNameTag = this.getSeparationNameTag();
        if (this.separationNameTag != null) {
            currentHashCode += theSeparationNameTag.hashCode();
        }
        currentHashCode *= 31;
        XYPair theTileSize = this.getTileSize();
        if (this.tileSize != null) {
            currentHashCode += theTileSize.hashCode();
        }
        currentHashCode *= 31;
        Boolean theWhiteIsZero = this.isWhiteIsZero();
        if (this.whiteIsZero != null) {
            currentHashCode += theWhiteIsZero.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Segmentation {
        SINGLE_STRIP("SingleStrip"),
        STRIPPED("Stripped"),
        TILED("Tiled");

        private final String value;

        private Segmentation(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Segmentation fromValue(String v) {
            for (Segmentation c : Segmentation.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ByteOrder {
        II,
        MM;


        public String value() {
            return this.name();
        }

        public static ByteOrder fromValue(String v) {
            return ByteOrder.valueOf(v);
        }
    }
}

