/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.text.ParseException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class DateTime
extends AbstractXJdfType<String, DateTime> {
    private final ZonedDateTime zonedDateTime;
    private final DateTimeFormatter DATETIME_OUTPUT_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");

    public DateTime() {
        this.zonedDateTime = ZonedDateTime.now();
    }

    public DateTime(ZonedDateTime zonedDateTime) {
        this.zonedDateTime = zonedDateTime;
    }

    public DateTime(int year, int month, int day) {
        this(year, month, day, 0, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute) {
        this(year, month, day, hour, minute, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second) {
        this(year, month, day, hour, minute, second, 0, ZoneId.systemDefault());
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millis, ZoneId zoneId) {
        this.zonedDateTime = ZonedDateTime.of(year, month, day, hour, minute, second, millis * 1000000, zoneId);
    }

    public DateTime(String dateTime) throws ParseException {
        this.zonedDateTime = ZonedDateTime.parse(dateTime, DateTimeFormatter.ISO_DATE_TIME);
    }

    public DateTime(Date date) {
        this.zonedDateTime = ZonedDateTime.ofInstant(date.toInstant(), ZoneId.systemDefault());
    }

    public DateTime(long epochMillis) {
        this.zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(epochMillis), ZoneId.systemDefault());
    }

    public final Calendar getCalendar() {
        return GregorianCalendar.from(this.zonedDateTime);
    }

    public final ZonedDateTime getZonedDateTime() {
        return this.zonedDateTime;
    }

    public final String marshal(DateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return dateTime.toString();
    }

    public final DateTime unmarshal(String dateTime) throws Exception {
        return new DateTime(dateTime);
    }

    @Override
    public final String toString() {
        return this.zonedDateTime.format(this.DATETIME_OUTPUT_FORMAT);
    }

    public final String toString(ZoneId zoneId) {
        return ZonedDateTime.ofInstant(this.zonedDateTime.toInstant(), zoneId).format(this.DATETIME_OUTPUT_FORMAT);
    }
}

