/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.type;

import java.util.Locale;
import org.cip4.lib.xjdf.type.AbstractXJdfType;

public class XYPair
extends AbstractXJdfType<String, XYPair> {
    private final float x;
    private final float y;

    public XYPair() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public XYPair(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public XYPair(String expression) {
        String[] s = expression.split(" ");
        this.x = Float.parseFloat(s[0]);
        this.y = Float.parseFloat(s[1]);
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public XYPair add(XYPair other) {
        return new XYPair(this.getX() + other.getX(), this.getY() + other.getY());
    }

    public XYPair subtract(XYPair other) {
        return new XYPair(this.getX() - other.getX(), this.getY() - other.getY());
    }

    public String marshal(XYPair xyPair) {
        if (xyPair == null) {
            return null;
        }
        float x = xyPair.getX();
        float y = xyPair.getY();
        return String.format(Locale.US, "%.3f %.3f", Float.valueOf(x), Float.valueOf(y));
    }

    public XYPair unmarshal(String v) {
        return new XYPair(v);
    }

    @Override
    public String toString() {
        return this.marshal(this);
    }
}

