/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.util;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.cip4.lib.xjdf.schema.Part;
import org.cip4.lib.xjdf.schema.Resource;
import org.cip4.lib.xjdf.schema.ResourceSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Partitions {
    private static final List<Method> GETTERS = Partitions.readGetters();

    private Partitions() {
    }

    public static Map<String, List<Object>> getPartKeyValues(ResourceSet resourceSet) throws IllegalAccessException {
        HashMap<String, List<Object>> partKeyValues = new HashMap<String, List<Object>>();
        if (resourceSet != null) {
            for (Resource resource : resourceSet.getResource()) {
                for (Part part : resource.getPart()) {
                    Field[] fields;
                    for (Field field : fields = FieldUtils.getAllFields(Part.class)) {
                        if (FieldUtils.readField((Field)field, (Object)part, (boolean)true) == null || field.getName().equals("otherAttributes")) continue;
                        String partKey = field.getAnnotation(XmlAttribute.class).name();
                        Object value = FieldUtils.readField((Field)field, (Object)part, (boolean)true);
                        if (!partKeyValues.containsKey(partKey)) {
                            partKeyValues.put(partKey, new ArrayList());
                        }
                        if (((List)partKeyValues.get(partKey)).contains(value)) continue;
                        ((List)partKeyValues.get(partKey)).add(value);
                    }
                }
            }
        }
        return partKeyValues;
    }

    public static List<Resource> getResourcesByPartKeys(ResourceSet resourceSet, String ... partKeys) {
        ArrayList<Resource> result = new ArrayList<Resource>();
        block0: for (Resource resource : resourceSet.getResource()) {
            for (Part resPart : resource.getPart()) {
                Set resourceKeysSet = Partitions.getPartitionKeys(resPart).stream().map(String::toLowerCase).collect(Collectors.toSet());
                Set partKeysSet = Arrays.stream(partKeys).map(String::toLowerCase).collect(Collectors.toSet());
                if (!partKeysSet.containsAll(resourceKeysSet) || !resourceKeysSet.containsAll(partKeysSet)) continue;
                result.add(resource);
                continue block0;
            }
        }
        return result;
    }

    public static Resource getResourceByPart(ResourceSet resourceSet, Part part) {
        for (Resource resource : resourceSet.getResource()) {
            if (resource.getPart().size() == 0) {
                return resource;
            }
            for (Part resPart : resource.getPart()) {
                Set<String> resourceKeys;
                Set<String> givenKeys = Partitions.getPartitionKeys(part);
                if (!givenKeys.containsAll(resourceKeys = Partitions.getPartitionKeys(resPart))) continue;
                boolean isSelected = true;
                for (String resourceKey : resourceKeys) {
                    if (!isSelected) continue;
                    isSelected = Partitions.comparePartKeyValues(resourceKey, resPart, part);
                }
                if (!isSelected) continue;
                return resource;
            }
        }
        return null;
    }

    private static boolean comparePartKeyValues(String fieldName, Part resourcePart, Part givenPart) {
        try {
            Object resValue = FieldUtils.readField((Object)resourcePart, (String)fieldName, (boolean)true);
            Object givenValue = FieldUtils.readField((Object)givenPart, (String)fieldName, (boolean)true);
            return resValue.equals(givenValue);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static Set<String> getPartitionKeys(Part part) {
        HashSet<String> partKeys = new HashSet<String>();
        if (part != null) {
            Field[] fields;
            for (Field field : fields = FieldUtils.getAllFields(Part.class)) {
                try {
                    if (FieldUtils.readField((Field)field, (Object)part, (boolean)true) == null || field.getName().equals("otherAttributes")) continue;
                    partKeys.add(field.getName());
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException(ex);
                }
            }
        }
        return partKeys;
    }

    public static boolean hasMismatchingAttributes(@NotNull Part partition1, @NotNull Part partition2) {
        for (Method method : GETTERS) {
            try {
                Object partAttr2;
                Object partAttr1 = method.invoke((Object)partition1, new Object[0]);
                if (Partitions.isEmptyAttributeValue(partAttr1) || Partitions.isEmptyAttributeValue(partAttr2 = method.invoke((Object)partition2, new Object[0])) || partAttr1.equals(partAttr2)) continue;
                return true;
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not access public getter method.", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not invoke getter of Part object.", e);
            }
        }
        return false;
    }

    private static boolean isEmptyAttributeValue(@Nullable Object attribute) {
        if (attribute instanceof List) {
            return ((List)attribute).isEmpty();
        }
        return attribute == null;
    }

    @NotNull
    static List<Method> readGetters() {
        ArrayList<Method> getters = new ArrayList<Method>();
        for (Method method : Part.class.getMethods()) {
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || !method.getDeclaringClass().equals(Part.class)) continue;
            getters.add(method);
        }
        return getters;
    }
}

