/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.cip4.lib.xjdf.XJdfDocument;
import org.cip4.lib.xjdf.XJmfMessage;
import org.cip4.lib.xjdf.exception.XJdfInitException;
import org.cip4.lib.xjdf.exception.XJdfParseException;
import org.cip4.lib.xjdf.exception.XJdfValidationException;
import org.cip4.lib.xjdf.type.URI;
import org.jetbrains.annotations.NotNull;

public class XJmfZipPackage {
    private final Map<URI, byte[]> files;
    private static final URI URI_ROOT_XJMF = XJmfZipPackage.initUriRootXJMF();

    private static URI initUriRootXJMF() {
        try {
            return new URI("root.xjmf");
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public XJmfZipPackage() {
        this.files = Collections.unmodifiableMap(new HashMap());
    }

    public XJmfZipPackage(XJmfMessage rootJmf) throws XJdfValidationException, XJdfParseException {
        this(rootJmf, new HashMap<URI, XJdfDocument>(), new HashMap<URI, byte[]>());
    }

    public XJmfZipPackage(XJmfMessage rootJmf, @NotNull Map<URI, XJdfDocument> xJdfDocuments) throws XJdfValidationException, XJdfParseException {
        this(rootJmf, xJdfDocuments, new HashMap<URI, byte[]>());
    }

    public XJmfZipPackage(XJmfMessage rootJmf, @NotNull Map<URI, XJdfDocument> xJdfDocuments, @NotNull Map<URI, byte[]> files) throws XJdfValidationException, XJdfParseException {
        HashMap<URI, byte[]> fileMap = new HashMap<URI, byte[]>();
        fileMap.put(URI_ROOT_XJMF, rootJmf.toXml());
        for (URI uri : xJdfDocuments.keySet()) {
            fileMap.put(uri, xJdfDocuments.get((Object)uri).toXml());
        }
        for (URI uri : files.keySet()) {
            fileMap.put(uri, files.get((Object)uri));
        }
        this.files = Collections.unmodifiableMap(fileMap);
    }

    public XJmfZipPackage(byte[] zipArchive) throws IOException, URISyntaxException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(zipArchive);
             ZipInputStream packageStream = new ZipInputStream(byteArrayInputStream);){
            ZipEntry entry = packageStream.getNextEntry();
            HashMap<URI, byte[]> files = new HashMap<URI, byte[]>();
            while (entry != null) {
                files.put(new URI(entry.getName()), packageStream.readAllBytes());
                entry = packageStream.getNextEntry();
            }
            this.files = Collections.unmodifiableMap(files);
        }
    }

    public Set<URI> listFiles() {
        return this.files.keySet();
    }

    public byte[] getFile(String uri) throws URISyntaxException {
        return this.getFile(new URI(uri));
    }

    public byte[] getFile(URI uri) {
        return this.files.get((Object)uri);
    }

    public XJdfDocument getXJdfDocument(String uri) throws XJdfInitException, XJdfParseException, URISyntaxException {
        return new XJdfDocument(this.getFile(uri));
    }

    public XJdfDocument getXJdfDocument(URI uri) throws XJdfInitException, XJdfParseException {
        return new XJdfDocument(this.getFile(uri));
    }

    public XJmfMessage getXJmfRoot() throws XJdfInitException, XJdfParseException {
        return new XJmfMessage(this.getFile(URI_ROOT_XJMF));
    }

    public byte[] packageFiles() throws IOException {
        byte[] result;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ZipOutputStream packageStream = new ZipOutputStream(byteArrayOutputStream);){
            for (URI uri : this.files.keySet()) {
                ZipEntry zipEntry = new ZipEntry(uri.toString());
                packageStream.putNextEntry(zipEntry);
                packageStream.write(this.files.get((Object)uri));
                packageStream.closeEntry();
            }
            packageStream.close();
            result = byteArrayOutputStream.toByteArray();
        }
        return result;
    }

    public static class Builder {
        private XJmfMessage xjmfRoot;
        private final Map<URI, XJdfDocument> xJdfDocumentMap = new HashMap<URI, XJdfDocument>();
        private final Map<URI, byte[]> fileMap = new HashMap<URI, byte[]>();

        public Builder withXJmfRoot(XJmfMessage xJmfRoot) {
            this.xjmfRoot = xJmfRoot;
            return this;
        }

        public Builder withXJdfDocument(URI uri, XJdfDocument xJdfDocument) {
            this.xJdfDocumentMap.put(uri, xJdfDocument);
            return this;
        }

        public Builder withFile(URI uri, byte[] bytes) {
            this.fileMap.put(uri, bytes);
            return this;
        }

        public XJmfZipPackage build() throws XJdfValidationException, XJdfParseException {
            return new XJmfZipPackage(this.xjmfRoot, this.xJdfDocumentMap, this.fileMap);
        }
    }
}

