/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.AssemblySection;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Assembly", propOrder={"assemblySection"})
@XmlRootElement(name="Assembly")
public class Assembly
extends SpecificResource
implements Serializable {
    @XmlElement(name="AssemblySection")
    protected List<AssemblySection> assemblySection;
    @XmlAttribute(name="BinderySignatureIDs")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> binderySignatureIDs;
    @XmlAttribute(name="Order", required=true)
    protected Order order;

    public List<AssemblySection> getAssemblySection() {
        if (this.assemblySection == null) {
            this.assemblySection = new ArrayList<AssemblySection>();
        }
        return this.assemblySection;
    }

    public List<String> getBinderySignatureIDs() {
        if (this.binderySignatureIDs == null) {
            this.binderySignatureIDs = new ArrayList<String>();
        }
        return this.binderySignatureIDs;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setOrder(Order value) {
        this.order = value;
    }

    public Assembly withAssemblySection(AssemblySection ... values) {
        if (values != null) {
            for (AssemblySection value : values) {
                this.getAssemblySection().add(value);
            }
        }
        return this;
    }

    public Assembly withAssemblySection(Collection<AssemblySection> values) {
        if (values != null) {
            this.getAssemblySection().addAll(values);
        }
        return this;
    }

    public Assembly withBinderySignatureIDs(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getBinderySignatureIDs().add(value);
            }
        }
        return this;
    }

    public Assembly withBinderySignatureIDs(Collection<String> values) {
        if (values != null) {
            this.getBinderySignatureIDs().addAll(values);
        }
        return this;
    }

    public Assembly withOrder(Order value) {
        this.setOrder(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<String> rightBinderySignatureIDs;
        List<AssemblySection> rightAssemblySection;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Assembly that = (Assembly)object;
        List<AssemblySection> leftAssemblySection = this.assemblySection != null && !this.assemblySection.isEmpty() ? this.getAssemblySection() : null;
        List<AssemblySection> list = rightAssemblySection = that.assemblySection != null && !that.assemblySection.isEmpty() ? that.getAssemblySection() : null;
        if (this.assemblySection != null && !this.assemblySection.isEmpty()) {
            if (that.assemblySection == null || that.assemblySection.isEmpty()) return false;
            if (!leftAssemblySection.equals(rightAssemblySection)) {
                return false;
            }
        } else if (that.assemblySection != null && !that.assemblySection.isEmpty()) {
            return false;
        }
        List<String> leftBinderySignatureIDs = this.binderySignatureIDs != null && !this.binderySignatureIDs.isEmpty() ? this.getBinderySignatureIDs() : null;
        List<String> list2 = rightBinderySignatureIDs = that.binderySignatureIDs != null && !that.binderySignatureIDs.isEmpty() ? that.getBinderySignatureIDs() : null;
        if (this.binderySignatureIDs != null && !this.binderySignatureIDs.isEmpty()) {
            if (that.binderySignatureIDs == null || that.binderySignatureIDs.isEmpty()) return false;
            if (!leftBinderySignatureIDs.equals(rightBinderySignatureIDs)) {
                return false;
            }
        } else if (that.binderySignatureIDs != null && !that.binderySignatureIDs.isEmpty()) {
            return false;
        }
        Order leftOrder = this.getOrder();
        Order rightOrder = that.getOrder();
        if (this.order != null) {
            if (that.order == null) return false;
            if (leftOrder.equals((Object)rightOrder)) return true;
            return false;
        }
        if (that.order == null) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<String> theBinderySignatureIDs;
        List<AssemblySection> theAssemblySection;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        List<AssemblySection> list = theAssemblySection = this.assemblySection != null && !this.assemblySection.isEmpty() ? this.getAssemblySection() : null;
        if (this.assemblySection != null && !this.assemblySection.isEmpty()) {
            currentHashCode += theAssemblySection.hashCode();
        }
        currentHashCode *= 31;
        List<String> list2 = theBinderySignatureIDs = this.binderySignatureIDs != null && !this.binderySignatureIDs.isEmpty() ? this.getBinderySignatureIDs() : null;
        if (this.binderySignatureIDs != null && !this.binderySignatureIDs.isEmpty()) {
            currentHashCode += theBinderySignatureIDs.hashCode();
        }
        currentHashCode *= 31;
        Order theOrder = this.getOrder();
        if (this.order != null) {
            currentHashCode += theOrder.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum Order {
        COLLECTING("Collecting"),
        GATHERING("Gathering"),
        NONE("None"),
        LIST("List");

        private final String value;

        private Order(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static Order fromValue(String v) {
            for (Order c : Order.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

