/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.Band;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"band"})
@XmlRootElement(name="ByteMap")
public class ByteMap
implements Serializable {
    @XmlElement(name="Band")
    protected Band band;
    @XmlAttribute(name="BandOrdering")
    protected BandOrdering bandOrdering;
    @XmlAttribute(name="FrameHeight")
    protected Integer frameHeight;
    @XmlAttribute(name="FrameWidth")
    protected Integer frameWidth;
    @XmlAttribute(name="Halftoned")
    protected Boolean halftoned;
    @XmlAttribute(name="Interleaved")
    protected Boolean interleaved;
    @XmlAttribute(name="PixelColorants")
    @XmlSchemaType(name="NMTOKENS")
    protected List<String> pixelColorants;
    @XmlAttribute(name="PixelDepth")
    protected Integer pixelDepth;
    @XmlAttribute(name="PixelSkip")
    protected Integer pixelSkip;
    @XmlAttribute(name="Resolution")
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair resolution;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Band getBand() {
        return this.band;
    }

    public void setBand(Band value) {
        this.band = value;
    }

    public BandOrdering getBandOrdering() {
        return this.bandOrdering;
    }

    public void setBandOrdering(BandOrdering value) {
        this.bandOrdering = value;
    }

    public Integer getFrameHeight() {
        return this.frameHeight;
    }

    public void setFrameHeight(Integer value) {
        this.frameHeight = value;
    }

    public Integer getFrameWidth() {
        return this.frameWidth;
    }

    public void setFrameWidth(Integer value) {
        this.frameWidth = value;
    }

    public Boolean isHalftoned() {
        return this.halftoned;
    }

    public void setHalftoned(Boolean value) {
        this.halftoned = value;
    }

    public Boolean isInterleaved() {
        return this.interleaved;
    }

    public void setInterleaved(Boolean value) {
        this.interleaved = value;
    }

    public List<String> getPixelColorants() {
        if (this.pixelColorants == null) {
            this.pixelColorants = new ArrayList<String>();
        }
        return this.pixelColorants;
    }

    public Integer getPixelDepth() {
        return this.pixelDepth;
    }

    public void setPixelDepth(Integer value) {
        this.pixelDepth = value;
    }

    public Integer getPixelSkip() {
        return this.pixelSkip;
    }

    public void setPixelSkip(Integer value) {
        this.pixelSkip = value;
    }

    public XYPair getResolution() {
        return this.resolution;
    }

    public void setResolution(XYPair value) {
        this.resolution = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public ByteMap withBand(Band value) {
        this.setBand(value);
        return this;
    }

    public ByteMap withBandOrdering(BandOrdering value) {
        this.setBandOrdering(value);
        return this;
    }

    public ByteMap withFrameHeight(Integer value) {
        this.setFrameHeight(value);
        return this;
    }

    public ByteMap withFrameWidth(Integer value) {
        this.setFrameWidth(value);
        return this;
    }

    public ByteMap withHalftoned(Boolean value) {
        this.setHalftoned(value);
        return this;
    }

    public ByteMap withInterleaved(Boolean value) {
        this.setInterleaved(value);
        return this;
    }

    public ByteMap withPixelColorants(String ... values) {
        if (values != null) {
            for (String value : values) {
                this.getPixelColorants().add(value);
            }
        }
        return this;
    }

    public ByteMap withPixelColorants(Collection<String> values) {
        if (values != null) {
            this.getPixelColorants().addAll(values);
        }
        return this;
    }

    public ByteMap withPixelDepth(Integer value) {
        this.setPixelDepth(value);
        return this;
    }

    public ByteMap withPixelSkip(Integer value) {
        this.setPixelSkip(value);
        return this;
    }

    public ByteMap withResolution(XYPair value) {
        this.setResolution(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<String> rightPixelColorants;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        ByteMap that = (ByteMap)object;
        Band leftBand = this.getBand();
        Band rightBand = that.getBand();
        if (this.band != null) {
            if (that.band == null) return false;
            if (!leftBand.equals(rightBand)) {
                return false;
            }
        } else if (that.band != null) {
            return false;
        }
        BandOrdering leftBandOrdering = this.getBandOrdering();
        BandOrdering rightBandOrdering = that.getBandOrdering();
        if (this.bandOrdering != null) {
            if (that.bandOrdering == null) return false;
            if (!leftBandOrdering.equals((Object)rightBandOrdering)) {
                return false;
            }
        } else if (that.bandOrdering != null) {
            return false;
        }
        Integer leftFrameHeight = this.getFrameHeight();
        Integer rightFrameHeight = that.getFrameHeight();
        if (this.frameHeight != null) {
            if (that.frameHeight == null) return false;
            if (!leftFrameHeight.equals(rightFrameHeight)) {
                return false;
            }
        } else if (that.frameHeight != null) {
            return false;
        }
        Integer leftFrameWidth = this.getFrameWidth();
        Integer rightFrameWidth = that.getFrameWidth();
        if (this.frameWidth != null) {
            if (that.frameWidth == null) return false;
            if (!leftFrameWidth.equals(rightFrameWidth)) {
                return false;
            }
        } else if (that.frameWidth != null) {
            return false;
        }
        Boolean leftHalftoned = this.isHalftoned();
        Boolean rightHalftoned = that.isHalftoned();
        if (this.halftoned != null) {
            if (that.halftoned == null) return false;
            if (!leftHalftoned.equals(rightHalftoned)) {
                return false;
            }
        } else if (that.halftoned != null) {
            return false;
        }
        Boolean leftInterleaved = this.isInterleaved();
        Boolean rightInterleaved = that.isInterleaved();
        if (this.interleaved != null) {
            if (that.interleaved == null) return false;
            if (!leftInterleaved.equals(rightInterleaved)) {
                return false;
            }
        } else if (that.interleaved != null) {
            return false;
        }
        List<String> leftPixelColorants = this.pixelColorants != null && !this.pixelColorants.isEmpty() ? this.getPixelColorants() : null;
        List<String> list = rightPixelColorants = that.pixelColorants != null && !that.pixelColorants.isEmpty() ? that.getPixelColorants() : null;
        if (this.pixelColorants != null && !this.pixelColorants.isEmpty()) {
            if (that.pixelColorants == null || that.pixelColorants.isEmpty()) return false;
            if (!leftPixelColorants.equals(rightPixelColorants)) {
                return false;
            }
        } else if (that.pixelColorants != null && !that.pixelColorants.isEmpty()) {
            return false;
        }
        Integer leftPixelDepth = this.getPixelDepth();
        Integer rightPixelDepth = that.getPixelDepth();
        if (this.pixelDepth != null) {
            if (that.pixelDepth == null) return false;
            if (!leftPixelDepth.equals(rightPixelDepth)) {
                return false;
            }
        } else if (that.pixelDepth != null) {
            return false;
        }
        Integer leftPixelSkip = this.getPixelSkip();
        Integer rightPixelSkip = that.getPixelSkip();
        if (this.pixelSkip != null) {
            if (that.pixelSkip == null) return false;
            if (!leftPixelSkip.equals(rightPixelSkip)) {
                return false;
            }
        } else if (that.pixelSkip != null) {
            return false;
        }
        XYPair leftResolution = this.getResolution();
        XYPair rightResolution = that.getResolution();
        if (this.resolution != null) {
            if (that.resolution == null) return false;
            if (leftResolution.equals((Object)rightResolution)) return true;
            return false;
        }
        if (that.resolution == null) return true;
        return false;
    }

    public int hashCode() {
        List<String> thePixelColorants;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Band theBand = this.getBand();
        if (this.band != null) {
            currentHashCode += theBand.hashCode();
        }
        currentHashCode *= 31;
        BandOrdering theBandOrdering = this.getBandOrdering();
        if (this.bandOrdering != null) {
            currentHashCode += theBandOrdering.hashCode();
        }
        currentHashCode *= 31;
        Integer theFrameHeight = this.getFrameHeight();
        if (this.frameHeight != null) {
            currentHashCode += theFrameHeight.hashCode();
        }
        currentHashCode *= 31;
        Integer theFrameWidth = this.getFrameWidth();
        if (this.frameWidth != null) {
            currentHashCode += theFrameWidth.hashCode();
        }
        currentHashCode *= 31;
        Boolean theHalftoned = this.isHalftoned();
        if (this.halftoned != null) {
            currentHashCode += theHalftoned.hashCode();
        }
        currentHashCode *= 31;
        Boolean theInterleaved = this.isInterleaved();
        if (this.interleaved != null) {
            currentHashCode += theInterleaved.hashCode();
        }
        currentHashCode *= 31;
        List<String> list = thePixelColorants = this.pixelColorants != null && !this.pixelColorants.isEmpty() ? this.getPixelColorants() : null;
        if (this.pixelColorants != null && !this.pixelColorants.isEmpty()) {
            currentHashCode += thePixelColorants.hashCode();
        }
        currentHashCode *= 31;
        Integer thePixelDepth = this.getPixelDepth();
        if (this.pixelDepth != null) {
            currentHashCode += thePixelDepth.hashCode();
        }
        currentHashCode *= 31;
        Integer thePixelSkip = this.getPixelSkip();
        if (this.pixelSkip != null) {
            currentHashCode += thePixelSkip.hashCode();
        }
        currentHashCode *= 31;
        XYPair theResolution = this.getResolution();
        if (this.resolution != null) {
            currentHashCode += theResolution.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum BandOrdering {
        BAND_MAJOR("BandMajor"),
        COLOR_MAJOR("ColorMajor");

        private final String value;

        private BandOrdering(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static BandOrdering fromValue(String v) {
            for (BandOrdering c : BandOrdering.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

