/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSchemaType;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.CollapsedStringAdapter;
import jakarta.xml.bind.annotation.adapters.HexBinaryAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.cip4.lib.xjdf.schema.ColorMeasurementConditions;
import org.cip4.lib.xjdf.schema.DeviceNColor;
import org.cip4.lib.xjdf.schema.SpecificResource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="Color", propOrder={"colorMeasurementConditions", "deviceNColor"})
@XmlRootElement(name="Color")
public class Color
extends SpecificResource
implements Serializable {
    @XmlElement(name="ColorMeasurementConditions")
    protected ColorMeasurementConditions colorMeasurementConditions;
    @XmlElement(name="DeviceNColor")
    protected List<DeviceNColor> deviceNColor;
    @XmlAttribute(name="ActualColorName")
    protected String actualColorName;
    @XmlAttribute(name="CMYK")
    protected List<Float> cmyk;
    @XmlAttribute(name="ColorBook")
    protected String colorBook;
    @XmlAttribute(name="ColorBookEntry")
    protected String colorBookEntry;
    @XmlAttribute(name="ColorDetails")
    protected String colorDetails;
    @XmlAttribute(name="ColorName")
    protected String colorName;
    @XmlAttribute(name="ColorType")
    protected ColorType colorType;
    @XmlAttribute(name="ColorTypeDetails")
    protected String colorTypeDetails;
    @XmlAttribute(name="Density")
    protected Float density;
    @XmlAttribute(name="Gray")
    protected Float gray;
    @XmlAttribute(name="Lab")
    protected List<Float> lab;
    @XmlAttribute(name="NeutralDensity")
    protected Float neutralDensity;
    @XmlAttribute(name="PrintingTechnology")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlSchemaType(name="NMTOKEN")
    protected String printingTechnology;
    @XmlAttribute(name="PrintStandard")
    protected String printStandard;
    @XmlAttribute(name="RawName")
    @XmlJavaTypeAdapter(value=HexBinaryAdapter.class)
    @XmlSchemaType(name="hexBinary")
    protected byte[] rawName;
    @XmlAttribute(name="Spectrum")
    protected List<Float> spectrum;
    @XmlAttribute(name="sRGB")
    protected List<Float> srgb;

    public ColorMeasurementConditions getColorMeasurementConditions() {
        return this.colorMeasurementConditions;
    }

    public void setColorMeasurementConditions(ColorMeasurementConditions value) {
        this.colorMeasurementConditions = value;
    }

    public List<DeviceNColor> getDeviceNColor() {
        if (this.deviceNColor == null) {
            this.deviceNColor = new ArrayList<DeviceNColor>();
        }
        return this.deviceNColor;
    }

    public String getActualColorName() {
        return this.actualColorName;
    }

    public void setActualColorName(String value) {
        this.actualColorName = value;
    }

    public List<Float> getCMYK() {
        if (this.cmyk == null) {
            this.cmyk = new ArrayList<Float>();
        }
        return this.cmyk;
    }

    public String getColorBook() {
        return this.colorBook;
    }

    public void setColorBook(String value) {
        this.colorBook = value;
    }

    public String getColorBookEntry() {
        return this.colorBookEntry;
    }

    public void setColorBookEntry(String value) {
        this.colorBookEntry = value;
    }

    public String getColorDetails() {
        return this.colorDetails;
    }

    public void setColorDetails(String value) {
        this.colorDetails = value;
    }

    public String getColorName() {
        return this.colorName;
    }

    public void setColorName(String value) {
        this.colorName = value;
    }

    public ColorType getColorType() {
        return this.colorType;
    }

    public void setColorType(ColorType value) {
        this.colorType = value;
    }

    public String getColorTypeDetails() {
        return this.colorTypeDetails;
    }

    public void setColorTypeDetails(String value) {
        this.colorTypeDetails = value;
    }

    public Float getDensity() {
        return this.density;
    }

    public void setDensity(Float value) {
        this.density = value;
    }

    public Float getGray() {
        return this.gray;
    }

    public void setGray(Float value) {
        this.gray = value;
    }

    public List<Float> getLab() {
        if (this.lab == null) {
            this.lab = new ArrayList<Float>();
        }
        return this.lab;
    }

    public Float getNeutralDensity() {
        return this.neutralDensity;
    }

    public void setNeutralDensity(Float value) {
        this.neutralDensity = value;
    }

    public String getPrintingTechnology() {
        return this.printingTechnology;
    }

    public void setPrintingTechnology(String value) {
        this.printingTechnology = value;
    }

    public String getPrintStandard() {
        return this.printStandard;
    }

    public void setPrintStandard(String value) {
        this.printStandard = value;
    }

    public byte[] getRawName() {
        return this.rawName;
    }

    public void setRawName(byte[] value) {
        this.rawName = value;
    }

    public List<Float> getSpectrum() {
        if (this.spectrum == null) {
            this.spectrum = new ArrayList<Float>();
        }
        return this.spectrum;
    }

    public List<Float> getSRGB() {
        if (this.srgb == null) {
            this.srgb = new ArrayList<Float>();
        }
        return this.srgb;
    }

    public Color withColorMeasurementConditions(ColorMeasurementConditions value) {
        this.setColorMeasurementConditions(value);
        return this;
    }

    public Color withDeviceNColor(DeviceNColor ... values) {
        if (values != null) {
            for (DeviceNColor value : values) {
                this.getDeviceNColor().add(value);
            }
        }
        return this;
    }

    public Color withDeviceNColor(Collection<DeviceNColor> values) {
        if (values != null) {
            this.getDeviceNColor().addAll(values);
        }
        return this;
    }

    public Color withActualColorName(String value) {
        this.setActualColorName(value);
        return this;
    }

    public Color withCMYK(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getCMYK().add(value);
            }
        }
        return this;
    }

    public Color withCMYK(Collection<Float> values) {
        if (values != null) {
            this.getCMYK().addAll(values);
        }
        return this;
    }

    public Color withColorBook(String value) {
        this.setColorBook(value);
        return this;
    }

    public Color withColorBookEntry(String value) {
        this.setColorBookEntry(value);
        return this;
    }

    public Color withColorDetails(String value) {
        this.setColorDetails(value);
        return this;
    }

    public Color withColorName(String value) {
        this.setColorName(value);
        return this;
    }

    public Color withColorType(ColorType value) {
        this.setColorType(value);
        return this;
    }

    public Color withColorTypeDetails(String value) {
        this.setColorTypeDetails(value);
        return this;
    }

    public Color withDensity(Float value) {
        this.setDensity(value);
        return this;
    }

    public Color withGray(Float value) {
        this.setGray(value);
        return this;
    }

    public Color withLab(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getLab().add(value);
            }
        }
        return this;
    }

    public Color withLab(Collection<Float> values) {
        if (values != null) {
            this.getLab().addAll(values);
        }
        return this;
    }

    public Color withNeutralDensity(Float value) {
        this.setNeutralDensity(value);
        return this;
    }

    public Color withPrintingTechnology(String value) {
        this.setPrintingTechnology(value);
        return this;
    }

    public Color withPrintStandard(String value) {
        this.setPrintStandard(value);
        return this;
    }

    public Color withRawName(byte[] value) {
        this.setRawName(value);
        return this;
    }

    public Color withSpectrum(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getSpectrum().add(value);
            }
        }
        return this;
    }

    public Color withSpectrum(Collection<Float> values) {
        if (values != null) {
            this.getSpectrum().addAll(values);
        }
        return this;
    }

    public Color withSRGB(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getSRGB().add(value);
            }
        }
        return this;
    }

    public Color withSRGB(Collection<Float> values) {
        if (values != null) {
            this.getSRGB().addAll(values);
        }
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object object) {
        List<Float> rightSRGB;
        List<Float> rightSpectrum;
        List<Float> rightLab;
        List<Float> rightCMYK;
        List<DeviceNColor> rightDeviceNColor;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        Color that = (Color)object;
        ColorMeasurementConditions leftColorMeasurementConditions = this.getColorMeasurementConditions();
        ColorMeasurementConditions rightColorMeasurementConditions = that.getColorMeasurementConditions();
        if (this.colorMeasurementConditions != null) {
            if (that.colorMeasurementConditions == null) return false;
            if (!leftColorMeasurementConditions.equals(rightColorMeasurementConditions)) {
                return false;
            }
        } else if (that.colorMeasurementConditions != null) {
            return false;
        }
        List<DeviceNColor> leftDeviceNColor = this.deviceNColor != null && !this.deviceNColor.isEmpty() ? this.getDeviceNColor() : null;
        List<DeviceNColor> list = rightDeviceNColor = that.deviceNColor != null && !that.deviceNColor.isEmpty() ? that.getDeviceNColor() : null;
        if (this.deviceNColor != null && !this.deviceNColor.isEmpty()) {
            if (that.deviceNColor == null || that.deviceNColor.isEmpty()) return false;
            if (!leftDeviceNColor.equals(rightDeviceNColor)) {
                return false;
            }
        } else if (that.deviceNColor != null && !that.deviceNColor.isEmpty()) {
            return false;
        }
        String leftActualColorName = this.getActualColorName();
        String rightActualColorName = that.getActualColorName();
        if (this.actualColorName != null) {
            if (that.actualColorName == null) return false;
            if (!leftActualColorName.equals(rightActualColorName)) {
                return false;
            }
        } else if (that.actualColorName != null) {
            return false;
        }
        List<Float> leftCMYK = this.cmyk != null && !this.cmyk.isEmpty() ? this.getCMYK() : null;
        List<Float> list2 = rightCMYK = that.cmyk != null && !that.cmyk.isEmpty() ? that.getCMYK() : null;
        if (this.cmyk != null && !this.cmyk.isEmpty()) {
            if (that.cmyk == null || that.cmyk.isEmpty()) return false;
            if (!leftCMYK.equals(rightCMYK)) {
                return false;
            }
        } else if (that.cmyk != null && !that.cmyk.isEmpty()) {
            return false;
        }
        String leftColorBook = this.getColorBook();
        String rightColorBook = that.getColorBook();
        if (this.colorBook != null) {
            if (that.colorBook == null) return false;
            if (!leftColorBook.equals(rightColorBook)) {
                return false;
            }
        } else if (that.colorBook != null) {
            return false;
        }
        String leftColorBookEntry = this.getColorBookEntry();
        String rightColorBookEntry = that.getColorBookEntry();
        if (this.colorBookEntry != null) {
            if (that.colorBookEntry == null) return false;
            if (!leftColorBookEntry.equals(rightColorBookEntry)) {
                return false;
            }
        } else if (that.colorBookEntry != null) {
            return false;
        }
        String leftColorDetails = this.getColorDetails();
        String rightColorDetails = that.getColorDetails();
        if (this.colorDetails != null) {
            if (that.colorDetails == null) return false;
            if (!leftColorDetails.equals(rightColorDetails)) {
                return false;
            }
        } else if (that.colorDetails != null) {
            return false;
        }
        String leftColorName = this.getColorName();
        String rightColorName = that.getColorName();
        if (this.colorName != null) {
            if (that.colorName == null) return false;
            if (!leftColorName.equals(rightColorName)) {
                return false;
            }
        } else if (that.colorName != null) {
            return false;
        }
        ColorType leftColorType = this.getColorType();
        ColorType rightColorType = that.getColorType();
        if (this.colorType != null) {
            if (that.colorType == null) return false;
            if (!leftColorType.equals((Object)rightColorType)) {
                return false;
            }
        } else if (that.colorType != null) {
            return false;
        }
        String leftColorTypeDetails = this.getColorTypeDetails();
        String rightColorTypeDetails = that.getColorTypeDetails();
        if (this.colorTypeDetails != null) {
            if (that.colorTypeDetails == null) return false;
            if (!leftColorTypeDetails.equals(rightColorTypeDetails)) {
                return false;
            }
        } else if (that.colorTypeDetails != null) {
            return false;
        }
        Float leftDensity = this.getDensity();
        Float rightDensity = that.getDensity();
        if (this.density != null) {
            if (that.density == null) return false;
            if (!leftDensity.equals(rightDensity)) {
                return false;
            }
        } else if (that.density != null) {
            return false;
        }
        Float leftGray = this.getGray();
        Float rightGray = that.getGray();
        if (this.gray != null) {
            if (that.gray == null) return false;
            if (!leftGray.equals(rightGray)) {
                return false;
            }
        } else if (that.gray != null) {
            return false;
        }
        List<Float> leftLab = this.lab != null && !this.lab.isEmpty() ? this.getLab() : null;
        List<Float> list3 = rightLab = that.lab != null && !that.lab.isEmpty() ? that.getLab() : null;
        if (this.lab != null && !this.lab.isEmpty()) {
            if (that.lab == null || that.lab.isEmpty()) return false;
            if (!leftLab.equals(rightLab)) {
                return false;
            }
        } else if (that.lab != null && !that.lab.isEmpty()) {
            return false;
        }
        Float leftNeutralDensity = this.getNeutralDensity();
        Float rightNeutralDensity = that.getNeutralDensity();
        if (this.neutralDensity != null) {
            if (that.neutralDensity == null) return false;
            if (!leftNeutralDensity.equals(rightNeutralDensity)) {
                return false;
            }
        } else if (that.neutralDensity != null) {
            return false;
        }
        String leftPrintingTechnology = this.getPrintingTechnology();
        String rightPrintingTechnology = that.getPrintingTechnology();
        if (this.printingTechnology != null) {
            if (that.printingTechnology == null) return false;
            if (!leftPrintingTechnology.equals(rightPrintingTechnology)) {
                return false;
            }
        } else if (that.printingTechnology != null) {
            return false;
        }
        String leftPrintStandard = this.getPrintStandard();
        String rightPrintStandard = that.getPrintStandard();
        if (this.printStandard != null) {
            if (that.printStandard == null) return false;
            if (!leftPrintStandard.equals(rightPrintStandard)) {
                return false;
            }
        } else if (that.printStandard != null) {
            return false;
        }
        byte[] leftRawName = this.getRawName();
        byte[] rightRawName = that.getRawName();
        if (this.rawName != null) {
            if (that.rawName == null) return false;
            if (!Arrays.equals(leftRawName, rightRawName)) {
                return false;
            }
        } else if (that.rawName != null) {
            return false;
        }
        List<Float> leftSpectrum = this.spectrum != null && !this.spectrum.isEmpty() ? this.getSpectrum() : null;
        List<Float> list4 = rightSpectrum = that.spectrum != null && !that.spectrum.isEmpty() ? that.getSpectrum() : null;
        if (this.spectrum != null && !this.spectrum.isEmpty()) {
            if (that.spectrum == null || that.spectrum.isEmpty()) return false;
            if (!leftSpectrum.equals(rightSpectrum)) {
                return false;
            }
        } else if (that.spectrum != null && !that.spectrum.isEmpty()) {
            return false;
        }
        List<Float> leftSRGB = this.srgb != null && !this.srgb.isEmpty() ? this.getSRGB() : null;
        List<Float> list5 = rightSRGB = that.srgb != null && !that.srgb.isEmpty() ? that.getSRGB() : null;
        if (this.srgb != null && !this.srgb.isEmpty()) {
            if (that.srgb == null || that.srgb.isEmpty()) return false;
            if (leftSRGB.equals(rightSRGB)) return true;
            return false;
        }
        if (that.srgb == null || that.srgb.isEmpty()) return true;
        return false;
    }

    @Override
    public int hashCode() {
        List<Float> theSRGB;
        List<Float> theSpectrum;
        List<Float> theLab;
        List<Float> theCMYK;
        List<DeviceNColor> theDeviceNColor;
        int currentHashCode = 1;
        currentHashCode = currentHashCode * 31 + super.hashCode();
        currentHashCode *= 31;
        ColorMeasurementConditions theColorMeasurementConditions = this.getColorMeasurementConditions();
        if (this.colorMeasurementConditions != null) {
            currentHashCode += theColorMeasurementConditions.hashCode();
        }
        currentHashCode *= 31;
        List<DeviceNColor> list = theDeviceNColor = this.deviceNColor != null && !this.deviceNColor.isEmpty() ? this.getDeviceNColor() : null;
        if (this.deviceNColor != null && !this.deviceNColor.isEmpty()) {
            currentHashCode += theDeviceNColor.hashCode();
        }
        currentHashCode *= 31;
        String theActualColorName = this.getActualColorName();
        if (this.actualColorName != null) {
            currentHashCode += theActualColorName.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list2 = theCMYK = this.cmyk != null && !this.cmyk.isEmpty() ? this.getCMYK() : null;
        if (this.cmyk != null && !this.cmyk.isEmpty()) {
            currentHashCode += theCMYK.hashCode();
        }
        currentHashCode *= 31;
        String theColorBook = this.getColorBook();
        if (this.colorBook != null) {
            currentHashCode += theColorBook.hashCode();
        }
        currentHashCode *= 31;
        String theColorBookEntry = this.getColorBookEntry();
        if (this.colorBookEntry != null) {
            currentHashCode += theColorBookEntry.hashCode();
        }
        currentHashCode *= 31;
        String theColorDetails = this.getColorDetails();
        if (this.colorDetails != null) {
            currentHashCode += theColorDetails.hashCode();
        }
        currentHashCode *= 31;
        String theColorName = this.getColorName();
        if (this.colorName != null) {
            currentHashCode += theColorName.hashCode();
        }
        currentHashCode *= 31;
        ColorType theColorType = this.getColorType();
        if (this.colorType != null) {
            currentHashCode += theColorType.hashCode();
        }
        currentHashCode *= 31;
        String theColorTypeDetails = this.getColorTypeDetails();
        if (this.colorTypeDetails != null) {
            currentHashCode += theColorTypeDetails.hashCode();
        }
        currentHashCode *= 31;
        Float theDensity = this.getDensity();
        if (this.density != null) {
            currentHashCode += theDensity.hashCode();
        }
        currentHashCode *= 31;
        Float theGray = this.getGray();
        if (this.gray != null) {
            currentHashCode += theGray.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list3 = theLab = this.lab != null && !this.lab.isEmpty() ? this.getLab() : null;
        if (this.lab != null && !this.lab.isEmpty()) {
            currentHashCode += theLab.hashCode();
        }
        currentHashCode *= 31;
        Float theNeutralDensity = this.getNeutralDensity();
        if (this.neutralDensity != null) {
            currentHashCode += theNeutralDensity.hashCode();
        }
        currentHashCode *= 31;
        String thePrintingTechnology = this.getPrintingTechnology();
        if (this.printingTechnology != null) {
            currentHashCode += thePrintingTechnology.hashCode();
        }
        currentHashCode *= 31;
        String thePrintStandard = this.getPrintStandard();
        if (this.printStandard != null) {
            currentHashCode += thePrintStandard.hashCode();
        }
        currentHashCode *= 31;
        byte[] theRawName = this.getRawName();
        currentHashCode += Arrays.hashCode(theRawName);
        currentHashCode *= 31;
        List<Float> list4 = theSpectrum = this.spectrum != null && !this.spectrum.isEmpty() ? this.getSpectrum() : null;
        if (this.spectrum != null && !this.spectrum.isEmpty()) {
            currentHashCode += theSpectrum.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list5 = theSRGB = this.srgb != null && !this.srgb.isEmpty() ? this.getSRGB() : null;
        if (this.srgb != null && !this.srgb.isEmpty()) {
            currentHashCode += theSRGB.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ColorType {
        DIE_LINE("DieLine"),
        NORMAL("Normal"),
        OPAQUE("Opaque"),
        OPAQUE_IGNORE("OpaqueIgnore"),
        PRIMER("Primer"),
        TRANSPARENT("Transparent");

        private final String value;

        private ColorType(String v) {
            this.value = v;
        }

        public String value() {
            return this.value;
        }

        public static ColorType fromValue(String v) {
            for (ColorType c : ColorType.values()) {
                if (!c.value.equals(v)) continue;
                return c;
            }
            throw new IllegalArgumentException(v);
        }
    }
}

