/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.schema.DeviceStatus;
import org.cip4.lib.xjdf.schema.FileSpec;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"fileSpec"})
@XmlRootElement(name="Icon")
public class Icon
implements Serializable {
    @XmlElement(name="FileSpec")
    protected FileSpec fileSpec;
    @XmlAttribute(name="BitDepth", required=true)
    protected int bitDepth;
    @XmlAttribute(name="IconUsage")
    protected List<DeviceStatus> iconUsage;
    @XmlAttribute(name="Size", required=true)
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair size;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public void setFileSpec(FileSpec value) {
        this.fileSpec = value;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(int value) {
        this.bitDepth = value;
    }

    public List<DeviceStatus> getIconUsage() {
        if (this.iconUsage == null) {
            this.iconUsage = new ArrayList<DeviceStatus>();
        }
        return this.iconUsage;
    }

    public XYPair getSize() {
        return this.size;
    }

    public void setSize(XYPair value) {
        this.size = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public Icon withFileSpec(FileSpec value) {
        this.setFileSpec(value);
        return this;
    }

    public Icon withBitDepth(int value) {
        this.setBitDepth(value);
        return this;
    }

    public Icon withIconUsage(DeviceStatus ... values) {
        if (values != null) {
            for (DeviceStatus value : values) {
                this.getIconUsage().add(value);
            }
        }
        return this;
    }

    public Icon withIconUsage(Collection<DeviceStatus> values) {
        if (values != null) {
            this.getIconUsage().addAll(values);
        }
        return this;
    }

    public Icon withSize(XYPair value) {
        this.setSize(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<DeviceStatus> rightIconUsage;
        int rightBitDepth;
        int leftBitDepth;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        Icon that = (Icon)object;
        FileSpec leftFileSpec = this.getFileSpec();
        FileSpec rightFileSpec = that.getFileSpec();
        if (this.fileSpec != null) {
            if (that.fileSpec == null) return false;
            if (!leftFileSpec.equals(rightFileSpec)) {
                return false;
            }
        } else if (that.fileSpec != null) {
            return false;
        }
        if ((leftBitDepth = this.getBitDepth()) != (rightBitDepth = that.getBitDepth())) {
            return false;
        }
        List<DeviceStatus> leftIconUsage = this.iconUsage != null && !this.iconUsage.isEmpty() ? this.getIconUsage() : null;
        List<DeviceStatus> list = rightIconUsage = that.iconUsage != null && !that.iconUsage.isEmpty() ? that.getIconUsage() : null;
        if (this.iconUsage != null && !this.iconUsage.isEmpty()) {
            if (that.iconUsage == null || that.iconUsage.isEmpty()) return false;
            if (!leftIconUsage.equals(rightIconUsage)) {
                return false;
            }
        } else if (that.iconUsage != null && !that.iconUsage.isEmpty()) {
            return false;
        }
        XYPair leftSize = this.getSize();
        XYPair rightSize = that.getSize();
        if (this.size != null) {
            if (that.size == null) return false;
            if (leftSize.equals((Object)rightSize)) return true;
            return false;
        }
        if (that.size == null) return true;
        return false;
    }

    public int hashCode() {
        List<DeviceStatus> theIconUsage;
        int currentHashCode = 1;
        currentHashCode *= 31;
        FileSpec theFileSpec = this.getFileSpec();
        if (this.fileSpec != null) {
            currentHashCode += theFileSpec.hashCode();
        }
        currentHashCode *= 31;
        int theBitDepth = this.getBitDepth();
        currentHashCode += theBitDepth;
        currentHashCode *= 31;
        List<DeviceStatus> list = theIconUsage = this.iconUsage != null && !this.iconUsage.isEmpty() ? this.getIconUsage() : null;
        if (this.iconUsage != null && !this.iconUsage.isEmpty()) {
            currentHashCode += theIconUsage.hashCode();
        }
        currentHashCode *= 31;
        XYPair theSize = this.getSize();
        if (this.size != null) {
            currentHashCode += theSize.hashCode();
        }
        return currentHashCode;
    }
}

