/*
 * Decompiled with CFR 0.152.
 */
package org.cip4.lib.xjdf.schema;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAnyAttribute;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.cip4.lib.xjdf.type.XYPair;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="")
@XmlRootElement(name="JPEG2000Params")
public class JPEG2000Params
implements Serializable {
    @XmlAttribute(name="CodeBlockSize")
    protected Integer codeBlockSize;
    @XmlAttribute(name="LayerRates")
    protected List<Float> layerRates;
    @XmlAttribute(name="LayersPerTile")
    protected Integer layersPerTile;
    @XmlAttribute(name="NumResolutions")
    protected Integer numResolutions;
    @XmlAttribute(name="ProgressionOrder")
    protected ProgressionOrder progressionOrder;
    @XmlAttribute(name="TileSize")
    @XmlJavaTypeAdapter(value=XYPair.class)
    protected XYPair tileSize;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Integer getCodeBlockSize() {
        return this.codeBlockSize;
    }

    public void setCodeBlockSize(Integer value) {
        this.codeBlockSize = value;
    }

    public List<Float> getLayerRates() {
        if (this.layerRates == null) {
            this.layerRates = new ArrayList<Float>();
        }
        return this.layerRates;
    }

    public Integer getLayersPerTile() {
        return this.layersPerTile;
    }

    public void setLayersPerTile(Integer value) {
        this.layersPerTile = value;
    }

    public Integer getNumResolutions() {
        return this.numResolutions;
    }

    public void setNumResolutions(Integer value) {
        this.numResolutions = value;
    }

    public ProgressionOrder getProgressionOrder() {
        return this.progressionOrder;
    }

    public void setProgressionOrder(ProgressionOrder value) {
        this.progressionOrder = value;
    }

    public XYPair getTileSize() {
        return this.tileSize;
    }

    public void setTileSize(XYPair value) {
        this.tileSize = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    public JPEG2000Params withCodeBlockSize(Integer value) {
        this.setCodeBlockSize(value);
        return this;
    }

    public JPEG2000Params withLayerRates(Float ... values) {
        if (values != null) {
            for (Float value : values) {
                this.getLayerRates().add(value);
            }
        }
        return this;
    }

    public JPEG2000Params withLayerRates(Collection<Float> values) {
        if (values != null) {
            this.getLayerRates().addAll(values);
        }
        return this;
    }

    public JPEG2000Params withLayersPerTile(Integer value) {
        this.setLayersPerTile(value);
        return this;
    }

    public JPEG2000Params withNumResolutions(Integer value) {
        this.setNumResolutions(value);
        return this;
    }

    public JPEG2000Params withProgressionOrder(ProgressionOrder value) {
        this.setProgressionOrder(value);
        return this;
    }

    public JPEG2000Params withTileSize(XYPair value) {
        this.setTileSize(value);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        List<Float> rightLayerRates;
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (this == object) {
            return true;
        }
        JPEG2000Params that = (JPEG2000Params)object;
        Integer leftCodeBlockSize = this.getCodeBlockSize();
        Integer rightCodeBlockSize = that.getCodeBlockSize();
        if (this.codeBlockSize != null) {
            if (that.codeBlockSize == null) return false;
            if (!leftCodeBlockSize.equals(rightCodeBlockSize)) {
                return false;
            }
        } else if (that.codeBlockSize != null) {
            return false;
        }
        List<Float> leftLayerRates = this.layerRates != null && !this.layerRates.isEmpty() ? this.getLayerRates() : null;
        List<Float> list = rightLayerRates = that.layerRates != null && !that.layerRates.isEmpty() ? that.getLayerRates() : null;
        if (this.layerRates != null && !this.layerRates.isEmpty()) {
            if (that.layerRates == null || that.layerRates.isEmpty()) return false;
            if (!leftLayerRates.equals(rightLayerRates)) {
                return false;
            }
        } else if (that.layerRates != null && !that.layerRates.isEmpty()) {
            return false;
        }
        Integer leftLayersPerTile = this.getLayersPerTile();
        Integer rightLayersPerTile = that.getLayersPerTile();
        if (this.layersPerTile != null) {
            if (that.layersPerTile == null) return false;
            if (!leftLayersPerTile.equals(rightLayersPerTile)) {
                return false;
            }
        } else if (that.layersPerTile != null) {
            return false;
        }
        Integer leftNumResolutions = this.getNumResolutions();
        Integer rightNumResolutions = that.getNumResolutions();
        if (this.numResolutions != null) {
            if (that.numResolutions == null) return false;
            if (!leftNumResolutions.equals(rightNumResolutions)) {
                return false;
            }
        } else if (that.numResolutions != null) {
            return false;
        }
        ProgressionOrder leftProgressionOrder = this.getProgressionOrder();
        ProgressionOrder rightProgressionOrder = that.getProgressionOrder();
        if (this.progressionOrder != null) {
            if (that.progressionOrder == null) return false;
            if (!leftProgressionOrder.equals((Object)rightProgressionOrder)) {
                return false;
            }
        } else if (that.progressionOrder != null) {
            return false;
        }
        XYPair leftTileSize = this.getTileSize();
        XYPair rightTileSize = that.getTileSize();
        if (this.tileSize != null) {
            if (that.tileSize == null) return false;
            if (leftTileSize.equals((Object)rightTileSize)) return true;
            return false;
        }
        if (that.tileSize == null) return true;
        return false;
    }

    public int hashCode() {
        List<Float> theLayerRates;
        int currentHashCode = 1;
        currentHashCode *= 31;
        Integer theCodeBlockSize = this.getCodeBlockSize();
        if (this.codeBlockSize != null) {
            currentHashCode += theCodeBlockSize.hashCode();
        }
        currentHashCode *= 31;
        List<Float> list = theLayerRates = this.layerRates != null && !this.layerRates.isEmpty() ? this.getLayerRates() : null;
        if (this.layerRates != null && !this.layerRates.isEmpty()) {
            currentHashCode += theLayerRates.hashCode();
        }
        currentHashCode *= 31;
        Integer theLayersPerTile = this.getLayersPerTile();
        if (this.layersPerTile != null) {
            currentHashCode += theLayersPerTile.hashCode();
        }
        currentHashCode *= 31;
        Integer theNumResolutions = this.getNumResolutions();
        if (this.numResolutions != null) {
            currentHashCode += theNumResolutions.hashCode();
        }
        currentHashCode *= 31;
        ProgressionOrder theProgressionOrder = this.getProgressionOrder();
        if (this.progressionOrder != null) {
            currentHashCode += theProgressionOrder.hashCode();
        }
        currentHashCode *= 31;
        XYPair theTileSize = this.getTileSize();
        if (this.tileSize != null) {
            currentHashCode += theTileSize.hashCode();
        }
        return currentHashCode;
    }

    @XmlType(name="")
    @XmlEnum
    public static enum ProgressionOrder {
        LRCP,
        RLCP,
        RPCL,
        PCRL,
        CPRL;


        public String value() {
            return this.name();
        }

        public static ProgressionOrder fromValue(String v) {
            return ProgressionOrder.valueOf(v);
        }
    }
}

